<?php
// Connexion à la base de données
$servername = "localhost";
$username = "root";
$password = "rootroot";
$dbname = "fedalasurf";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Requête MySQL
$sql = "SELECT  h.categ, h.nom, h.club, IFNULL(p.photo,'../photos/anonyme.png') AS photo,if(ISNULL(f.code2l),'flags/noflag.png', f.code2l) AS flag, co.title, co.subtitle
FROM heats h
LEFT JOIN (SELECT noc as code3l,replace(flag,'../','') AS code2l  FROM flags
union
SELECT code3l,CONCAT('flags/',code2l,'.svg') AS code2l FROM country ) f ON h.club=f.code3l
LEFT JOIN photos p ON p.competitor=h.nom
left JOIN competition co ON 1=1
WHERE (not h.nom='') 
ORDER BY h.club,h.nom";
$result = $conn->query($sql);

$data = [];
$contestTitle = '';
$subtitle = '';

if ($result->num_rows > 0) {
    // Organisation des données par club
    while($row = $result->fetch_assoc()) {
        if (empty($contestTitle)) {
            $contestTitle = $row['title'];  // Récupère le titre du concours
            $subtitle = $row['subtitle'];          // Récupère le sous-titre
        }
        
        $club = $row['club'];
        if (!isset($data[$club])) {
            $data[$club] = [];
        }
        $data[$club][] = [
            'categorie' => $row['categ'],
            'nom' => $row['nom']
        ];
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Participants par Club</title>
    <style>
        .club-container {
            margin-bottom: 10px;
        }
        .club-name {
            font-weight: bold;
            cursor: pointer;
        }
        .participants-list {
            display: none;
            margin-left: 20px;
        }
        .toggle-button {
            font-size: 18px;
            margin-right: 10px;
            cursor: pointer;
        }
    </style>
</head>
<body>

    <!-- Header -->
    <h1><?php echo $contestTitle; ?></h1>
    <h2><?php echo $subtitle; ?></h2>

    <!-- Liste des clubs -->
    <?php foreach ($data as $club => $participants): ?>
    <div class="club-container">
        <span class="toggle-button" onclick="toggleClub('<?php echo $club; ?>')">+</span>
        <span class="club-name"><?php echo $club; ?></span>
        <div id="<?php echo $club; ?>" class="participants-list">
            <?php foreach ($participants as $participant): ?>
            <p><?php echo $participant['nom'] . " (" . $participant['categorie'] . ")"; ?></p>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endforeach; ?>

    <script>
        function toggleClub(clubId) {
            var list = document.getElementById(clubId);
            var button = list.previousElementSibling.previousElementSibling;

            if (list.style.display === "none") {
                list.style.display = "block";
                button.textContent = "-";
            } else {
                list.style.display = "none";
                button.textContent = "+";
            }
        }
    </script>

</body>
</html>
