  document.addEventListener('DOMContentLoaded', function() {
    // Fonction pour récupérer et afficher la liste des fichiers .fed depuis le serveur
    fetch('list-fed-files.php')
        .then(response => response.json())
        .then(files => {
            const menu = document.getElementById('files-nav');
            files.forEach(file => {
                const fileDiv = document.createElement('div');
                const fileNameWithoutExtension = file.name.replace('.fed', '');
                fileDiv.textContent = fileNameWithoutExtension;
                fileDiv.classList.add('file-entry');
                fileDiv.onclick = () => {
                    // Enlever la classe 'selected' de tous les enfants de 'files-nav'
                    document.querySelectorAll('#files-nav .file-entry').forEach(entry => {
                        entry.classList.remove('selected');
                        loadFileContent(file.path);
                    });
                    // Ajouter la classe 'selected' à l'élément cliqué
                fileDiv.classList.add('selected');

                };
                menu.appendChild(fileDiv);
            });
        });

    // Fonction pour charger le contenu d'un fichier et l'afficher
    window.loadFileContent = function(path) {
        fetch(`get-file-content.php?path=${encodeURIComponent(path)}`)
            .then(response => response.text())
            .then(content => {
                // Parse et affiche le contenu
                const rounds = parseFileContent(content);
                if (rounds.length > 0) {
                    createRoundsNav(rounds);
                    displayMatchesForRound(rounds[0].matches); // Affiche le premier round par défaut
                }
            });
    };


    // Parse le contenu du fichier et structure les données
    function parseFileContent(content) {
    return content.split('head#').filter(round => round.trim()).map(round => {
        let [roundTitle, ...matches] = round.trim().split('\n');
        // Nettoyage du titre pour enlever les retours à la ligne et autres caractères spéciaux
        roundTitle = roundTitle.trim().replace(/[\r\n]+/g, '').replace(/<br \/>/g, '');
        //console.log(matches);
        return {
            title: roundTitle,
            matches: matches.map(match => {
              
                const [meta, ...competitorsInfo] = match.split('@');
                const metaDetails = meta.split('#');
                const heatNumber = metaDetails[2]; // Le numéro de série est à la 3ème position (index 2)

                //console.log(meta);
                return { 
                    heatNumber: heatNumber,
                    competitors: competitorsInfo.map(info => {
                    
                    const details = info.split('#');
                    return {
                        color: details[0],
                        name: details[1],
                        flag: details[2].trim() + '.svg',
                        nationality: details[2].trim(),
                        score: details[3],
                        rank: details[4],
                        imageName: details[1].trim() + '.png'
                    };
                })
            };
        })
    };
})};


    // Création de la barre de navigation pour les rounds
    function createRoundsNav(rounds) {
        const nav = document.getElementById('rounds-nav');
         // Effacez le contenu existant de la barre de navigation
        nav.innerHTML = '';
        rounds.forEach((round, index) => {
            let roundTitle = round.title.trim().replace(/[\r\n]+/g, '').replace(/<br \/>/g, '');
                if (roundTitle.length > 0) {
                const rounddiv = document.createElement('div');
                rounddiv.textContent = round.title;
                rounddiv.classList.add('round-entry');
                rounddiv.onclick = () => {
                    // Enlever la classe 'selected' de tous les enfants de 'files-nav'
                    document.querySelectorAll('#round-nav .round-entry').forEach(entry => {
                        entry.classList.remove('selected');
                        //loadFileContent(file.path);
                    });
                    // Ajouter la classe 'selected' à l'élément cliqué
                rounddiv.classList.add('selected');
                displayMatchesForRound(round.matches);
                };
                    nav.appendChild(rounddiv);
                }
            });
    }

    // Affiche les matches d'un round sélectionné
    function displayMatchesForRound(matches) {
    const container = document.getElementById('matches-container');
    container.innerHTML = ''; // Efface le contenu précédent

    matches.forEach((match, index) => {
        const matchDiv = document.createElement('div');
        matchDiv.classList.add('match');
        matchDiv.innerHTML = `
            <div class='heat-title'>HEAT ${index + 1}</div>
            <div class='heat-details-title'><a href="livescoreshisto.php?heatNumber=${match.heatNumber}" target="_blank">Details</a></div>
        `;

        // Utilisez match.competitors ici src='photos/${competitor.imageName}' onerror="this.src='photos/anonyme.png';"> <img class='competitor-flag' src='flags/${competitor.flag.toLowerCase()}' onerror="this.style.display='none';" >
        match.competitors.forEach(competitor => {
            matchDiv.innerHTML += `
                <div class='heat-competitor'>
                    <div class='competitor-photo-container'>
                        <img class='competitor-img color-${competitor.color.toLowerCase()}' src='photos/${competitor.imageName}'> 
                    </div>
                    <div>
                        <div class='competitor-detail detail-name'>${competitor.name}</div>
                        <div class="nationality">                        
                            <img class='competitor-flag' src='flags/${competitor.flag.toLowerCase()}' onerror="this.style.display='none';" >
                            <div class='competitor-detail detail-country'>${competitor.nationality}</div>
                            <div class='competitor-detail position'>${competitor.rank}</div>
                        </div>
                    </div>
                    <div class='competitor-detail score'>${competitor.score}</div>
                </div>
            `;
        });

        container.appendChild(matchDiv);
    });
}
function openPopup(url) {
    window.open(url, 'popupWindow', 'width=600,height=400,left=100,top=100');
}

    // Exécute le script
    //const rounds = parseFileContent(fileContent);
    //if (rounds.length > 0) {
    //    createRoundsNav(rounds);
    //    displayMatchesForRound(rounds[0].matches); // Affiche le premier round par défaut
    //}
});
