<?php
$sheetId = "1lQwMDsLiVsJVbKafgA8T1WfE2mHRUOdNNrgtI33l-MY"; 
$jsonUrl = "https://docs.google.com/spreadsheets/d/{$sheetId}/gviz/tq?tqx=out:json";

// Initialiser cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $jsonUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

// Nettoyage des données JSON
$json = trim($response, ")]}'\n"); // Supprime les caractères parasites
$json = preg_replace('/google.visualization.Query.setResponse\((.+)\);/', '$1', $json);

// Vérifier si JSON est valide
$data = json_decode($json, true);
if (!$data) {
    die("Erreur JSON: " . json_last_error_msg()); // Affiche l'erreur JSON si invalide
}

// Vérifier si la structure contient des données
if (isset($data['table']['rows'])) {
    $table = $data['table']['rows'];
    
    echo "<table border='1'>";
    foreach ($table as $row) {
        echo "<tr>";
        foreach ($row['c'] as $cell) {
            echo "<td>" . ($cell['v'] ?? 'N/A') . "</td>"; // Remplace les valeurs nulles par 'N/A'
        }
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "Aucune donnée trouvée.";
}
?>
