<?php
include_once 'auth.php';
// Connexion à la base de données MySQL
require 'config_livescores2024.php';


// Récupérer les données envoyées en JSON
$data = json_decode(file_get_contents('php://input'), true);

// Vérifier si les données nécessaires sont présentes
if (isset($data['serie'], $data['concu'], $data['judge'], $data['wave'], $data['note'])) {
    $serie = $data['serie'];
    $concu = $data['concu'];
    $juge = $data['judge'];
    $vague = $data['wave'];
    $note = $data['note'];

    // Vérifier si la note est nulle ou 0
    if (is_null($note) || $note == 0) {
        // Si la note est null ou 0, supprimer la ligne correspondante
        $stmt = $conn->prepare("DELETE FROM resu WHERE serie = ? AND concu = ? AND vague = ? AND juge = ?");
        $stmt->bind_param('iiii', $serie, $concu, $vague, $juge);

        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'action' => 'deleted']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la suppression']);
        }
        
        // Si la note est null ou 0, supprimer la ligne correspondante
        $stmt = $conn->prepare("DELETE FROM resu WHERE serie = ? AND concu = ? AND vague = ? AND juge = ?");
        $stmt->bind_param('iiii', $serie, $concu, $vague, $juge);

        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'action' => 'deleted']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la suppression']);
        }
    } else {
        // Si la note est valide, insérer ou mettre à jour
        $stmt = $conn->prepare("INSERT INTO resu (serie, concu, vague, juge, note) VALUES (?, ?, ?, ?, ?) 
                                ON DUPLICATE KEY UPDATE note = VALUES(note)");
        $stmt->bind_param('iiiid', $serie, $concu, $vague, $juge, $note);

        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'action' => 'updated']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
        }
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Data manquantes']);
}

$conn->close();

?>