<?php
// Connexion à la base de données MySQL
require 'config_livescores2024.php';

// Récupérer les données envoyées en JSON
$data = json_decode(file_get_contents('php://input'), true);

// Vérifier si les données nécessaires sont présentes
if (isset($data['category'], $data['round'], $data['serie'], $data['heat'], $data['srcheat'], $data['srcrank'], $data['ligne'])) {
    $serie = $data['serie'];
    $category = $data['category'];
    $round = $data['round'];
    $heat = $data['heat'];
    $srcheat = $data['srcheat'];
    $srcrank = $data['srcrank'];
    $ligne = $data['ligne'];  // Correction: Ajout du signe '$' devant ligne
    $nullValue = null;
    
    // Vérifier si srcheat ou srcrank sont nuls ou égaux à 0
    if (is_null($srcheat) || $srcheat == 0 || is_null($srcrank) || $srcrank == 0) {
        // Préparer la requête pour mettre à jour srcheat et srcrank à NULL
        $stmt = $conn->prepare("UPDATE heats SET srcheat = ?, srcrank = ? WHERE serie = ? AND ligne = ?");
        // Lier les paramètres avec les variables (incluant NULL pour effacer)
        $stmt->bind_param('iiii', $nullValue, $nullValue, $serie, $ligne);

        // Exécuter la requête et vérifier le résultat
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'action' => 'Données effacées.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
        }

        // Fermer la déclaration préparée
        $stmt->close();
    } else {
        // Si la note est valide, insérer ou mettre à jour
        $stmt = $conn->prepare("
    INSERT INTO heats (categ, serie, round, heat, ligne, srcheat, srcrank)
    VALUES (?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE srcheat = VALUES(srcheat), srcrank = VALUES(srcrank)
");


// Lier les paramètres à la requête
$stmt->bind_param('sisiiii', $category, $serie, $round, $heat, $ligne, $srcheat, $srcrank);


        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'action' => 'updated']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
        }

        $stmt->close();
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Données manquantes']);
}

$conn->close();
?>
