<?php
// /includes/get_ecart.php

function getEcartPondere($conn) {
    $sql = "
       SELECT 
            T3.juge,
            nomjuge,
            COUNT(note) AS nbrenote,
            SUM(ecart) AS somecart,
            100 * SUM(ecart) / COUNT(note) AS ecartpondere
        FROM (
            SELECT 
                T2.serie,
                T2.concu,
                T2.juge,
                nomjuge,
                T2.vague,
                T2.note,
                T2.moyen,
                ROUND(ABS(T2.note - T2.moyen), 2) AS ecart
            FROM (
                SELECT 
                    resu.serie,
                    resu.concu,
                    resu.juge,
                    resu.vague,
                    T1.minot,
                    resu.note,
                    T1.maxnote,
                    T1.moyen
                FROM resu
                RIGHT JOIN (
                    SELECT 
                        resu.serie,
                        concu,
                        juge,
                        vague, 
                        MIN(note) AS minot, 
                        MAX(note) AS maxnote, 
                        CASE 
                            WHEN COUNT(note) > 2 THEN ROUND((SUM(note) - MAX(note) - MIN(note)) / (COUNT(note) - 2), 2) 
                            ELSE 0 
                        END AS moyen
                    FROM resu
                    GROUP BY serie, concu, vague
                ) AS T1 
                ON resu.serie = T1.serie AND resu.vague = T1.vague AND resu.concu = T1.concu
                ORDER BY concu, vague, juge
            ) AS T2
            LEFT JOIN juges ON T2.juge = juges.idjuge
        ) AS T3
        WHERE juge > 0
        GROUP BY juge
        ORDER BY ecartpondere;
    ";

    $result = $conn->query($sql);

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = [
            'nomjuge' => $row['nomjuge'],
            'juge' => $row['juge'],
            'nbrenote' => $row['nbrenote'],
            'somecart' => $row['somecart'],
            'ecartpondere' => $row['ecartpondere']
        ];
    }

    return $data;
}
?>
