<?php
// Inclure la librairie de compatibilité si nécessaire
// require_once 'libs/password_compat.php'; // Si PHP < 5.5

require 'config_connect.php';

// Récupérer tous les utilisateurs
$sql = "SELECT user_id, user_password FROM phpgen_users";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Itérer sur chaque utilisateur
    while ($row = $result->fetch_assoc()) {
        $id = $row['user_id'];
        $mot_de_passe = $row['user_password'];

        // Vérifier si le mot de passe est déjà haché (par exemple, longueur du hash)
        // Vous pouvez adapter cette condition selon votre contexte
        if (strlen($mot_de_passe) < 60) { // bcrypt hashes ont généralement 60 caractères
            // Hacher le mot de passe
            $mot_de_passe_hash = password_hash($mot_de_passe, PASSWORD_DEFAULT);

            // Préparer la requête d'update
            $stmt = $conn->prepare("UPDATE phpgen_users SET user_password = ? WHERE user_id = ?");
            $stmt->bind_param("si", $mot_de_passe_hash, $id);

            if ($stmt->execute()) {
                echo "Mot de passe haché pour l'utilisateur ID: $id<br>";
            } else {
                echo "Erreur pour l'utilisateur ID: $id - " . $stmt->error . "<br>";
            }

            $stmt->close();
        } else {
            echo "Mot de passe déjà haché pour l'utilisateur ID: $id<br>";
        }
    }
} else {
    echo "Aucun utilisateur trouvé.";
}

$conn->close();
?>
