<?php
include_once 'auth.php';

// Connexion à la base de données MySQL
require 'config_livescores2024.php';

header('Content-Type: application/json');


// Connexion à la base de données (vérifiez que vous incluez la connexion à la base)
include 'db_connection.php';

// Récupérer les données envoyées en JSON
$data = json_decode(file_get_contents('php://input'), true);

// Vérifier si les données nécessaires sont présentes
if (isset($data['serie'], $data['concu'], $data['judge'], $data['wave'], $data['note'])) {
    $serie = $data['serie'];
    $concu = $data['concu'];
    $juge = $data['judge'];
    $vague = $data['wave'];
    $note = $data['note'];

    // Vérifier si la note est un nombre valide
    if (is_numeric($note)) {
        // Préparer la requête SQL pour insérer la note
        $stmt = $conn->prepare("INSERT INTO resu (serie, concu, vague, juge, note) VALUES (?, ?, ?, ?, ?)");
        if ($stmt === false) {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la préparation de la requête SQL.']);
            exit;
        }

        // Associer les paramètres à la requête préparée
        $stmt->bind_param('iiiid', $serie, $concu, $vague, $juge, $note);

        // Exécuter la requête et renvoyer la réponse
        if ($stmt->execute()) {
            echo json_encode(['success' => true]);
        } else {
            // Afficher les erreurs SQL en cas de problème
            echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'insertion : ' . $stmt->error]);
        }

        // Fermer la requête préparée
        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'La note doit être un nombre.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Données manquantes.']);
}

// Fermer la connexion
$conn->close();


?>