<?php
include_once 'auth.php';

// Inclure la connexion à la base de données
require_once 'config_livescores2024.php';

// Exécuter la requête pour les statistiques
$sql = "
   SELECT 
    j.nomjuge,
    s.juge,
    SUM(s.longueur_sequence) AS total_heats,
    COUNT(*) AS nbre_sequences,
    MAX(s.longueur_sequence) AS longest_sequence
FROM (
    SELECT 
        juge,
        grp,
        COUNT(*) AS longueur_sequence
    FROM (
        SELECT 
            juge,
            serie,
            (@rn := IF(@prev_juge = juge, @rn + 1, 1)) AS rn,
            (@prev_juge := juge),
            (serie - @rn) AS grp
        FROM (
            SELECT DISTINCT juge, serie
            FROM resu
            ORDER BY juge, serie
        ) AS sorted_resu
        CROSS JOIN (SELECT @rn := 0, @prev_juge := '') AS vars
    ) AS t
    GROUP BY 
        juge, grp
) AS s
JOIN juges j ON s.juge = j.idjuge
GROUP BY 
    s.juge, j.nomjuge
ORDER BY 
    nbre_sequences DESC;


";

$result = $conn->query($sql);

$juges = [];
$total_heats = [];
$nbre_sequences = [];
$longest_sequence = [];

while ($row = $result->fetch_assoc()) {
    $juges[] = $row['nomjuge'];
    $total_heats[] = $row['total_heats'];
    $nbre_sequences[] = $row['nbre_sequences'];
    $longest_sequence[] = $row['longest_sequence'];
}
$conn->close();
?>
