<?php
// Configuration
include_once 'auth.php';
require 'config_livescores2024.php';
$backupDir = __DIR__ . '/backups';





if (!is_dir($backupDir)) mkdir($backupDir, 0777, true);

$msg = '';
$diffResult = '';
$tableCompareResult = '';


// Tables à réinitialiser
$tablesToTruncate = [
    'competitors',
'concu',
'heathisto',
'heats',
'livescores',
'livescores2',
'live_heats',
'live_options',
'live_waves',
'moyennes',
'moyennes_notes',
'moyennes_valides',
'programme',
'resu',
'scores1'
];

// Réinitialisation sécurisée de la base cible
if (isset($_POST['reset_db'], $_POST['reset_target'])) {
    $target = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $_POST['reset_target']);

    try {
        $pdo = new PDO("mysql:host=$host;dbname=$target", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        foreach ($tablesToTruncate as $table) {
            $safeTable = preg_replace('/[^a-zA-Z0-9_\-]/', '', $table);
            $pdo->exec("TRUNCATE TABLE `$safeTable`");
        }

        $msg = "✅ Base <b>$target</b> réinitialisée. Tables vidées : " . implode(', ', $tablesToTruncate);
    } catch (PDOException $e) {
        $msg = "❌ Erreur : " . $e->getMessage();
    }
}




// ➕ Sauvegarde
if (isset($_POST['backup']) && isset($_POST['backup_name'])) {
    $name = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $_POST['backup_name']);
    if (strlen($name) < 1) $name = 'backup';
    $date = date('Ymd_His');
    $backupFile = "$backupDir/{$dbname}_{$name}_$date.sql";
    $cmd = "mysqldump -h $host -u $username -p$password $dbname > $backupFile";
    exec($cmd, $output, $status);
    $msg = $status === 0 ? "✅ Sauvegarde créée : $backupFile" : "❌ Erreur lors de la sauvegarde.";
}

// 🔁 Restauration
if (isset($_POST['restore_file'], $_POST['target_db'])) {
    $restoreFile = basename($_POST['restore_file']);
    $targetDb = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $_POST['target_db']);
    if (strlen($targetDb) < 1) $targetDb = $dbname;
    $fullPath = "$backupDir/$restoreFile";

    if (file_exists($fullPath)) {
        $pdo = new PDO("mysql:host=$host", $username, $password);
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$targetDb`");
        $cmd = "mysql -h $host -u $username -p$password $targetDb < $fullPath";
        exec($cmd, $output, $status);
        $msg = $status === 0
            ? "✅ Restauration dans <b>$targetDb</b> depuis $restoreFile"
            : "❌ Erreur de restauration.";
    } else {
        $msg = "❌ Fichier introuvable.";
    }
}

// 🗑️ Suppression
if (isset($_POST['delete_file'])) {
    $deleteFile = basename($_POST['delete_file']);
    $fullPath = "$backupDir/$deleteFile";
    if (file_exists($fullPath) && unlink($fullPath)) {
        $msg = "🗑️ Supprimé : $deleteFile";
    } else {
        $msg = "❌ Suppression échouée.";
    }
}

// 🔍 Diff brut de fichiers
if (isset($_POST['compare_1'], $_POST['compare_2'])) {
    $f1 = "$backupDir/" . basename($_POST['compare_1']);
    $f2 = "$backupDir/" . basename($_POST['compare_2']);
    if (file_exists($f1) && file_exists($f2)) {
        $cmd = "diff -u " . escapeshellarg($f1) . " " . escapeshellarg($f2);
        $diffResult = shell_exec($cmd);
        if (!$diffResult) $diffResult = "✅ Les fichiers sont identiques.";
    } else {
        $diffResult = "❌ Fichier(s) manquant(s).";
    }
}

// 🧠 Comparaison structure : tables manquantes
if (isset($_POST['table_compare_1'], $_POST['table_compare_2'])) {
    $db1 = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $_POST['table_compare_1']);
    $db2 = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $_POST['table_compare_2']);

    try {
        $pdo = new PDO("mysql:host=$host", $username, $password);
        $tables1 = $pdo->query("SHOW TABLES FROM `$db1`")->fetchAll(PDO::FETCH_COLUMN);
        $tables2 = $pdo->query("SHOW TABLES FROM `$db2`")->fetchAll(PDO::FETCH_COLUMN);

        $onlyIn1 = array_diff($tables1, $tables2);
        $onlyIn2 = array_diff($tables2, $tables1);

        $tableCompareResult = "<strong>Tables uniquement dans <code>$db1</code> :</strong><br>";
        $tableCompareResult .= count($onlyIn1) ? '<ul>' . implode('', array_map(function($t) { return "<li>$t</li>"; }, $onlyIn1)) . '</ul>' : "Aucune<br>";

        $tableCompareResult .= "<strong>Tables uniquement dans <code>$db2</code> :</strong><br>";
        $tableCompareResult .= count($onlyIn2) ? '<ul>' . implode('', array_map(function($t) { return "<li>$t</li>"; }, $onlyIn2)) . '</ul>' : "Aucune<br>";
    } catch (PDOException $e) {
        $tableCompareResult = "❌ Erreur de comparaison : " . $e->getMessage();
    }
}

// 📄 Liste des sauvegardes
$backups = glob($backupDir . '/*.sql');
usort($backups, function($a, $b) {
    return filemtime($b) - filemtime($a);
});

// 🔍 Bases existantes
try {
    $pdo = new PDO("mysql:host=$host", $username, $password);
    $databases = $pdo->query("SHOW DATABASES")->fetchAll(PDO::FETCH_COLUMN);
} catch (PDOException $e) {
    $databases = [];
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion Backups MySQL</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light p-4">
<div class="container">
    <h1 class="mb-4">🛡️ Gestion des Backups – <code><?= htmlspecialchars($dbname) ?></code></h1>

    <?php if ($msg): ?>
        <div class="alert alert-info"><?= $msg ?></div>
    <?php endif; ?>

    <form method="post" class="mb-3 row g-2">
        <div class="col-auto">
            <input type="text" name="backup_name" class="form-control" placeholder="Nom de la sauvegarde">
        </div>
        <div class="col-auto">
            <button name="backup" class="btn btn-primary">📦 Créer sauvegarde</button>
        </div>
    </form>

    <input type="text" id="filter" class="form-control mb-3" onkeyup="filterBackups()" placeholder="🔍 Filtrer les fichiers...">

    <table class="table table-bordered bg-white">
        <thead class="table-light"><tr><th>Fichier</th><th>Date</th><th>Actions</th></tr></thead>
        <tbody>
        <?php foreach ($backups as $file): $basename = basename($file); ?>
            <tr>
                <td><?= htmlspecialchars($basename) ?></td>
                <td><?= date("Y-m-d H:i:s", filemtime($file)) ?></td>
                <td>
                    <form method="post" class="d-inline">
                        <input type="hidden" name="restore_file" value="<?= $basename ?>">
                        <input type="text" name="target_db" placeholder="Base cible" class="form-control d-inline" style="width:150px;">
                        <button class="btn btn-success btn-sm" onclick="return confirm('Restaurer dans cette base ?')">🔁</button>
                    </form>
                    <form method="post" class="d-inline">
                        <input type="hidden" name="delete_file" value="<?= $basename ?>">
                        <button class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ?')">🗑️</button>
                    </form>
                    <a href="backups/<?= urlencode($basename) ?>" class="btn btn-secondary btn-sm" download>⬇️</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <h3 class="mt-5">🧪 Comparer deux fichiers SQL (diff brut)</h3>
    <form method="post" class="row g-2 mb-3">
        <div class="col-auto">
            <select name="compare_1" class="form-select" required>
                <?php foreach ($backups as $f): ?>
                    <option value="<?= basename($f) ?>"><?= basename($f) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-auto">
            <select name="compare_2" class="form-select" required>
                <?php foreach ($backups as $f): ?>
                    <option value="<?= basename($f) ?>"><?= basename($f) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-auto">
            <button class="btn btn-info">Comparer</button>
        </div>
    </form>
    <?php if ($diffResult): ?>
        <textarea class="form-control mb-4" readonly rows="10"><?= htmlspecialchars($diffResult) ?></textarea>
    <?php endif; ?>

    <h3 class="mt-5">🔎 Comparer les tables de deux bases existantes</h3>
    <form method="post" class="row g-2 mb-3">
        <div class="col-auto">
            <select name="table_compare_1" class="form-select" required>
                <?php foreach ($databases as $db): ?>
                    <option value="<?= htmlspecialchars($db) ?>"><?= htmlspecialchars($db) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-auto">
            <select name="table_compare_2" class="form-select" required>
                <?php foreach ($databases as $db): ?>
                    <option value="<?= htmlspecialchars($db) ?>"><?= htmlspecialchars($db) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-auto">
            <button class="btn btn-dark">Comparer tables</button>
        </div>
    </form>
    <?php if ($tableCompareResult): ?>
        <div class="alert alert-secondary"><?= $tableCompareResult ?></div>
    <?php endif; ?>
    <h3 class="mt-5">🧹 Réinitialiser une base cible (vider certaines tables)</h3>
<form method="post" class="row g-3 mb-4">
    <div class="col-auto">
        <label for="reset_target" class="form-label">Base à réinitialiser :</label>
        <select name="reset_target" id="reset_target" class="form-select" required>
            <?php foreach ($databases as $db): ?>
                <option value="<?= htmlspecialchars($db) ?>"><?= htmlspecialchars($db) ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="col-auto">
        <button type="submit" name="reset_db" class="btn btn-warning"
                onclick="return confirm('Confirmer la réinitialisation de la base sélectionnée ?')">
            🧹 Réinitialiser la base
        </button>
    </div>
</form>

    
    
</div>

<script>
function filterBackups() {
    const filter = document.getElementById("filter").value.toLowerCase();
    const rows = document.querySelectorAll("table tbody tr");
    rows.forEach(row => {
        const text = row.querySelector("td").textContent.toLowerCase();
        row.style.display = text.includes(filter) ? "" : "none";
    });
}
</script>
</body>
</html>
