<?php
// Connexion à la base de données
require 'config_livescores2024.php';

// Récupérer les vainqueurs (1er et 2ème rang) des phases précédentes
$queryHeats = "SELECT * FROM heats WHERE categ='3-' ORDER BY serie, rank";
$resultHeats = $conn->query($queryHeats);

$heats = [];
if ($resultHeats->num_rows > 0) {
    while ($row = $resultHeats->fetch_assoc()) {
        $heats[$row['serie']][] = $row; // Grouper les concurrents par série
    }
}

// Récupérer le modèle des tours suivants (Quarts, Demis, Finale)
$queryNextRounds = "SELECT * FROM heatmodel WHERE heatmodel='huitieme' AND isnull(START)";
$resultNextRounds = $conn->query($queryNextRounds);

$nextRoundsModel = [];
if ($resultNextRounds->num_rows > 0) {
    while ($row = $resultNextRounds->fetch_assoc()) {
        $nextRoundsModel[] = $row;
    }
}

// Préparer la répartition pour les Quarts, Demis, et Finale
$serieCounter = 1000308; // Initialiser le numéro de série pour les quarts
$winners = [];

// Sélectionner les gagnants pour chaque heat
foreach ($heats as $serie => $competitors) {
    usort($competitors, function($a, $b) {
        return $a['rank'] - $b['rank']; // Trier par rang
    });

    // Récupérer les 2 premiers (par ex. 1er et 2ème) pour chaque série
    $winners[$serie][] = $competitors[0]; // 1er
    $winners[$serie][] = $competitors[1]; // 2ème
}

// Insertion dans la table heats
$insertStmt = $conn->prepare("
    INSERT INTO heats (categ, serie, round, heat, ligne, concu, nom, club, srcheat, srcrank)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE 
        round = VALUES(round), 
        heat = VALUES(heat),
        concu = VALUES(concu), 
        nom = VALUES(nom), 
        club = VALUES(club), 
        srcheat = VALUES(srcheat), 
        srcrank = VALUES(srcrank)
");

// Logique de progression à travers les rounds
function assignWinnersToNextRound($winners, $nextTour, $startHeat, $compsPerHeat) {
    global $insertStmt, $serieCounter;
    $heatIndex = 0;
    foreach ($winners as $srcHeat => $compList) {
        foreach ($compList as $index => $winner) {
            $heatNumber = $startHeat + floor($heatIndex / $compsPerHeat); // Numéro de série suivant
            $ligne = ($index % $compsPerHeat) + 1; // Ligne dans le prochain heat

            $categ = $winner['categ'];
            $round = $nextTour; // Round suivant
            $concu = $winner['concu'];
            $nom = $winner['nom'];
            $club = $winner['club'];
            $srcheat = $winner['serie']; // Série source
            $srcrank = $index + 1; // Classement dans la série source

            $insertStmt->bind_param('sisiiissii', $categ, $heatNumber, $round, $heatNumber, $ligne, $concu, $nom, $club, $srcheat, $srcrank);
            $insertStmt->execute();

            $heatIndex++;
        }
    }
}

// Assignation des vainqueurs aux Quarts de finale
assignWinnersToNextRound($winners, 'Quarts', 9, 4);

// Simulation des Demis et Finales (Les gagnants des Quarts passent en Demis)
$winners = []; // Simuler la récupération des vainqueurs des Quarts pour les Demis
assignWinnersToNextRound($winners, 'Demie-Finale', 13, 4);

// Les gagnants des Demis passent en Finale
$winners = []; // Simuler la récupération des vainqueurs des Demis pour la Finale
assignWinnersToNextRound($winners, 'Finale', 15, 4);

$insertStmt->close();
$conn->close();

echo "Progression effectuée avec succès !";
?>
