<?php
// proxy_vlc.php

// Configuration de VLC
$vlcHost = 'localhost';
$vlcPort = 8080;
$baseUrl = "http://$vlcHost:$vlcPort/requests/status.xml";

// Récupération des paramètres attendus par le proxy
$command = isset($_GET['command']) ? $_GET['command'] : '';
$input   = isset($_GET['input'])   ? $_GET['input']   : '';

// Construction de l'URL finale pour VLC
$url = $baseUrl . '?command=' . urlencode($command) . '&input=' . urlencode($input);

// Si VLC nécessite une authentification, indiquez le mot de passe ici
$username = '';  // généralement vide
$password = 'rootroot'; // remplacez par votre mot de passe VLC si nécessaire

// Préparation de l'en-tête d'authentification
$headers = [];
if (!empty($password)) {
    $auth = base64_encode($username . ":" . $password);
    $headers[] = "Authorization: Basic $auth";
}

// Préparation du contexte pour file_get_contents
$contextOptions = [
    "http" => [
        "header" => implode("\r\n", $headers)
    ]
];
$context = stream_context_create($contextOptions);

// Exécution de la requête vers VLC
$response = @file_get_contents($url, false, $context);

if ($response === FALSE) {
    http_response_code(500);
    exit("Erreur lors de l'envoi de la commande à VLC via le proxy.");
}

// On renvoie le type de contenu (ici XML, selon l'interface VLC)
header('Content-Type: application/xml');
echo $response;
?>
