<?php
// Chemin vers le dossier 'results'
$directoryPath = 'results';
$results = [];

// Vérifier si le dossier existe et est un répertoire
if(is_dir($directoryPath)) {
    $dir = new DirectoryIterator($directoryPath);
    foreach ($dir as $fileinfo) {
        if (!$fileinfo->isDot() && $fileinfo->getExtension() == 'fed') {
            $results[] = [
                'name' => $fileinfo->getFilename(),
                'path' => $fileinfo->getPathname()
            ];
        }
    }
}

// Définir l'en-tête pour le type de contenu JSON
header('Content-Type: application/json');
echo json_encode($results);
