<?php
header('Content-Type: application/json');

// Connexion à la base de données
$conn = new mysqli("localhost", "surfware", "rootroot", "surfware_template");

if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Erreur de connexion à la base de données']));
}

// Récupérer les données envoyées en JSON
$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['concu'], $data['vague'], $data['juge'], $data['note'])) {
    $concu = $data['concu'];
    $vague = $data['vague'];
    $juge = $data['juge'];
    $note = $data['note'];

    // Mettre à jour la note dans la base de données
    $stmt = $conn->prepare("UPDATE resu SET note = ? WHERE concu = ? AND vague = ? AND juge = ?");
    $stmt->bind_param('diii', $note, $concu, $vague, $juge);

    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Données manquantes']);
}

$conn->close();
?>
