let selectedCompetitor = null;
let selectedScoreIndex = 1; // Initialisé à 1 pour correspondre aux colonnes de score (1 à 15)
let score = '';
let juge = null;

var timer;
    let countDownDate; // Variable globale pour stocker la date cible
  let chronoInterval; // Variable pour stocker l'intervalle du chronomètre
    let chrono_state;
    let chrono_remaining;

// Map des codes de couleurs pour faciliter la sélection
const colorMap = {
    'Re': 'red',
    'Ye': 'yellow',
    'Bl': 'cornflowerblue',
    'Wh': 'white',
    'Bk': 'black'
};
const colortext = {
    'Re': 'Black',
    'Ye': 'Black',
    'Bl': 'Black',
    'Wh': 'Black',
    'Bk': 'White'
};
const colorrow = {
    'Re': 'linear-gradient(90deg, rgba(255, 255, 255, 1) -64%, rgba(255, 0, 0, 1) 100%)',
    'Ye': 'linear-gradient(90deg, rgba(255, 255, 255, 1) -64%, rgba(255, 255, 0, 1) 100%)',
    'Bl': 'linear-gradient(90deg, rgba(255, 255, 255, 1) -64%, rgba(0, 200, 255, 1) 100%)',
    'Wh': 'linear-gradient(0deg, rgba(255, 255, 255, 1) -64%, rgba(200, 200, 200, 1) 100%)',
    'Bk': 'linear-gradient(90deg, rgba(200, 200, 200, 1) -64%, rgba(100, 100, 100, 1) 100%)'
};


function fetchHeaderData() {
    fetch('Surfware-header.php')
        .then(response => {
            if (!response.ok) {
                throw new Error(`Erreur réseau: ${response.status}`);
            }
            return response.text();
        })
        .then(data => {
            
            // Après avoir généré les compétiteurs, récupérer les scores
            fetchScores(data);
        })
        .catch(error => {
            console.error('Erreur lors de la récupération des données:', error);
            window.location.href = 'logout.php'; // Rediriger en cas d'erreur
        });
}

function parseHeaderData(data) {
    // Split the main data into header and competitors
    const [headerPart, competitorsPart] = data.split('@JOIN#');

    // Split header data
    const headerSections = headerPart.split('#');
    // headerSections = ["HEADER", "Juge", "Division", "Round", "Heat", "Chrono"]

    juge = headerSections[1];
    const division = headerSections[2];
    const round = headerSections[3];
    const heat = headerSections[4];
    const chrono = headerSections[5];

    // Update header
    document.getElementById('judge').textContent = juge;
    document.getElementById('division').textContent = division;
    document.getElementById('round').textContent = round;
    document.getElementById('heat').textContent = heat;
    //document.getElementById('chrono').textContent = chrono;
    countDownDate = new Date(chrono).getTime();
    // Split competitors data
    const competitorsArray = competitorsPart.split('#');
    const competitorsContainer = document.querySelector('#scores-table tbody');
    competitorsContainer.innerHTML = ''; // Clear existing rows

    competitorsArray.forEach(competitor => {
        const [order, colorCode] = competitor.split(';');
        if (colorCode) {
            const color = colorMap[colorCode] || 'grey';
            const textcolor = colortext[colorCode] || 'black';
            const colorbackrow = colorrow[colorCode] || 'black';
            
            // Create a table row
            const row = document.createElement('tr');

            // Create the color cell
            const colorCell = document.createElement('td');
            const colorDiv = document.createElement('div');
            colorDiv.className = 'competitor-color';
            colorDiv.style.backgroundColor = color;
            row.style.background = colorbackrow;
            row.style.color = textcolor;
            colorDiv.dataset.color = colorCode; // Set data-color attribute
            colorDiv.dataset.order = order; // Set data-order attribute
            colorDiv.onclick = () => selectCompetitor(order); // Pass order instead of colorCode
            colorCell.appendChild(colorDiv);
            row.appendChild(colorCell);

            // Create 15 score cells
            for (let i = 1; i <= 15; i++) {
                const scoreCell = document.createElement('td');
                scoreCell.className = 'score-cell';
                scoreCell.dataset.competitor = order; // Use order instead of colorCode
                scoreCell.dataset.scoreIndex = i;
                scoreCell.textContent = ''; // Initial empty score
                row.appendChild(scoreCell);
            }

            competitorsContainer.appendChild(row);
        }
    });
}


function refreshtimer() {
    
    
    
    //console.log(countDownDate);
    //console.log(chrono_state);
    
    
if (chrono_state ==='paused') {
    document.getElementById("chrono").innerHTML = chrono_remaining;
    document.getElementById("chrono").style.color = "red";
    document.getElementById("chrono").classList.add('pulse');
    document.getElementById("chrono").classList.remove('zoom');
    
} else {
  // Obtenir la date et l'heure actuelles
  var now = new Date().getTime();
document.getElementById("chrono").classList.remove('pulse');
  // Calculer la distance entre maintenant et la date de compte à rebours
  var distance = countDownDate - now;

  // Calculer les jours, heures, minutes et secondes restants
  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
  var seconds = Math.floor((distance % (1000 * 60)) / 1000);

// Vérifier que minutes et seconds sont des nombres valides
minutes = isNaN(minutes) ? 0 : minutes;
seconds = isNaN(seconds) ? 0 : seconds;    
    
  // Afficher le timer au format MM:SS avec des zéros à gauche si nécessaire
  document.getElementById("chrono").innerHTML = String(minutes).padStart(2, '0') + ":" + String(seconds).padStart(2, '0');

  // Si le temps restant est inférieur à 5 minutes, changer la couleur en orange
  if (distance < 300000 && distance > 0) {  // 5 minutes en millisecondes et vérifier que c'est encore positif
      if (distance < 60000 && distance > 0) {  // 5 minutes en millisecondes et vérifier que c'est encore positif
        document.getElementById("chrono").style.color = "red";
          document.getElementById("chrono").classList.add('zoom');
      } else {
    document.getElementById("chrono").style.color = "orange";
          document.getElementById("chrono").classList.remove('zoom');
      }
  }
  // Sinon, si supérieur à 5 minutes, remettre la couleur en blanc
  else if (distance >= 300000) {
    document.getElementById("chrono").style.color = "white";
      document.getElementById("chrono").classList.remove('zoom');
  }

  // Si le compte à rebours est terminé, afficher "00:00" et arrêter le timer
  if (distance < 0) {
    clearInterval(timer);
    document.getElementById("chrono").innerHTML = "00:00";
    document.getElementById("chrono").style.color = "red"; // Optionnel : afficher en rouge lorsque terminé
      document.getElementById("chrono").classList.remove('zoom');
  }
}
}     

function fetchScores(dataheader) {
    fetch('Surfware-getData.php')
        .then(response => {
            if (!response.ok) {
                throw new Error(`Erreur réseau: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
        if (dataheader) {
            parseHeaderData(dataheader);
        }
            populateScores(data);
        console.log(data);
    })
        .catch(error => {
            console.error('Erreur lors de la récupération des scores:', error);
            window.location.href = 'logout.php'; // Rediriger en cas d'erreur
        });
}

function populateScores(scoresData) {
    
    scoresData.forEach(scoreEntry => {
        const { prio,ligne, vague, note } = scoreEntry;
        
        // Trouver la ligne correspondante (ligne commence à 1)
        const row = document.querySelector(`#scores-table tbody tr:nth-child(${ligne})`);
        if (row) {
            // Trouver la cellule de score correspondante (vague commence à 1)
            const scoreCell = row.querySelector(`.score-cell[data-score-index='${vague}']`);
            if (scoreCell) {
                scoreCell.textContent = note;
            }
            const priocell = row.querySelector(`.competitor-color[data-order="${Number(ligne) - 1}"]`);

            
            //if (priocell) {
                priocell.textContent = "P" + prio;
            //}
        }
    });
}

function selectCompetitor(order) {
    // Deselect previous competitor
    if (selectedCompetitor !== null) {
        const prevSelected = document.querySelector(`.competitor-color[data-order='${selectedCompetitor}']`);
        if (prevSelected) {
            prevSelected.classList.remove('selected');
        }
    }

    // Set new selectedCompetitor
    selectedCompetitor = order;
    selectedScoreIndex = 1; // Réinitialiser le compteur de score à 1

    // Highlight the selected competitor
    const competitorDiv = document.querySelector(`.competitor-color[data-order='${order}']`);
    if (competitorDiv) {
        competitorDiv.classList.add('selected');
    }

    // Show the virtual keyboard
    document.getElementById('virtual-keyboard').classList.remove('hidden');

    // Réinitialiser tout score en cours
    score = '';

    // Reset the calculator display
    resetCalculatorDisplay();
}

function resetCalculatorDisplay() {
    // Check if the calculator display exists, if not, create it
    let display = document.getElementById('calculator-display');
    if (!display) {
        display = document.createElement('div');
        display.id = 'calculator-display';
        display.style.textAlign = 'center';
        display.style.marginBottom = '10px';
        display.style.fontSize = '2rem'; // Agrandi
        display.style.fontWeight = 'bold';
        display.style.backgroundColor = '#000'; // Fond noir
        display.style.color = '#0f0'; // Texte vert
        display.style.padding = '15px'; // Agrandi
        display.style.borderRadius = '5px';
        document.getElementById('virtual-keyboard').prepend(display);
    }
    display.textContent = '0';
}

function updateCalculatorDisplay() {
    let display = document.getElementById('calculator-display');
    if (!display) {
        resetCalculatorDisplay();
        display = document.getElementById('calculator-display');
    }
    display.textContent = score || '0';
}

function addScore(value) {
    if (selectedCompetitor === null) {
        alert('Veuillez sélectionner un compétiteur en cliquant sur sa couleur.');
        return;
    }

    // Appliquer la logique de transformation
    let newValue = score + value;

    // Vérifier que la longueur du score dépasse 1 ou si le score est >10 ou commence par 0
    if (newValue.length > 1 || (newValue.startsWith('0') && newValue !== '0') || parseInt(newValue) > 10) {
        // Si la valeur est un entier supérieur à 10, diviser par 10
        if (parseInt(newValue) > 10 && Number.isInteger(Number(newValue))) {
            newValue = (Number(newValue) / 10).toString();
        }
        // Si la valeur commence par zéro et est inférieure à 10, diviser par 10
        else if (newValue.startsWith('0') && parseInt(newValue) < 10 && Number.isInteger(Number(newValue))) {
            newValue = (Number(newValue) / 10).toString();
        }
    }

    // Vérifier que le score est entre 0 et 10
    if (Number(newValue) >= 0 && Number(newValue) <= 10) {
        if (newValue.includes('.')) {
                const [integerPart, decimalPart] = newValue.split('.');
                newValue = decimalPart.length > 2
                    ? `${integerPart}.${decimalPart.slice(0, 2)}`
                    : newValue;
            }
        
        
        score = newValue;
        updateCalculatorDisplay();
    } else {
        alert('Veuillez entrer un score entre 0 et 10.');
    }
}

function updateSelectedScoreCell() {
    const tableBody = document.querySelector('#scores-table tbody');
    const rows = tableBody.querySelectorAll('tr');
    let targetCell = null;

    // Trouver la ligne du compétiteur sélectionné
    rows.forEach(row => {
        const competitorDiv = row.querySelector('.competitor-color');
        if (competitorDiv && competitorDiv.dataset.order === selectedCompetitor) {
            // Trouver la cellule de score actuelle
            const scoreCells = row.querySelectorAll('.score-cell');
            if (selectedScoreIndex <= scoreCells.length) {
                targetCell = scoreCells[selectedScoreIndex - 1];
            }
        }
    });

    if (targetCell) {
        targetCell.textContent = score;
    }
}

function clearScore() {
    score = '';
    document.getElementById('virtual-keyboard').classList.add('hidden');
    //updateCalculatorDisplay();
    
}

function validateScore() {
    if (selectedCompetitor === null) {
        alert('Veuillez sélectionner un compétiteur en cliquant sur sa couleur.');
        return;
    }

    if (score !== '' && score > 0 ) {
        const competitor = selectedCompetitor;
        const scoreIndex = selectedScoreIndex;

        const noteString = `NOTE#${competitor}#${juge}#${score}#0`;

        fetch('Surfware-CMD.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `MSG=${encodeURIComponent(noteString)}`
        })
        .then(response => response.json())
        .then(data => {
            //selectedScoreIndex++;
            //score = '';
            //updateCalculatorDisplay();
            fetchScores();
            document.getElementById('virtual-keyboard').classList.add('hidden'); // Ensure this is triggered
        })
        .catch(error => {
            console.error('Erreur:', error);
            alert('Une erreur est survenue lors de l\'enregistrement du score.');
        });
    } else {
        document.getElementById('virtual-keyboard').classList.add('hidden');
    }
}

function updateScore() {
    if (selectedCompetitor === null) {
        alert('Veuillez sélectionner un compétiteur en cliquant sur sa couleur.');
        return;
    }

    if (score !== '' && score > 0 ) {
        const competitor = selectedCompetitor;
        const scoreIndex = selectedScoreIndex;

        const noteString = `UPDATE#${competitor}#${juge}#${score}#0`;

        fetch('Surfware-CMD.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `MSG=${encodeURIComponent(noteString)}`
        })
        .then(response => response.json())
        .then(data => {
            //selectedScoreIndex++;
            //score = '';
            //updateCalculatorDisplay();
            fetchScores();
            document.getElementById('virtual-keyboard').classList.add('hidden'); // Ensure this is triggered
        })
        .catch(error => {
            console.error('Erreur:', error);
            alert('Une erreur est survenue lors de l\'enregistrement du score.');
        });
    } else {
        document.getElementById('virtual-keyboard').classList.add('hidden');
    }
}


// Initialisation lors du chargement de la page
document.addEventListener('DOMContentLoaded', fetchHeaderData);
autoRefreshInterval = setInterval(() => fetchHeaderData(), 5000);
refreshtimer();