<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
   
    <style>
        /* Style global */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color:gainsboro;
            overflow-x: hidden;
        }
.separator {
  border-top: 2px solid #000; /* Adjust thickness and color */
  margin: 20px 0; /* Adjust spacing between the tables */
}

	.logo-container {
            
            top: 50px;  /* Position the logo 10px from the top */
            left: 50px; /* Position the logo 10px from the left */
        }
        .logo-container img {
		width: 100%;
            max-width: 250px;  /* Set the maximum width of the logo */
            height: auto;      /* Maintain the aspect ratio */
        }
        .container {
            width: 75%;  /* Limit to 50% of the screen width */
            margin: 0 auto;  /* Center the container */
            align-items: flex-start;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .header-left {
            font-size: 1.5em;
            text-align: left;
            flex: 1;
        }
        .header-center {
            text-align: center;
            flex: 1;
        }
        .header-center h2 {
            margin: 0;
            font-size: 1.5em;
        }
        .header-center h3 {
            margin: 0;
            font-size: 1.2em;
            font-weight: normal;
        }
        .header-right {
            text-align: right;
            flex: 1;
            font-size: 2.5em;
        }
	.chrono {
            margin: 0;
            font-size: 1.5em;
        }

        table {
            width: 100%;  /* Ensure table takes up the full width of the container */
            border-collapse: collapse;
            margin-bottom: 20px;
        }
	tr {
            line-height: 13px;
	    font-size: 1.2em;
        }
        th, td {
            padding: 10px;
            text-align: center;
            border: 1px solid #ddd;
        }
        th {
            background-color:#0f2563;
            color: white;
	    
        }
        statheader {
            background-color:#103c94;
            color: white;
	    
        }

        .average-row {
            background-color:darkslategrey; /* Couleur de la ligne des moyennes */
            color: white;
	    
        }
        /* Couleurs modernes pour les concurrents */
        .coul-1 {
            background-color: orangered; /* Rose clair */
            color: white;
        }
        .coul-2 {
            background-color: yellow; /* Bleu clair */
        }
        .coul-3 {
            background-color: lightskyblue; /* Vert clair */
        }
        .coul-4 {
            background-color: whitesmoke; /* Jaune clair */
        }
        .coul-5 {
            background-color: darkslategray; /* Jaune clair */
        }
.narrow-table {
  width: auto; /* Automatically adjusts to content width */
  border-collapse: collapse; /* Removes spacing between cells */
}

.narrow-table th,
.narrow-table td {
  padding: 5px; /* Reduce padding for narrow cells */
  border: 1px solid #ccc; /* Optional: Add borders for clarity */
  text-align: left; /* Align text to the left */
  white-space: nowrap; /* Prevent text from wrapping */
}

.narrow-table th {
  /* background-color: #f4f4f4;  Optional: Add background color for headers */
}

        /* Style responsive */
        @media (max-width: 768px) {
            th, td {
                padding: 5px;
                font-size: 2.5vh;  /* Ajuste la taille de la police pour les petits écrans */
            }
        }


    </style>    
    <title>Tableau Notes</title>
	<!-- JavaScript for auto-refresh -->
    	<script type="text/javascript">
        setInterval(function() {
            window.location.reload(); // Reload the page every 1000 milliseconds (1 second)
        }, 5000);
	</script>

<!-- JavaScript for real-time remaining time update -->
    <script type="text/javascript">
        function updateRemainingTime(targetTimeSRC) {
            setInterval(function() {

const targetTime = new Date(targetTimeSRC); // Date en UTC

	const now = new Date(); // L'heure actuelle
const nowUTC = new Date(now.toISOString()); // Convertir en UTC

const diff = targetTime - nowUTC; // Calculer le temps restant en millisecondes

                // Get the current time
                //var currentTime = new Date();

                // Parse target time
                //var targetParts = targetTime.split(':');
                //var targetDate = new Date();
                //targetDate.setHours(targetParts[0], targetParts[1], targetParts[2]);

                // Calculate the difference
                //var diff = targetDate - currentTime;

                // If time has passed, set remaining time to "00:00"
                if (diff <= 0) {
                    document.getElementById('remaining-time').innerText = "00:00";
                    return;
                }

                // Convert the difference to hours, minutes, and seconds
                var hours = Math.floor(diff / (1000 * 60 * 60));
                var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((diff % (1000 * 60)) / 1000);

                // Format the time as HH:MM:SS
                var formattedTime = 
                    (minutes < 10 ? "0" : "") + minutes + ":" +
                    (seconds < 10 ? "0" : "") + seconds;

                // Update the remaining time on the page
                document.getElementById('remaining-time').innerText = formattedTime;
            }, 1000);
        }
    </script>

</head>
<body>



<div class="table-container">
   
<?php
require 'config_connect.php';


echo "</div>";
echo "<div>";
$sql = "SELECT chrono AS targettime, s.serie, POSITION,lycra AS coul,NAME AS nom, club, s.value1 AS note1,s.value2 AS note2,score AS formated_moyenne, needs AS status, IFNULL(p.photo,'c:/live/photos/anonyme.png') AS photo,if(ISNULL(cn.code2l),'c:/live/flags/noflag.png', CONCAT('c:/live/',cn.code2l)) AS flag, CONCAT(categ,' ', `round`,' H',heat) AS division, s.prio
FROM live_options o
LEFT JOIN competitors c ON o.compete = c.serie
LEFT JOIN (
SELECT 
    main.serie, 
    main.competitor_id, 
    MAX(main.value) AS value1, 
    MAX(sub.value) AS value2, 
    b.prio
FROM live_waves main
LEFT JOIN live_waves sub 
    ON main.competitor_id = sub.competitor_id 
   AND main.serie = sub.serie 
   AND ( sub.value < main.value 
         OR (sub.value = main.value AND sub.id <> main.id)
       )
LEFT JOIN bloque b 
    ON main.competitor_id = b.ligne 
WHERE main.value < 11
GROUP BY main.serie, main.competitor_id, b.prio
ORDER BY main.competitor_id
) s ON o.compete = s.serie AND c.competitor_id= s.competitor_id
LEFT JOIN live_photos p ON c.name=p.competitor
LEFT JOIN (
SELECT noc AS code3l,
REPLACE(flag,'../','') AS code2l
FROM flags UNION
SELECT code3l, CONCAT('flags/',code2l,'.svg') AS code2l
FROM country) cn ON c.club=cn.code3l
LEFT JOIN compet co ON 1=1
WHERE liveon=1
ORDER BY c.position, c.ligne";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Fetch all rows into an associative array
    $headerData = [];
    while ($row = $result->fetch_assoc()) {
        $headerData[] = $row;
    }

    // Check if headerData is not empty
    if (!empty($headerData)) {
        // Use the first row for the big header information
        $bigHeader = $headerData[0];


       // JavaScript to update remaining time every second
        echo "<script type='text/javascript'>
                document.addEventListener('DOMContentLoaded', function() {
                    updateRemainingTime('{$bigHeader['targettime']}');
                });
              </script>";

echo "<div>";
         // Display the custom header layout
        echo "<div class='header container'>";
        echo "<div class='logo-container'>";
        echo "<img src='walkontechlogo.png'' alt='Logo'>";
        echo "</div>";
        echo "<div class='header-center'><h2>{$bigHeader['division']}</h2></div>";
        
	
	echo "<div class='header-center chrono'>";
        
        echo "<h2><span id='remaining-time'></span></h2>";
        echo "</div>";
        echo "</div>";

        // Display Table
        echo "<table class='container'>";
        echo "<tr><th>Bio</th><th></th><th>Name</th><th>Club</th><th>Note 1</th><th>Note 2</th><th>Moyenne</th><th>Needs</th></tr>";

        foreach ($headerData as $row) {
            echo "<tr class='{$row['coul']}'>";
	    echo "<td><a href='http://surfware.fedesurfmaroc.com/athletedetails.php?concuId=" .  $row['nom'] . "'><img src='bio.png' alt='Bio' /></a></td>";

            echo "<td>{$row['prio']}</td>";
            echo "<td>{$row['nom']}</td>";
            echo "<td>{$row['club']}</td>";
            echo "<td>{$row['note1']}</td>";
            echo "<td>{$row['note2']}</td>";
            //echo "<td>" . $row['note2'] . ($row['interf'] > 0 ? '<sup>  ▲</sup>' : '') . "</td>";  //interférence
	    echo "<td>{$row['formated_moyenne']}</td>";
	    echo "<td>{$row['status']}</td>";
	    

	    

            echo "</tr>";
        }

        echo "</table>";
        
    } else {
        echo "No Scores available yet";
    }
} else {
    echo "No Scores available yet";
}
echo "</div>";
echo "<div class='separator'></div>";
    
    
    
$sql = "SELECT resu.serie, resu.concu,resu.vague, resu.juge,resu.note,live_waves.value AS moyenne, CONCAT('coul-',b.ligne) AS coul 
FROM resu LEFT JOIN bloque b ON resu.concu=b.concu
left join live_waves 
on b.serie=live_waves.serie 
AND b.ligne=live_waves.competitor_id
AND resu.vague=live_waves.id

 WHERE juge>0 and resu.serie IN (SELECT serie FROM bloque)
 ORDER BY ligne, vague,juge";

$data = $conn->query($sql);

// Vérifier s'il y a des résultats
if ($data->num_rows > 0) {


// Initialisation des classes CSS pour chaque 'concu'
$colors = [
    1 => 'coul-1',
    2 => 'coul-2',
    3 => 'coul-3',
    4 => 'coul-4',
    5 => 'coul-5',
];

// Regrouper les données par 'concu' et 'vague'
$groupedData = [];
$uniqueJudges = []; // Pour stocker les juges uniques
$maxVague = 0;

foreach ($data as $row) {
    $concu = $row['concu'];
    $vague = $row['vague'];
    $juge = $row['juge'];
    $color = $row['coul'];
    
    $groupedData[$concu][$vague][$juge] = $row;
    $groupedData[$concu]['color'] = $color;  // Stocker la couleur par 'concu'
    
    // Ajouter les juges uniques
    if (!in_array($juge, $uniqueJudges)) {
        $uniqueJudges[] = $juge;
    }
	// Calculer le nombre maximum de vagues
        if ($vague > $maxVague) {
            $maxVague = $vague;
        }

}

// Trier les juges pour l'affichage ordonné
sort($uniqueJudges);




echo "<div style='width:100%; float:left;'>";
// Affichage du tableau
echo "<table style='background-color: #e3e6e4;'>";

$firstConcu = true;  // Flag pour afficher les en-têtes uniquement la première fois

foreach ($groupedData as $concu => $vagues) {
    $color = $vagues['color'];  // Récupérer la couleur pour ce 'concu'
    
    if ($firstConcu) {
        // Affichage des en-têtes pour les vagues (seulement pour le premier concu)
        echo "<tr>";
        echo "<th style='width:100px'>J# \ W# </th>";
        
        // Affichage des en-têtes pour les vagues (en fonction du max vague)
    for ($i = 1; $i <= 15; $i++) {
        echo "<th>$i</th>";
    }

        echo "</tr>";
        $firstConcu = false;
    }

    // Affichage des notes par juge pour chaque vague
    foreach ($uniqueJudges as $juge) {  // Utiliser les juges uniques extraits des données
        echo "<tr>";
        echo "<td>J$juge</td>";
        $i=0;
        foreach ($vagues as $key => $juges) {
            if ($key !== 'color') {  // Ignorer la clé 'color'
                echo "<td class='$color'>";
                echo isset($juges[$juge]['note']) ? $juges[$juge]['note'] : '-';
                echo "</td>";
                $i++;
            }
        }
        for ($j = $i+1; $j <= 15; $j++) {
        //if ($key !== 'color') {  // Ignorer la clé 'color'
                echo "<td class='$color'></td>";
          //  }
        }
        echo "</tr>";
    }

    // Affichage de la moyenne pour chaque vague avec fond gris foncé et texte blanc
    echo "<tr class='average-row'>";
    echo "<td>Moyenne</td>";
    foreach ($vagues as $key => $juges) {
        if ($key !== 'color') {  // Ignorer la clé 'color'
            echo "<td>";
            echo isset($juges[$uniqueJudges[0]]['moyenne']) 
    ? ($juges[$uniqueJudges[0]]['moyenne'] == 11 ? '▲' : ($juges[$uniqueJudges[0]]['moyenne'] == 21 ? '<span class="waiting-for-score">⏳</span>' : $juges[$uniqueJudges[0]]['moyenne'])) 
    : '-';

 // Moyenne affichée dans la première cellule de chaque vague
            echo "</td>";
        }
    }
    for ($j = $i+1; $j <= 15; $j++) {
        //if ($key !== 'color') {  // Ignorer la clé 'color'
                echo "<td></td>";
          //  }
        }
    echo "</tr>";
}

echo "</table>";
echo "</div>";


// affichage des statistiques 10 Best scoring Waves

$rowNumber = 1;

$sql = "SELECT nom,club,moyenne,division,tour,heat FROM moyennes_notes m1 LEFT JOIN concu ON m1.concu=concu.numpart WHERE division IN (SELECT DISTINCT division FROM bloque LEFT JOIN moyennes_notes ON bloque.serie= moyennes_notes.serie) AND  moyenne<11 ORDER BY moyenne DESC LIMIT 10";

$result = $conn->query($sql);

if ($result->num_rows > 0) {

echo "<div style='padding-left:10px; width:33%; float:left;'>";


    // Fetch all rows into an associative array
    $headerData = [];
    while ($row = $result->fetch_assoc()) {
        $headerData[] = $row;
    }

    // Check if headerData is not empty
    if (!empty($headerData)) {
        // Use the first row for the big header information
        $bigHeader = $headerData[0];


        // Display Table
        echo "<table class='container' style='width:100%; background-color: #e3e6e4;'>";
echo "<tr class='statheader'>";
echo '<th colspan="6">Realtime Stats : 10 best Waves of current Division</th>';
echo "</tr>";
        echo "<tr class='statheader'><th>#</th><th>Name</th><th>Club</th><th>Score</th><th>Round</th><th>Heat</th></tr>";

        foreach ($headerData as $row) {
            echo "<tr style='line-height:10px; font-size: 1em;'>";
            
            echo "<td>" . $rowNumber++ . "</td>";
            echo "<td>{$row['nom']}</td>";
            echo "<td>{$row['club']}</td>";
            echo "<td>{$row['moyenne']}</td>";
            echo "<td>{$row['tour']}</td>";
            echo "<td>{$row['heat']}</td>";
            echo "</tr>";
        }

        echo "</table>";


// affichage des statistiques curent Division

$sql = "SELECT nom,club,moyenne,division,tour,heat FROM moyennes m1 LEFT JOIN (select distinct serie, division,tour,heat FROM moyennes_notes)  m2 ON m1.serie=m2.serie LEFT JOIN concu ON m1.concu=concu.numpart WHERE division IN (SELECT DISTINCT division FROM bloque LEFT JOIN moyennes_notes ON bloque.serie= moyennes_notes.serie) ORDER BY moyenne DESC LIMIT 10";

$result = $conn->query($sql);

$rowNumber = 1;

// Fetch all rows into an associative array
    $headerData = [];
    while ($row = $result->fetch_assoc()) {
        $headerData[] = $row;
    }

        // Display Table
        echo "<table class='container' style='width:100%; background-color: #e3e6e4;'>";
	echo "<tr class='statheader'>";
	echo "<th class='statheader' colspan='6'>Realtime Stats : 10 best Totals of current Division</th>";
	echo "</tr>";
        echo "<tr class='statheader'><th>#</th><th>Name</th><th>Club</th><th>Score</th><th>Round</th><th>Heat</th></tr>";

        foreach ($headerData as $row) {
            echo "<tr style='line-height:10px; font-size: 1em;'>";
            
            echo "<td>" . $rowNumber++ . "</td>";
            echo "<td>{$row['nom']}</td>";
            echo "<td>{$row['club']}</td>";
            echo "<td>{$row['moyenne']}</td>";
            echo "<td>{$row['tour']}</td>";
            echo "<td>{$row['heat']}</td>";
            echo "</tr>";
        }

        echo "</table>";


echo "</div>";

    } else {
        echo "No Scores available yet 1";
    }
} else {
    echo "No Scores available yet 2";
}





} else {
    echo "No details Scores available yet ";
}

// Fermer la connexion
$conn->close();
?>
</div>
</body>
</html>