<?php
/**
 * export_transposed_csv.php
 * Génère un CSV transposé à partir d'une requête MySQL.
 * - Les entêtes (noms de colonnes) deviennent la 1ère colonne du CSV
 * - Chaque ligne de résultat devient une colonne dans le CSV
 */

// Connexion à la base de données MySQL (ajustez les détails de connexion)
$dbHost = 'localhost';
$dbUser = 'root';
$dbPass = 'rootroot1';
$dbName = 'surfware_template';
$charset = 'utf8mb4'; // retombe sur utf8 si non supporté par votre MySQL

$discipline = $_GET['discipline'];


// Votre requête (lisez de la vue ou d'une SELECT sûre)
// Évitez de passer une requête brute via GET pour des raisons de sécurité.
$sql = "SELECT CONCAT('nom',heats.heat,'.',heats.ligne) AS category, UPPER(concat(RANK,'# ',LEFT(TRIM(m.prenom),1),'.',TRIM(m.nom))) AS ".$discipline." FROM  heats left JOIN (SELECT * from intranet_2019.membres WHERE licence>0) m
ON heats.nom=UPPER(concat(TRIM(m.nom),' ',TRIM(m.prenom))) WHERE heats.categ='".$discipline."'
ORDER BY serie, ligne";


// Nom du fichier à télécharger
$filename = 'export_transpose_' . date('Ymd_His') . '.csv';

// Options
$includeHeaderRow = true;   // inclure la ligne d'entêtes d'origine (recommandé)
$addUTF8BOM       = false;   // ajoute un BOM pour une meilleure ouverture dans Excel

////////////////////////
// CONNEXION MYSQLI   //
////////////////////////
$mysqli = @new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($mysqli->connect_errno) {
    http_response_code(500);
    die("Erreur de connexion MySQL: " . $mysqli->connect_error);
}

// Charset
if (!$mysqli->set_charset($charset)) {
    // fallback
    $mysqli->set_charset('utf8');
}

////////////////////////
// EXÉCUTION REQUÊTE  //
////////////////////////
$result = $mysqli->query($sql);
if (!$result) {
    http_response_code(500);
    die("Erreur de requête: " . $mysqli->error);
}

$fields = $result->fetch_fields();
$colNames = array_map(function($f){ return $f->name; }, $fields);

// Récupération de toutes les lignes (numériques pour conserver l'ordre)
$dataRows = [];
if ($includeHeaderRow) {
    // La première "ligne" logique contiendra les noms de colonnes lors de la transposition
}
while ($row = $result->fetch_row()) {
    $dataRows[] = $row;
}
$result->free();
$mysqli->close();

//////////////////////////////////////////////
// CONSTRUCTION MATRICE ET TRANSPOSITION    //
//////////////////////////////////////////////

/*
 * On construit une matrice source où la 1ère "ligne" est l'entête,
 * suivie des lignes de données. Puis on transpose.
 *
 * Exemple:
 *  Source:
 *    [ ["id","nom","club","score"],
 *      [1,"Ali","CSNM",8.5],
 *      [2,"Sara","AVBS",7.2] ]
 *
 *  Transposé:
 *    [ ["id",   1,    2   ],
 *      ["nom", "Ali","Sara"],
 *      ["club","CSNM","AVBS"],
 *      ["score",8.5,  7.2  ] ]
 */

$sourceMatrix = [];
if ($includeHeaderRow) {
    $sourceMatrix[] = $colNames;
}
foreach ($dataRows as $row) {
    $sourceMatrix[] = $row;
}

// Si pas de données et entêtes demandées -> on transposera quand même les entêtes
if (empty($dataRows) && !$includeHeaderRow) {
    // Rien à sortir : on peut créer un CSV vide avec message minimal
    $sourceMatrix = [$colNames];
}

// Transposition
$transposed = [];
$rows = count($sourceMatrix);
$cols = $rows > 0 ? count($sourceMatrix[0]) : 0;

for ($c = 0; $c < $cols; $c++) {
    $newRow = [];
    for ($r = 0; $r < $rows; $r++) {
        // Sécurise l'index si lignes de longueurs différentes (rare mais possible)
        $newRow[] = isset($sourceMatrix[$r][$c]) ? $sourceMatrix[$r][$c] : '';
    }
    $transposed[] = $newRow;
}

///////////////////////////////
// SORTIE CSV EN TÉLÉCHARGEMENT
///////////////////////////////
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="'.$filename.'"');
header('Pragma: no-cache');
header('Expires: 0');




$out = fopen('php://output', 'w');

// Ajout BOM UTF-8 pour Excel (facultatif)
if ($addUTF8BOM) {
    fwrite($out, "\xEF\xBB\xBF");
}

// Écrit chaque ligne transposée (vides -> '#')
foreach ($transposed as $csvRow) {
    foreach ($csvRow as &$v) {
        if ($v === null || trim((string)$v) === '') {
            $v = '#';
        }
    }
    unset($v); // bonne pratique quand on a utilisé une référence
    fputcsv($out, $csvRow, ',');
}


fclose($out);
exit;
