<?php
include_once 'auth.php';
// Connexion à la base de données MySQL
require 'config_livescores2024.php';


// Récupérer les données envoyées en JSON
$data = json_decode(file_get_contents('php://input'), true);
$serie = $data['serie'];
    
// Vérifier si les données nécessaires sont présentes
if (isset($serie)) {
    //$serie = $data['serie'];
    
        // Si la note est valide, insérer ou mettre à jour
        // Commencer par vider la table bloque
        $stmt = $conn->prepare("TRUNCATE TABLE bloque");
        $stmt->execute();
        $stmt = $conn->prepare("update juges set etat=0");
        $stmt->execute();
    
        $stmt->close();

        // Insérer les nouvelles données à partir de la jointure entre bloque et heats
        $stmt = $conn->prepare("
            INSERT INTO bloque (serie, concu, ligne)
            SELECT h1.serie, ifnull(h1.concu,h2.concu), h1.ligne
            FROM heats h1
            LEFT JOIN heats h2
            ON h1.srcrank =h2.rank AND h1.srcheat=h2.heat AND h1.categ=h2.categ
            WHERE h1.serie=?
        ");
        $stmt->bind_param('i', $serie);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'action' => 'updated']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
        }
    

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Données manquantes']);
}

$conn->close();

?>