<?php
include_once 'auth.php';
include_once 'config_livescores2024.php';
include_once 'stats_getjudges-sequences.php';
include_once 'stats_getjudges_Ecarts.php';
include_once 'stats_getjudges_scores.php';

require_once 'correlation.php';
    
    // Exécuter les requêtes et récupérer les données
    
    $judge_scores = get_judge_scores($conn);
    
    // Calculer la corrélation entre les juges
    $judges = array_keys($judge_scores);
    $correlation_matrix = [];
    
    foreach ($judges as $judge1) {
        $correlation_matrix[$judge1] = [];
        foreach ($judges as $judge2) {
            if ($judge1 == $judge2) {
                $correlation_matrix[$judge1][$judge2] = 1;
            } else {
                // Trouver les séries communes évaluées par les deux juges
                $common_series = array_intersect_key($judge_scores[$judge1], $judge_scores[$judge2]);
                $scores1 = [];
                $scores2 = [];
                foreach ($common_series as $serie => $score) {
                    $scores1[] = $score;
                    $scores2[] = $judge_scores[$judge2][$serie];
                }
                if (count($scores1) > 0) {
                    $correlation = pearson_correlation($scores1, $scores2);
                } else {
                    $correlation = 0;
                }
                $correlation_matrix[$judge1][$judge2] = round($correlation, 2);
            }
        }
    }
    
   
// include_once 'includes/functions.php'; // Si nécessaire

// Récupérer les données des séquences
$sequencesData = getSequences($conn);

// Récupérer les données de l'écart pondéré
$ecartData = getEcartPondere($conn);

$conn->close();

// Préparer les données pour Chart.js
$juges = [];
$total_heats = [];
$longest_sequence = [];

foreach ($sequencesData as $data) {
    $juges[] = $data['nomjuge'];
    $total_heats[] = $data['total_heats'];
    $longest_sequence[] = $data['longest_sequence'];
}

$juges2 = [];
$total_notes = [];
$somecart = [];
$ecartpondere = [];

foreach ($ecartData as $data) {
    $juges2[] = $data['nomjuge'];
    $total_notes[] = $data['nbrenote'];
    $somecart[] = $data['somecart'];
    $ecartpondere[] = $data['ecartpondere'];
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Dashboard</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- Optionnel : FontAwesome pour les icônes -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css"></head>
<body>
    <?php
// Définir la page active
$page = 'stats';

// Inclure les fichiers nécessaires

require_once 'header_menu.php';
?>
    <!-- Contenu Statistiques -->
    <div class="container my-5">
        <!-- Première Ligne : Graphiques Principaux -->
        <div class="row mb-4">
            <!-- Graphique 1 : Statistiques des Juges -->
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Nombre de séries par juge</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="groupedBarChart"></canvas>
                    </div>
                </div>
            </div>
            <!-- Graphique 2 : Écart Pondéré -->
            <div class="col-lg-6 col-md-12 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Classement des juges</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="comboChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Deuxième Ligne : Autres Statistiques (Exemple) -->
        <div class="row mb-4">
            <!-- Carte Statistique 1 -->
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card text-white bg-info shadow h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-chart-line fa-3x"></i>
                            <div class="ms-3">
                                <h5 class="card-title">Total Heats</h5>
                                <p class="card-text display-6"><?php echo "TBD"; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Carte Statistique 2 -->
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card text-white bg-warning shadow h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-hourglass-half fa-3x"></i>
                            <div class="ms-3">
                                <h5 class="card-title">Longueur Séquence Max</h5>
                                <p class="card-text display-6"><?php echo max($longest_sequence); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Carte Statistique 2 -->
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card text-white bg-danger shadow h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-analytics fa-3x"></i>
                            <div class="ms-3">
                                <h5 class="card-title">Stat3</h5>
                                <p class="card-text display-6"><?php echo "TBD"; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Troisième Ligne : Corrélation des Notes entre Juges -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow h-100">
                    <div class="card-header bg-secondary text-white">
                        <h5 class="mb-0">Corrélation des Notes entre Juges</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="correlationHeatmap"></canvas>
                    </div>
                </div>
            </div>
        </div>
        </div>

        <!-- Ajouter d'autres lignes ou cartes ici pour de nouvelles statistiques -->
    </div>

    <!-- Scripts pour les Graphiques -->
    <script>
        // Données pour le Graphique à Barres Groupées
        const groupedBarChartData = {
            labels: <?php echo json_encode($juges); ?>,
            datasets: [
                {
                    label: 'Total Heats',
                    data: <?php echo json_encode($total_heats); ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Longueur Séquence Max',
                    data: <?php echo json_encode($longest_sequence); ?>,
                    backgroundColor: 'rgba(75, 192, 192, 0.6)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }
            ]
        };

        const ctx1 = document.getElementById('groupedBarChart').getContext('2d');
        const groupedBarChart = new Chart(ctx1, {
            type: 'bar',
            data: groupedBarChartData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: false,
                        text: 'Statistiques des Juges'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Nombre'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Juges'
                        }
                    }
                }
            }
        });

        // Données pour le Graphique Combiné (Barres + Ligne)
        const comboChartData = {
            labels: <?php echo json_encode($juges2); ?>,
            datasets: [
                {
                    type: 'bar',
                    label: 'Total Notes',
                    data: <?php echo json_encode($total_notes); ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    type: 'bar',
                    label: 'Some Cart',
                    data: <?php echo json_encode($somecart); ?>,
                    backgroundColor: 'rgba(255, 206, 86, 0.6)',
                    borderColor: 'rgba(255, 206, 86, 1)',
                    borderWidth: 1
                },
                {
                    type: 'line',
                    label: 'Écart Pondéré',
                    data: <?php echo json_encode($ecartpondere); ?>,
                    borderColor: 'rgba(75, 192, 192, 1)',
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderWidth: 2,
                    fill: true,
                    yAxisID: 'y1'
                }
            ]
        };

        const comboChartOptions = {
            responsive: true,
            interaction: {
                mode: 'index',
                intersect: false
            },
            stacked: false,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: false,
                    text: 'Classement des Juges - Combo Chart'
                }
            },
            scales: {
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: 'Valeurs'
                    },
                    beginAtZero: true
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: 'Écart Pondéré (%)'
                    },
                    grid: {
                        drawOnChartArea: false
                    },
                    beginAtZero: true
                },
                x: {
                    title: {
                        display: true,
                        text: 'Juges'
                    }
                }
            }
        };

        const ctx2 = document.getElementById('comboChart').getContext('2d');
        const comboChart = new Chart(ctx2, {
            type: 'bar', // Type de base
            data: comboChartData,
            options: comboChartOptions
        });
        
        
        
        // Données pour le Heatmap de Corrélation
        const correlationMatrix = <?php echo json_encode($correlation_matrix); ?>;
        const judges = <?php echo json_encode(array_keys($correlation_matrix)); ?>;

        // Transformation de la matrice pour Chart.js
        const data = {
            labels: judges,
            datasets: judges.map(judge => {
                return {
                    label: judge,
                    data: judges.map(otherJudge => correlationMatrix[judge][otherJudge]),
                    backgroundColor: judges.map(otherJudge => {
                        const value = correlationMatrix[judge][otherJudge];
                        return `rgba(${getColor(value)}, 0.6)`; // Fonction pour définir la couleur basée sur la valeur
                    }),
                    borderColor: judges.map(otherJudge => {
                        const value = correlationMatrix[judge][otherJudge];
                        return `rgba(${getColor(value)}, 1)`;
                    }),
                    borderWidth: 1,
                    fill: false,
                };
            })
        };

        // Fonction pour convertir la corrélation en couleur
        function getColor(value) {
            // value est entre -1 et 1
            // Mappez cela à une couleur, par exemple, bleu pour positif, rouge pour négatif
            if (value >= 0.5) {
                // De 0 (blanc) à 1 (bleu)
                const intensity = Math.round(255 * value);
                return `0, ${intensity},0`; // Bleu
            } else {
                // De 0 (blanc) à -1 (rouge)
                const intensity = Math.round(255 * (-value));
                return `${intensity}, 0, 0`; // Rouge
            }
        }

        // Création du graphique de corrélation (Heatmap approximée avec Bar Chart)
        const correlationCtx = document.getElementById('correlationHeatmap').getContext('2d');
        const correlationHeatmap = new Chart(correlationCtx, {
            type: 'bar',
            data: data,
            options: {
                indexAxis: 'y',
                responsive: true,
                plugins: {
                    legend: {
                        display: false, // Masquer la légende
                    },
                    title: {
                        display: true,
                        text: 'Corrélation des Notes entre Juges'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const label = context.dataset.label || '';
                                const value = context.parsed.x;
                                return `${label}: ${value}`;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        beginAtZero: false,
                        min: 0,
                        max: 1,
                        title: {
                            display: true,
                            text: 'Coefficient de Corrélation'
                        }
                    },
                    y: {
                        title: {
                            display: true,
                            text: 'Juges'
                        }
                    }
                }
            }
        });
    </script>

    <!-- Bootstrap JS Bundle (inclut Popper) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
