<?php
// Connexion à la base de données
// Connexion à la base de données MySQL
require 'config_livescores2024.php';
function mmss_to_seconds($str) {
    $str = trim((string)$str);
    if ($str === '') return 0;
    $neg = false;
    if ($str[0] === '-') { $neg = true; $str = substr($str, 1); }

    $parts = explode(':', $str);
    if (count($parts) === 1) { // "7" -> minutes
        $m = (int)$parts[0]; $s = 0;
    } else { // "mm:ss"
        $m = (int)$parts[0]; $s = isset($parts[1]) ? (int)$parts[1] : 0;
    }
    $total = $m * 60 + $s;
    return $neg ? -$total : $total;
}

function seconds_to_mmss($sec) {
    $sec = max(0, (int)$sec);
    $m = floor($sec / 60);
    $s = $sec % 60;
    return sprintf('%02d:%02d', $m, $s);
}


$stmt = $conn->prepare("SELECT chrono_remaining FROM live_options WHERE chrono_state='paused' LIMIT 1");
if (!$stmt) { echo json_encode(['status'=>'error','message'=>$conn->error]); exit; }

$stmt->execute();
$res = $stmt->get_result();

if ($row = $res->fetch_assoc()) {
    // 2) Recalculer le targetTime et reprendre
    $remSec = mmss_to_seconds($row['chrono_remaining']);
    if ($remSec < 0) $remSec = 0;
    $iso = gmdate('Y-m-d\TH:i:s\Z', time() + $remSec);

    $upd = $conn->prepare("
        UPDATE live_options
        SET chrono_state='running', chrono=?, chrono_remaining='00:00'
        WHERE chrono_state='paused'
        LIMIT 1
    ");
    if (!$upd) { echo json_encode(['status'=>'error','message'=>$conn->error]); exit; }

    $upd->bind_param('s', $iso);

    if ($upd->execute()) {
        echo json_encode(['status'=>'success','targettime'=>$iso,'remaining_sec'=>$remSec]);
    } else {
        echo json_encode(['status'=>'error','message'=>$upd->error]);
    }
    $upd->close();
} else {
    // Aucun chrono en pause
    echo json_encode(['status'=>'noop','message'=>'Aucun chrono en pause']);
}
$stmt->close();


    
    
?>
