<?php
session_start();

// Récupération des données du formulaire
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nom_utilisateur = $_POST['nom_utilisateur'];
    $mot_de_passe = $_POST['mot_de_passe'];

    require 'config_connect.php';

    // Préparer la requête pour éviter les injections SQL
    $stmt = $conn->prepare("SELECT user_password,compid FROM phpgen_users WHERE user_name = ?");
    $stmt->bind_param("s", $nom_utilisateur);
    $stmt->execute();
    $stmt->bind_result($mot_de_passe_hash, $compid);
    $stmt->fetch();
    $stmt->close();
    $conn->close();

    // Vérifier le mot de passe
    if (password_verify($mot_de_passe, $mot_de_passe_hash)) {
        $_SESSION['nom_utilisateur'] = $nom_utilisateur;
        $_SESSION['dbname']  = $compid;
        header("Location: SurfwareAdminCenter.php");
        exit();
    } else {
        echo "<script>alert('Nom d\'utilisateur ou mot de passe incorrect.'); window.location.href='login.html';</script>";
    }
}
?>
