document.addEventListener('DOMContentLoaded', () => {
    const categoriesContainer = document.getElementById('files-nav');
    const roundsContainer = document.getElementById('rounds-nav');
    const heatsContainer = document.getElementById('matches-container');

    // Function to fetch categories and display them
    function fetchCategories() {
        fetch('getcateg.php')
            .then(response => response.json())
            .then(data => {
                categoriesContainer.innerHTML = '';
                data.forEach(category => {
                    const categoryDiv = document.createElement('div');
                    categoryDiv.classList.add('file-entry');
                    categoryDiv.textContent = category.categ;
                    
                    categoryDiv.onclick = () => {
                    // Enlever la classe 'selected' de tous les enfants de 'files-nav'
                    document.querySelectorAll('#files-nav .file-entry').forEach(entry => {
                        entry.classList.remove('selected');
                        fetchRounds(category.categ);
                    });
                    // Ajouter la classe 'selected' à l'élément cliqué
                categoryDiv.classList.add('selected');

                };
                    categoriesContainer.appendChild(categoryDiv);
                    
                });
            })
            .catch(error => console.error('Error fetching categories:', error));
    }

    // Function to fetch and display rounds for a selected category
    function fetchRounds(category) {
        fetch(`getrounds.php?category=${encodeURIComponent(category)}`)
            .then(response => response.json())
            .then(data => {
                roundsContainer.innerHTML = '';
                data.forEach(round => {
                    const roundDiv = document.createElement('div');
                    roundDiv.classList.add('round-entry');
                    roundDiv.textContent = round.round.trim();
                     roundDiv.onclick = () => {
                    // Enlever la classe 'selected' de tous les enfants de 'files-nav'
                    document.querySelectorAll('#rounds-nav .round-entry').forEach(entry => {
                        entry.classList.remove('selected');
                        fetchHeats(category, round.round.trim());
                    });
                    // Ajouter la classe 'selected' à l'élément cliqué
                roundDiv.classList.add('selected');
                
                };
                    roundsContainer.appendChild(roundDiv);
                });
            
            })
        
            .catch(error => console.error('Error fetching rounds:', error));
        const togglecontainer = document.getElementById('toggle-container'); // Le conteneur HTML pour afficher les données
    // Ajouter le toggle global en haut de la page
    togglecontainer.innerHTML = `
        <div class="global-toggle">
            <label class="switch">
                <input type="checkbox" id="globalToggle" onchange="toggleAllExtraLines(this)">
                <span class="slider"></span>
            </label>
            <span>Display Extra-lines</span>
        </div>`;
    }

    
function transformHeatsData(data) {
    const result = {};

    data.forEach(item => {
        const { serie, heat, lycra, nom, club, rank, total } = item;

        if (!result[serie]) {
            result[serie] = {};
        }

        if (!result[serie][heat]) {
            result[serie][heat] = [];
        }

        result[serie][heat].push({
            lycra,
            nom,
            club,
            rank,
            total
        });
    });

    return result;
}

    
  // Function to fetch and display heats data for a selected round
function fetchHeats(category, round) {
    fetch(`getdataheats.php?category=${encodeURIComponent(category)}&round=${encodeURIComponent(round)}`)
        .then(response => response.json())
        .then(data => {
            // Afficher les données transformées
            displayData(data,category,round);
        })
        .catch(error => console.error('Error fetching heats data:', error));
}

    
    
function displayData(data, category, round) {
    const container = document.getElementById('matches-container');
    container.innerHTML = '';

    

    for (const [serie, heats] of Object.entries(data)) {
        let nbrligne = 1;
        for (const [heat, competitors] of Object.entries(heats)) {
            const heatDiv = document.createElement('div');
            heatDiv.classList.add('match');

            // Récupérer l'état 'is_locked' pour le premier compétiteur dans chaque heat (ils ont tous la même valeur)
            const valide = competitors[0].valide ? 'checked' : '';
            
            // Ajouter le titre du heat et l'interrupteur de toggle dans un header flexbox
            heatDiv.innerHTML += `
                <div class='heat-header'>
                    <div class='heat-title' ondblclick="fetchAndUpdateContent(${serie},'')">H${heat}</div>

                        <label class="switch">
                            <input type="checkbox" class="heat-togglebloque" ${competitors[0].blocked} onchange="toggleHeatbloque(${serie}, this)">
                            <span class="slider slider-bloque"></span>
                        </label>
                    
                    <label class="switch">
                        <input type="checkbox" class="heat-toggle" ${valide} onchange="toggleHeat(${serie}, this)">
                        <span class="slider slider-toggle"></span>
                    </label>
                </div>`;

            // Ajouter les compétiteurs 
            competitors.forEach(competitor => {
                let srcrankAndHeat = '';
                let nom = '';
                let club = '';
                let rank = '';
                let total = '';
                let concu = competitor.concu;  // ID du compétiteur
                
                
                if (competitor.srcrank !== null && competitor.srcheat !== null) {
                    srcrankAndHeat = `
                        <div class="heat-progression" contenteditable="true" onkeydown="checkEnterKey(event, '${category}', '${round}', ${heat}, ${serie}, ${competitor.ligne}, this)">
                            ${competitor.srcrank}.${competitor.srcheat}
                        </div>`;
                }

                if (competitor.concu !== null && competitor.nom !== null) {
                    nom = `<div><div>${competitor.concu} - ${competitor.nom}</div><div class='competitor-detail detail-country'>${competitor.club}</div></div>`;
                    club = `<div>${competitor.club}</div>`;
                }
                if (competitor.rank !== null && competitor.total !== null) {
                    rank = `<div class="position color-${competitor.ligne}">${competitor.rank}</div>`;
                    total = `<div>${competitor.total.toFixed(2)}</div>`;
                    
                    
                }

                heatDiv.innerHTML += `
                    <div class='heat-competitor'>
                        <div class='competitor-photo-container'>
                             <img class='competitor-img coul-${competitor.ligne}' src='../photos/anonyme.png'>
                            
                        </div>
                        <div>
                            <div class='competitor-detail detail-name'>
                                ${srcrankAndHeat} ${nom}
                                
                            </div>
                            <!-- <div class="nationality">
                                <div class='competitor-detail detail-country'>${club}</div>
                            </div> -->
                        </div>
                    
                    <div class='competitor-detail score'>${rank}${total}</div>
                    </div>
                `;
                nbrligne++;
            });

            // Ajouter les lignes supplémentaires cachées si le nombre total de lignes est inférieur à 5
            let extraLines = '';
            for (let i = nbrligne; i <= 5; i++) {  // Maximum de 5 lignes
                srcrankAndHeat = `
                    <div contenteditable="true" onkeydown="checkEnterKey(event, '${category}', '${round}', ${heat}, ${serie}, ${i}, this)">
                        x.y
                    </div>`;
                extraLines += `
                    <div class='heat-competitor extra-line extra-line-${serie}-${heat} hidden'>
                        <div class='competitor-photo-container'>
                             <img class='competitor-img coul-${i}' src='../photos/anonyme.png'>
                        </div>
                        <div>
                            <div class='competitor-detail detail-name'>
                                ${srcrankAndHeat} 
                            </div>
                        </div>
                    </div>
                `;
            }

            heatDiv.innerHTML += extraLines;
            container.appendChild(heatDiv);
        }
    }
}


function showheat(serie, element) {
        console.log("Série:", serie);
        console.log("Élément div:", element);
        // Ici, vous pouvez ajouter votre logique pour gérer l'affichage des heats
    }





// Fonction pour vérifier si la touche "Enter" est pressée
function checkEnterKey(event,category,round, heat, serie, ligne, element) {
    if (event.key === 'Enter') {
        event.preventDefault(); // Empêcher la création d'une nouvelle ligne dans contenteditable
        console.log(`category : ${category}, round : ${round}, heat : ${heat}, serie: ${serie}, ligne: ${ligne}, srcrank: ${srcrank}, srcheat: ${srcheat}`);
        updateCompetitorData(category, round, heat, serie, ligne, element);
        element.blur(); // Quitter l'édition après la mise à jour
    }
}

    
    // Initialize fetching categories
    fetchCategories();
});
 // Fonction pour vérifier si la touche "Enter" est pressée
                function checkEnterKey(event, category, round, heat, serie, ligne, element) {
                    if (event.key === 'Enter') {
                        event.preventDefault(); // Empêcher la création d'une nouvelle ligne dans contenteditable
                        updateCompetitorData(category, round, heat, serie, ligne, element);
                    }
                }


// Fonction pour activer/désactiver toutes les extra lines
function toggleAllExtraLines(globalToggle) {
    
    const extraLines = document.querySelectorAll('.extra-line');
    extraLines.forEach(line => {
        console.log(globalToggle.checked);
        if (globalToggle.checked) {
            line.classList.remove('hidden');
        } else {
            line.classList.add('hidden');
        }
    });
}

function toggleHeat(serie, element) {
    // Désactiver tous les autres toggles sauf le toggle actuel
    const toggles = document.querySelectorAll('.heat-toggle');
    

    // Vérifier si le toggle est activé ou désactivé
    const valide = element.checked;

    // Préparer les données à envoyer
    const data = {
        serie: serie,
        valide: valide ? 1 : 0  // Déterminer si c'est la série est validée
    };

    // Envoyer une requête fetch au serveur pour mettre à jour la table 'heats'
    fetch('update_visible.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(result => {
        if (result.success) {
            console.log(`Mise à jour réussie pour le heat ${serie}`);
        } else {
            console.error('Erreur lors de la mise à jour :', result.message);
        }
    })
    .catch(error => console.error('Erreur :', error));
}

function toggleHeatbloque(serie, element) {
    // Désactiver tous les autres toggles sauf le toggle actuel
    const toggles = document.querySelectorAll('.heat-togglebloque');
    
    toggles.forEach(toggle => {
        if (toggle !== element) {
            toggle.checked = false;  // Désactiver les autres toggles
        }
    });

    // Vérifier si le toggle est activé ou désactivé
    const isChecked = element.checked;

    // Préparer les données à envoyer
    const data = {
        serie: serie,
        action: isChecked ? 'lock' : 'unlock'  // Déterminer si c'est une activation ou désactivation
    };

    // Envoyer une requête fetch au serveur pour mettre à jour la table 'bloque'
    fetch('update_bloque.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(result => {
        if (result.success) {
            console.log(`Mise à jour réussie pour le heat ${serie}`);
            globalserie=serie;
        mode="live";
            
        fetchAndUpdateContent(serie,mode);
        } else {
            console.error('Erreur lors de la mise à jour :', result.message);
        }
    })
    .catch(error => console.error('Erreur :', error));
}


// Fonction pour mettre à jour les données lors de la modification inline
function updateCompetitorData(category, round, heat, serie, ligne, element) {
    const value = element.textContent.trim();
    
    // Vérifier que le format est bien X.Y
    if (!/^\d+\.\d+$/.test(value)) {
        alert("Format invalide. Veuillez entrer une valeur sous la forme X.Y.");
        return;
    }

    // Séparer les données srcrank et srcheat avec un split('.')
    const [srcrank, srcheat] = value.split('.');
   
    // Envoyer les données mises à jour au serveur
    fetch('update_competitor.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ category: category, round: round, heat: heat, serie: serie, ligne: ligne, srcrank: srcrank, srcheat: srcheat })
    })
    .then(response => response.json()) // Convertir la réponse en JSON
    .then(data => {
        // Afficher le retour du script PHP dans la console
        console.log('Retour du serveur:', data);

        if (data.success) {
            console.log('Modification réussie');
        } else {
            console.error('Erreur lors de la mise à jour:', data.message);
        }
    })
    .catch(error => console.error('Erreur:', error));
}

