<?php
// /includes/correlation.php

function pearson_correlation($x, $y) {
    $n = count($x);
    if ($n === 0) return 0;
    
    $mean_x = array_sum($x) / $n;
    $mean_y = array_sum($y) / $n;
    
    $numerator = 0;
    $denominator_x = 0;
    $denominator_y = 0;
    
    for ($i = 0; $i < $n; $i++) {
        $diff_x = $x[$i] - $mean_x;
        $diff_y = $y[$i] - $mean_y;
        $numerator += ($diff_x * $diff_y);
        $denominator_x += ($diff_x * $diff_x);
        $denominator_y += ($diff_y * $diff_y);
    }
    
    if ($denominator_x == 0 || $denominator_y == 0) return 0;
    
    return $numerator / sqrt($denominator_x * $denominator_y);
}
?>
