<?php
include_once 'auth.php';

    $page = 'scores'; // Définissez cette variable selon la page
    include 'header_menu.php';
?> 
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
       <link rel="stylesheet" href="../heatstyle.css">
    <link rel="stylesheet" href="../style.css"> 
    <link rel="stylesheet" href="styles_controler.css"> 
    <style>
        
         :root{
      --bg:#0b0c10;
      --panel:#101217;
      --glass:#111827cc;
      --stroke:#2a2f3a;
      --text:#e5e7eb;
      --muted:#9aa0a6;
      --accent:#06b6d4;
      --accent-weak:#0891b2;
      --success:#22c55e;
      --warn:#f59e0b;
      --danger:#ef4444;
      --radius:18px;
      --gap:16px;
    }
    #matches-container {
    
    height: 700px;
    overflow-y: auto;
}
   
        
        
    .neon-gradient{
  position:relative; 
  border-radius:16px;
  /*padding:2px; /* épaisseur du cadre */*/
  /* cadre = dégradé + glow */
  background: conic-gradient(
    from 0deg,
    #00e7ff, #00ff85, #ffd400, #ff5f5f, #9b5cff, #00e7ff
  );
  box-shadow:
    0 0 10px #00e7ff,
    0 0 14px #00ff85,
    0 0 18px #ffd400,
    0 0 22px #ff5f5f,
    0 0 26px #9b5cff;
  /* animation: spin 6s linear infinite;*/
}
.neon-gradient .content{
  border-radius:14px; 
  /* padding:24px 28px;*/
  background:#0f1320; /* fond interne */
}


        
        
    .match {
    border: 1px solid #ccc;
    border-radius: 4px;
    width: 100%;
    flex-shrink: 1; /* Permet aux enfants de se réduire en cas de dépassement */
    min-height: 100px;
            
        }
     

        input[type="number"] {
            font-size: 16px;
            width: 60px;
            text-align: center;
        }
.chrono-btn {
            background-color: #1e1e1e;
            color: #00d4ff;
            border: 1px solid #00d4ff;
            padding: 10px 15px;
            border-radius: 6px;
            font-size: 1em;
            cursor: pointer;
            transition: 0.3s;
        }

        .chrono-btn:hover {
            background-color: #00d4ff;
            color: #000;
        }
        
        .info-card {
    border: 1px solid var(--stroke);
    border-radius: 16px;
    padding: 10px 14px;
    background: #0d1117;
}
        
        .k {
    /* font-size: 20px;*/
    color: var(--muted);
    letter-spacing: .06em;
    text-transform: uppercase;
}
        
 .v {
    /* font-size: clamp(24px, 3.2vw, 40px); */
    font-weight: 800;
    margin-top: 2px;
}
        
.btn-refresh {
    background: linear-gradient(180deg, var(--accent), var(--accent-weak));
    color: #001016;
    border: none;
    height: 50px;
    border-radius: 14px;
    font-weight: 800;
    font-size: 20px;
    padding: 0 18px;
    cursor: pointer;
}
    </style>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-GsLlZN/3F2ErC5ifS5QtgpiJtWd43JWSuIgh7mbzZ8zBps+dvLusV+eNQATqgA/HdeKFVgA5v3S/cIrLF7QnIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


</head>

<body>
<div style="display: flex;">
<div style="width:80%">
    <!-- Flex container for header and competitors-info -->
    <div id="header-competitors-container">
        <!-- Header section with logo and table -->
       

        
        
        <!-- Competitors information section -->
        <div class="header-table" style="background-color:black;">
            <div id="competitor-info" style="background-color:black;"></div>
            <div class='header-center no-print' style="text-align: -webkit-center; background-color:black;">
                <table style="background-color:black; width: 100%;">
                   
                    <tr>
        
                        <td>
                            <div class="neon-gradient">
                              <div class="content">
                                <h1 id="remaining-time">00:00</h1>
                                
                              
                            
                            
                            
                           
                                </div>
                                  
                            </div>
                             <button class="chrono-btn" id="start-chrono-btn">▶ Start</button>
                            <button class="chrono-btn" id="pause-chrono-btn">⏸ Pause</button>
                            <button class="chrono-btn" id="play-chrono-btn">▶︎‖ Play</button>
                            <button class="chrono-btn" id="stop-chrono-btn">◼ Stop</button>
                        </td>
                        <td>
                            <div class="header-table" style="color:white; background-color:black;">
                                <table style="color:white; background-color:black; width: 90%;">
                                    <tr>

                                        <td>
                                           <label>
                                            Mode Edit
                                            <input type="checkbox" id="auto-edit-toggle">
                                        </label>

                                        
                                           <label>
                                            Auto_validate
                                            <input type="checkbox" id="auto-valide-toggle">
                                        </label>

                                        </td>
                                    </tr>
                                    <tr>
                                       <td class="toggle-container d-flex flex-row align-items-center gap-4">
                                      <label class="switch mb-0">
                                        <input type="checkbox" id="refresh-toggle">
                                        <span class="slider"></span>
                                      </label>
                                      
                                        <label>  Auto Refresh</label>
                                        
                                      
                                    </td>


                                    </tr>
                                    <tr>
                                        <td>
                                        <div>Timer
                                            <input type="number" id="minutes" value="20" min="0" max="59">    
                                        </div>
                                        <div>Judges
                                            <input type="number" id="judges" value="4" min="0" max="5">    
                                        </div>

                                            
                                        </td>

                                    </tr>
                                    <tr>
                                       <td class="toggle-container d-flex flex-row align-items-center gap-4">
                                    
                                      <button class="btn-refresh" id="manual-refresh-btn">Manual Refresh</button>
                                    </td>


                                    </tr>
                                </table>
                            </div>
                        </td>
                        
                    </tr>
                    <tr>
                        <div id="prioritytable">
                
                        </div>
                    </tr>
                    
                </table>
                 <div id="page-header">
            <!-- Logo Section -->
            <div class="info-card"><div class="k">Division</div><div id="division-info" class="v"></div></div>
                     
           <div class="info-card"><div class="k">Round</div><div id="round-info" class="v"></div></div>
            <div class="info-card"><div class="k">Heat</div><div id="heat-info" class="v"></div></div>
           
           
            <!-- Table for header information -->
            
        </div>
                
                
               
            </div>
            
        </div>
    </div>

    <!-- Table for scores -->
    <table id="scores-table">
        <thead></thead>
        <tbody></tbody>
    </table>
    
<div id="context-menu" style="position: absolute; display: none; background-color: white; border: 1px solid black; z-index: 1000;">
            <ul style="list-style-type: none; margin: 0; padding: 10px;">
                <li id="cancel">CANCEL</li>
                <li id="remove-interference">REMOVE INTERFERENCE</li>
                <li id="interference-in">INTERFERENCE IN</li>
                <li id="priority-in">PRIORITY IN</li>
            </ul>
        </div>

    <script src="script_controler.js"></script>
</div>
     <div class="no-print" style="width:20%;     background-color: gainsboro;">
    <div style="text-align: center;">
        <button onclick="generatePDF()">Imprimer en PDF</button>
    </div>
    <div id="files-nav"></div>
    <div id="file-menu"></div>
    <div id="rounds-nav"></div>
    <div id="toggle-container" style="align-content: center; width: 100%; margin: auto; "></div>
    <div id="matches-container" style="width: 100%; margin: auto; "></div>
        <div id="category-result" style="align-content: center; width: 100%; margin: auto; "></div>

   
    <script src="heats_manager.js"></script>
    
    
    </div>
</div>
    


    <script>
        function generatePDF() {
            // Sélectionner plusieurs éléments
            var logo = document.getElementById('header-logo-img');
            var element1 = document.getElementById('page-header');
            var element2 = document.getElementById('competitor-info');
            var element3 = document.getElementById('scores-table');
            var entete =  document.getElementById('division-info')
            //console.log(entete);

            // Créer un conteneur temporaire pour combiner les deux éléments
            var combinedContent = document.createElement('div');
            //combinedContent.appendChild(logo.cloneNode(true)); // Cloner le contenu de l'élément 1
            combinedContent.appendChild(entete.cloneNode(true)); // Cloner le contenu de l'élément 1
            //combinedContent.appendChild(element1.cloneNode(true)); // Cloner le contenu de l'élément 1
            combinedContent.appendChild(element2.cloneNode(true)); // Cloner le contenu de l'élément 2
            combinedContent.appendChild(element3.cloneNode(true)); // Cloner le contenu de l'élément 2

            var opt = {
                margin: [0.5, 0.5, 0.5, 0.5], // Marges (en pouces)
                filename: 'heats.pdf',
                image: { type: 'png', quality: 1 },
                html2canvas: { scale: 1, scrollX: 0, scrollY: 0 }, // Réduire l'échelle pour s'adapter
                jsPDF: { unit: 'in', format: 'A3', orientation: 'portrait' } // Lettre US ou A4 selon vos besoins
            };
            
            
            // Générer et enregistrer le PDF
            html2pdf().from(combinedContent).set(opt).toPdf().get('pdf').then(function (pdf) {
                var totalPages = pdf.internal.getNumberOfPages();
                //pdf.deletePage(totalPages); // Supprimer les pages supplémentaires si nécessaire
            }).save();
        }
    </script>
</body>
</html>
