let autoRefreshInterval = null; // Store the interval reference for auto-refresh
let selectedHeat=null;
let globalserie=null;
let mode=null;
let nbrejuges=null;
document.addEventListener('DOMContentLoaded', function () {
    const refreshToggle = document.getElementById('refresh-toggle');
    const manualRefreshBtn = document.getElementById('manual-refresh-btn');
    const startChronoBtn = document.getElementById('start-chrono-btn');
    const stopChronoBtn = document.getElementById('stop-chrono-btn');
    const viewheatbtn = document.getElementById('view-btn');
    const activateheatbtn = document.getElementById('activate-btn');
    let countdownInterval = null;
    

    
loadbloqueFromDatabase();
    
    
function loadbloqueFromDatabase() {
    // Requête fetch pour récupérer la variable depuis le serveur (PHP)
    fetch('getbloque.php')
        .then(response => response.json())
        .then(data => {
       
            // Accéder à l'objet à l'intérieur du tableau
            if (data.length > 0) {
                const retrievedValue = data[0].serie; // Prendre la première entrée du tableau
                nbrejuges = parseInt(data[0].valeur);
                
               
                document.getElementById('minutes').value = data[1].valeur;
                document.getElementById('judges').value = data[0].valeur;
                //console.log("Valeur récupérée :", retrievedValue);
                
                // Utiliser la valeur récupérée pour mettre à jour globalserie
                globalserie = retrievedValue;
                mode="live";
                

                // Appeler fetchAndUpdateContent après avoir récupéré la valeur
                fetchAndUpdateContent(globalserie);
            } else {
                console.error('Aucune donnée trouvée dans le tableau.');
            }
        })
        .catch(error => {
            console.error('Erreur lors de la récupération des données:', error);
        });
}
    
    
    
    //fetchAndUpdateContent(); 

    function stopAutoRefresh() {
        clearInterval(autoRefreshInterval);
        autoRefreshInterval = null;
    }

    refreshToggle.addEventListener('change', function () {
        if (refreshToggle.checked) {
            console.log(globalserie);
            autoRefreshInterval = setInterval(function() {
                    fetchAndUpdateContent(globalserie);
                }, 2000);
        } else {
            stopAutoRefresh();
        }
    });

    manualRefreshBtn.addEventListener('click', function () {
        fetchAndUpdateContent(globalserie);
    });
    
    startChronoBtn.addEventListener('click', function () {
        startChrono();
    });

    stopChronoBtn.addEventListener('click', function () {
        stopChrono();
    });
    
    viewheatbtn.addEventListener('click', function () {
        if (selectedHeat) {
                            // Redirect to the livescoreshisto page with the selected heat
                            window.location.href = `../livescoreshisto.php?heatNumber=${encodeURIComponent(selectedHeat)}`;
                        }
    });
    
    activateheatbtn.addEventListener('click', function () {
        updatebloque(globalserie);
        mode="live";
    });
    

     // Function to stop any existing countdown and clear interval
    function clearCountdownInterval() {
        if (countdownInterval) {
            clearInterval(countdownInterval);  // Clear the existing interval
            countdownInterval = null;          // Reset the variable
        }
    }
    
   const categoriesContainer = document.getElementById('categoriesContainer'); // Reference the dropdown

// Function to fetch categories and display them in a dropdown
function fetchCategories() {
    fetch('getcateg.php')
        .then(response => response.json())
        .then(data => {
            // Clear the dropdown first
            categoriesContainer.innerHTML = '';

            // Create a default option for the dropdown
            const defaultOption = document.createElement('option');
            defaultOption.textContent = 'Select a category';
            defaultOption.value = '';
            categoriesContainer.appendChild(defaultOption);

            // Loop through categories and create option elements
            data.forEach(category => {
                const optionElement = document.createElement('option');
                optionElement.textContent = category.categ;
                optionElement.value = category.categ;

                // Append each option to the dropdown
                categoriesContainer.appendChild(optionElement);
            });

            // Add an event listener to handle selection change
            categoriesContainer.addEventListener('change', function () {
                const selectedCategory = this.value;
                if (selectedCategory) {
                    fetchRounds(selectedCategory);  // Fetch rounds when a category is selected
                }
            });
        })
        .catch(error => console.error('Error fetching categories:', error));
}

    const roundsContainer = document.getElementById('roundsContainer'); // Reference the dropdown

// Function to fetch and display rounds for a selected category
function fetchRounds(category) {
    fetch(`getrounds.php?category=${encodeURIComponent(category)}`)
        .then(response => response.json())
        .then(data => {
            // Clear the dropdown first
            roundsContainer.innerHTML = '';

            // Create a default option for the dropdown
            const defaultOption = document.createElement('option');
            defaultOption.textContent = 'Select a round';
            defaultOption.value = '';
            roundsContainer.appendChild(defaultOption);

            // Loop through the rounds and create option elements
            data.forEach(round => {
                const optionElement = document.createElement('option');
                optionElement.textContent = round.round.trim();
                optionElement.value = round.round.trim();

                // Append each option to the dropdown
                roundsContainer.appendChild(optionElement);
            });

            // Add an event listener to handle selection change
            roundsContainer.addEventListener('change', function () {
                const selectedRound = this.value;
                if (selectedRound) {
                    fetchHeats(category, selectedRound);  // Fetch heats when a round is selected
                }
            });
        })
        .catch(error => console.error('Error fetching rounds:', error));
}
function fetchHeats(category, round) {
    fetch(`getheats.php?category=${encodeURIComponent(category)}&round=${encodeURIComponent(round)}`)
        .then(response => response.json())
        .then(data => {
            // Clear the heats list first
            heatsContainer.innerHTML = '';

            // Create a <ul> element to hold the heat items
            const ulElement = document.createElement('ul');

            // Populate the list with heats
            for (const [serie, heats] of Object.entries(data)) {
                for (const [heat, competitors] of Object.entries(heats)) {
                    const liElement = document.createElement('li');
                    liElement.textContent = heat;
                    liElement.setAttribute('data-heat', serie);

                    // Add an event listener to handle click
                    liElement.addEventListener('click', function () {
                        selectedHeat = this.getAttribute('data-heat');
                        globalserie=selectedHeat;
                        mode="";
                        
                        fetchAndUpdateContent(selectedHeat);
                    });

                    // Append each <li> to the <ul>
                    ulElement.appendChild(liElement);
                }
            }

            // Append the <ul> to the heats container
            heatsContainer.appendChild(ulElement);
        })
        .catch(error => console.error('Error fetching heats:', error));
}


    
    // Function to start the chrono (set targettime to now + 20 minutes)
    function startChrono(targetTime = null) {
        if (!targetTime) {
            let minutes = parseInt(document.getElementById('minutes').value);
            nbrejuges=parseInt(document.getElementById('judges').value);
            // Fetch new targettime from the server (now + 20 minutes)
            fetch(`start_chrono.php?minutes=${minutes}&judges=${nbrejuges}`)
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        clearCountdownInterval();  // Clear any existing countdown
                        updateRemainingTime(data.targettime); // Start the countdown with the new targettime
                        console.log("success");
                    } else {
                        console.error('Error starting chrono:', data.message);
                    }
                })
                .catch(error => console.error('Error starting chrono:', error));
        } else {
            // If targetTime is provided, use it (e.g., stop countdown with an old date)
            //clearCountdownInterval();
            //updateRemainingTime(targetTime); // Use the provided targetTime
        }
    }

    // Function to stop the chrono (use a past date to stop countdown)
    function stopChrono() {
         fetch('stop_chrono.php')
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        clearCountdownInterval();  // Clear any existing countdown
                        //updateRemainingTime(data.targettime); // Start the countdown with the new targettime
                        
                    } else {
                        console.error('Error starting chrono:', data.message);
                    }
                })
                .catch(error => console.error('Error starting chrono:', error));
        const pastDate = "1970-01-01T00:00:00Z"; // An obsolete past date
        
        clearCountdownInterval();
        document.getElementById('remaining-time').innerText = "00:00";
        //startChrono(pastDate);  // Pass the past date to stop the countdown properly
    }

    // Function to update the remaining time for the countdown
    function updateRemainingTime(targetTimeSRC) {
        // Clear any existing countdown to avoid multiple intervals
        clearCountdownInterval();

        // Start a new countdown interval
        countdownInterval = setInterval(function () {
            const targetTime = new Date(targetTimeSRC); // Convert the target time from string to Date
            const now = new Date(); // Current time
            const diff = targetTime - now; // Calculate the remaining time in milliseconds

            if (diff <= 0) {
                document.getElementById('remaining-time').innerText = "00:00";
                clearCountdownInterval(); // Stop the interval when time is up
                return;
            }

            // Convert the difference to hours, minutes, and seconds
            const hours = Math.floor(diff / (1000 * 60 * 60));
            const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((diff % (1000 * 60)) / 1000);

            // Format the time as HH:MM:SS
            const formattedTime = 
                // (hours < 10 ? "0" : "") + hours + ":" +
                (minutes < 10 ? "0" : "") + minutes + ":" +
                (seconds < 10 ? "0" : "") + seconds;

            // Update the remaining time on the page
            document.getElementById('remaining-time').innerText = formattedTime;
        }, 1000);
    }

    
    
    function fetchAndUpdateContent(serie) {
        //console.log(`ligne 250 : ${globalserie}`);
        globalserie=serie;
        
        
        fetch(`fetch_data.php?serie=${serie}`)
        .then(response => response.json())
        .then(response => {
            const maxVagues = 15;
            const data = response.data;
            const headerData = response.header;
            const tableData = prepareTableData(data, maxVagues);
            
            renderHeader(headerData);
            renderCompetitorInfo(tableData);
            renderScoreTable(tableData, maxVagues);
            bindContextMenu();
            updateRemainingTime(headerData.targettime);
           
            // Call the function to send the table data to your PHP script
        prepareAndSendTableData(tableData,headerData); // Call this to send the data
            
        })
        .catch(error => console.error('Error fetching data:', error));
    }

  function renderScoreTable(competitors, maxVague = 15) {
      
    const tableBody = document.querySelector('#scores-table tbody');
    const tableHead = document.querySelector('#scores-table thead');
    let tableHtml = '';
    const maxVagues = 15;
    
    // Generate the wave headers (W1, W2, W3...) with exactly 15 columns
    let waveHeaderHtml = '<tr><th></th>'; // First empty cell for judge column
    for (let i = 1; i <= maxVagues; i++) {
        waveHeaderHtml += `<th>W${i}</th>`;
    }
    waveHeaderHtml += '</tr>';

    // Insert the wave header row into the table header
    tableHead.innerHTML = waveHeaderHtml;

    // Render each competitor's scores
    Object.keys(competitors).forEach(ligne => {
        let competitor = competitors[ligne];
        
        // Render each judge's scores with color applied to empty cells
        Object.keys(competitor.judges).forEach(judge => {
            let rowHtml = `<tr><td>J${judge}</td>`; // First column for the judge
            competitor.judges[judge].forEach((wave, index) => {
                const colorClass = wave.coul || `coul-${competitor.ligne}`; // Get the color class or use default color

                // Ensure serie and concu are included
                const serie = competitor.serie;
                const concu = competitor.concu;

                if (wave.note) {
                    
                    // Make the cell editable and include serie and concu
                    rowHtml += `<td class="${colorClass}" contenteditable="true" data-serie="${serie}" data-concu="${concu}" data-judge="${judge}" data-wave="${index + 1}">${wave.note}</td>`;
                } else {
                    
                    rowHtml += `<td class="${colorClass}" contenteditable="true" data-serie="${serie}" data-concu="${concu}" data-judge="${judge}" data-wave="${index + 1}">-</td>`; // Editable empty cells as well
                }
            });
           
            for (let i = competitor.judges[judge].length; i < maxVagues; i++) {
                const colorClass = `coul-${competitor.ligne}`;
                const serie = competitor.serie;
                const concu = competitor.concu;

                rowHtml += `<td class="${colorClass}" contenteditable="true" data-serie="${serie}" data-concu="${concu}" data-judge="${judge}" data-wave="${i + 1}">-</td>`;
            }
            
            rowHtml += '</tr>';
            tableHtml += rowHtml;
        });

        // Render averages row with best scores highlighted in red and bold
        // Now pass interferenceCount and hasPriority to renderAverageRow
        
        tableHtml += renderAverageRow(
            competitor.averages,
            competitor.bestTwo,
            maxVagues,
            competitor.serie,
            competitor.concu,
            competitor.interferenceFlags,
            competitor.hasPriority,
            competitor.interferenceCount,
            competitor.valideFlags
            
        );
       
    });

    // Insert the table HTML into the page
    tableBody.innerHTML = tableHtml;

    // Add event listener for editing notes (if needed)
    addEditableListeners();
}


    

    






    document.addEventListener('click', function (event) {
        const contextMenu = document.getElementById('context-menu');
        if (!event.target.closest('.average-cell') && !event.target.closest('#context-menu')) {
            contextMenu.style.display = 'none';
        }
    });

 // Initialize fetching categories
    fetchCategories();
});



// Function to render the header with competition details dynamically
    function renderHeader(headerData) {
         document.getElementById('division-info').textContent = headerData.division;
        document.getElementById('round-info').textContent = headerData.tour;
        document.getElementById('heat-info').textContent = headerData.heat;
    }


// Function to prepare table data and calculate best averages
function prepareTableData(data, maxVagues) {
    const competitors = {};

    data.forEach(entry => {
        const ligne = parseInt(entry.ligne);  // Ensure 'ligne' is an integer
        const juge = parseInt(entry.juge);    // Convert 'juge' to an integer
        const vague = parseInt(entry.vague);  // Convert 'vague' to an integer
        const concu = parseInt(entry.concu);  // Convert 'concu' to an integer
        const note = parseFloat(entry.note);
        const prio = parseInt(entry.prio);
        //const valide = parseInt(entry.valide);

        
let validevalue = isAutoValide ? 1 : 0;

        // Initialize competitor if not done already
        if (!competitors[ligne]) {
            competitors[ligne] = {
                nom: entry.nom,
                club: entry.club,
                ligne: ligne,
                serie: entry.serie,
                concu: concu,
                judges: {},
                averages: [],
                bestTwo: [0, 0],
                moyennes: [], // Ajouter ici le tableau pour stocker toutes les moyennes
                total: 0,
                interferenceFlags: Array(maxVagues).fill(false),
                valideFlags: Array(maxVagues).fill(validevalue),
                hasPriority: false,  // Priority flag for note = 14
                interferenceCount: 0, // Interference count for note = 11
                coul: entry.coul,
                rank: 0,  // Initialiser le classement
                prio: prio,
                needs: '' // Initialiser le statut "needs"
            };
            
        }
        
        if (isAutoValide) {
            competitors[ligne].valideFlags[vague - 1]=1
        } else {
            competitors[ligne].valideFlags[vague - 1] = parseInt(entry.valide);
        }
        // Ignore notes with juge = 0 (interference) for display
        if (juge === 0 && (note === 11 || note === 14)) {
            competitors[ligne].interferenceFlags[vague - 1] = true;

            // Mark the competitor as having priority if note = 14
            if (note === 14) {
                competitors[ligne].hasPriority = true;
            }

            // Track interference count for note = 11
            if (note === 11) {
                competitors[ligne].interferenceCount++;
            }

            return; // Skip further processing for interference
        }

        if (!competitors[ligne].judges[juge]) {
            competitors[ligne].judges[juge] = Array(maxVagues).fill('-');
        }

        // Store the note for the correct wave
        competitors[ligne].judges[juge][vague - 1] = {
            note: note,
            coul: entry.coul
        };

        // Store the note for average calculation if no interference
        if (!competitors[ligne].averages[vague - 1]) {
            competitors[ligne].averages[vague - 1] = [];
        }
        competitors[ligne].averages[vague - 1].push(note);

    });

    // Calculate the best averages and the total
    Object.keys(competitors).forEach(ligne => {
     
        let validAverages = competitors[ligne].averages.map((notes, index) => {
            if (competitors[ligne].interferenceFlags[index] || notes.length < 4) {
                // Skip calculation if interference is detected or there are fewer than 3 notes
                //return '-';
            }
            let sortedNotes = notes.sort((a, b) => a - b);
            let avg=null
            
            if (sortedNotes.length >= nbrejuges) {
                
                sortedNotes = sortedNotes.slice(1, - 1); // Remove the smallest and largest note
                
             avg = (sortedNotes.reduce((a, b) => a + b, 0) / sortedNotes.length).toFixed(2);
            } else if (sortedNotes.length > 0) {
                 avg = 21;
            } else {
                 avg = 0;
                
            }
            
            if (competitors[ligne].interferenceFlags[index]) { 
                avg=11; 
            }
            if (competitors[ligne].valideFlags[index]!==1) { 
                avg='NV'; 
            }
                
            // Ajouter la moyenne calculée dans le tableau moyennes
            competitors[ligne].moyennes.push({
                id: index,
                value: parseFloat(avg), // La valeur de la moyenne
                isBestScore: false,     // Initialement, pas encore une des meilleures
                color: 'gray',           // Couleur par défaut pour les moyennes ordinaires
                nbrejuge: nbrejuges, 
                nbrenotes: sortedNotes.length
            });
            index++;

            return parseFloat(avg);
        }).filter(avg => avg !== '-' && avg !== 21 && avg !== 11 && avg !== 'NV' ); // Filter out invalid averages

        // Sort the averages to find the two best
        validAverages.sort((a, b) => b - a);
        competitors[ligne].bestTwo[0] = validAverages[0] || 0;
        competitors[ligne].bestTwo[1] = validAverages[1] || 0;

        
        
        competitors[ligne].moyennes.sort((a, b) => b.value - a.value);
        //console.log(competitors[ligne].moyennes);
        
        // Marquer les deux meilleures moyennes dans le tableau moyennes et leur attribuer des couleurs
        let bestScoreCount = 0; // Compteur pour suivre le nombre de meilleures moyennes marquées
        let sortedMoyennes = [...competitors[ligne].moyennes].sort((a, b) => b.value - a.value);

        competitors[ligne].moyennes.forEach(moyenne => {
            if (moyenne.value<11 && bestScoreCount < 2 && (moyenne.value === competitors[ligne].bestTwo[0])) {
                moyenne.isBestScore = true;  // Indiquer que c'est une des meilleures moyennes
                moyenne.color = 'red';       // Attribuer la couleur rouge pour les meilleures moyennes
                bestScoreCount++;            // Incrémenter le compteur
            } else
            if (moyenne.value<11 && bestScoreCount < 2 && (moyenne.value === competitors[ligne].bestTwo[1])) {
                
                if (competitors[ligne].hasPriority) {
                    // Priority case: second-best score is 0
                    moyenne.value=0;
                } else if (competitors[ligne].interferenceCount > 0) {
                    // Interference case: divide second-best score by 2
                    let adjustedSecondBest = competitors[ligne].bestTwo[1] / (2 ** competitors[ligne].interferenceCount);
                    moyenne.value=adjustedSecondBest;
                } 
                moyenne.isBestScore = true;  // Indiquer que c'est une des meilleures moyennes
                moyenne.color = 'red';       // Attribuer la couleur rouge pour les meilleures moyennes
                bestScoreCount++;            // Incrémenter le compteur
            }
        });

        // Adjust the total and second-best score based on priority or interference
        if (competitors[ligne].hasPriority) {
            // Priority case: second-best score is 0
            competitors[ligne].total = competitors[ligne].bestTwo[0];
        } else if (competitors[ligne].interferenceCount > 0) {
            // Interference case: divide second-best score by 2
            let adjustedSecondBest = competitors[ligne].bestTwo[1] / (2 ** competitors[ligne].interferenceCount);
            competitors[ligne].total = (competitors[ligne].bestTwo[0] + adjustedSecondBest).toFixed(2);
        } else {
            // Normal case: sum of best two scores
            competitors[ligne].total = (competitors[ligne].bestTwo[0] + competitors[ligne].bestTwo[1]).toFixed(2);
        }
        
        
        competitors[ligne].moyennes.sort((a, b) => a.id - b.id);
        
    });
    //return;


    // Calcul du classement et du statut "needs"
    const sortedCompetitors = Object.values(competitors).sort((a, b) => b.total - a.total);
    const firstPlaceTotal = sortedCompetitors.length > 0 ? sortedCompetitors[0].total : 0;
    const secondPlaceTotal = sortedCompetitors.length > 1 ? sortedCompetitors[1].total : 0;

    sortedCompetitors.forEach((competitor, index) => {
        competitor.rank = index + 1; // Calculer le classement en fonction de l'index du tri
        if (competitor.rank === 1) {
            competitor.needs = 'Win'; // Le premier a juste besoin de gagner
        } else if (competitor.rank === 2) {
            // Le second doit battre le premier
            competitor.needs = calculatePointsNeededWithInterference(competitor, firstPlaceTotal);
        } else {
            // Les autres doivent battre à la fois le premier et le deuxième
            competitor.needs = calculatePointsNeededWithInterference(competitor, firstPlaceTotal) + ' (1st), ' + calculatePointsNeededWithInterference(competitor, secondPlaceTotal) + ' (2nd)';
        }
    });

    return competitors;
}






function renderAverageRow(averages, bestTwo, maxVagues, serie, concu, interferenceFlags, hasPriority, interferenceCount, valideFlags) {
    let averageRowHtml = '<tr class="average-row"><td><strong>Moyenne</strong></td>';

    let calculatedAverages = averages.map((notes, waveIndex) => {
        // Check if there's an interference flag for this wave
        if (interferenceFlags && interferenceFlags[waveIndex]) {
            return '▲'; // Display the triangle symbol for interference
        }

        if (!notes || notes.length === 0) {
            return '-';
            
        } else if (notes.length > 0 && notes.length < nbrejuges ) {
            return '-';
           
        }
        
        let sortedNotes = [...notes].sort((a, b) => a - b);
        if (sortedNotes.length > 3) {
            sortedNotes = sortedNotes.slice(1, -1); // Remove smallest and largest
        }
        
        const avg = (sortedNotes.reduce((a, b) => a + b, 0) / sortedNotes.length).toFixed(2);
        //console.log(valideFlags[waveIndex]);
        return parseFloat(avg);
        
        
    });

    // Track if we have already highlighted the best two scores
    let bestTwoHighlighted = { best: false, second: false };

    
    
    // Display the averages with color, highlighting best scores in red and bold
    calculatedAverages.forEach((avg, waveIndex) => {
        let highlight = '';

        if (!bestTwoHighlighted.best && avg === bestTwo[0]) {
            highlight = 'style="color: red; font-weight: bold;"';
            bestTwoHighlighted.best = true;
        } else if (!bestTwoHighlighted.second && avg === bestTwo[1]) {
            highlight = 'style="color: red; font-weight: bold;"';
            bestTwoHighlighted.second = true;
        }

        // Check if priority exists for this competitor (second best is 0)
        if (hasPriority && avg === bestTwo[1]) {
            avg = 0;
        }

        // Check if interference exists (second best is divided by 2)
        if (interferenceCount === 1 && avg === bestTwo[1]) {
            avg = (avg / 2).toFixed(2); // Division by 2 and round to 2 decimal places
        } else if (interferenceCount === 2 && avg === bestTwo[1]) {
            avg = 0; // Completely remove second best if there are 2 interferences
        }
        if (valideFlags[waveIndex]===1) {
            // Add a class 'average-cell' to these specific cells, and include data-serie, data-wave, and data-concu attributes
            averageRowHtml += `<td class="average-cell" ${highlight} data-serie="${serie}" data-wave="${waveIndex + 1}" data-concu="${concu}">${avg}</td>`;
        } else {
            averageRowHtml += `<td style="background-color: gray; color: lightgray;" class="average-cell" ${highlight} data-serie="${serie}" data-wave="${waveIndex + 1}" data-concu="${concu}">${avg}</td>`;
        }
    
    });

    // Fill remaining empty columns up to 15 if necessary
    for (let i = calculatedAverages.length; i < maxVagues; i++) {
        averageRowHtml += `<td>-</td>`;
    }

    averageRowHtml += '</tr>';
    return averageRowHtml;
}


 function fetchAndUpdateContent(serie) {
        //console.log(`ligne 605 : ${globalserie}`);
     globalserie=serie;
     //document.getElementById('auto-valide-toggle').checked = true;
        //isAutoValide=true;
        
     
        fetch(`fetch_data.php?serie=${serie}`)
        .then(response => response.json())
        .then(response => {
            
            const maxVagues = 15;
            const data = response.data;
            const headerData = response.header;
            const tableData = prepareTableData(data, maxVagues);
            //console.log(tableData);
            renderHeader(headerData);
            renderCompetitorInfo(tableData);
            renderScoreTable(tableData, maxVagues);
            bindContextMenu();
            //updateRemainingTime(headerData.targettime);
            
            // Call the function to send the table data to your PHP script
        prepareAndSendTableData(tableData,headerData); // Call this to send the data
            })
        .catch(error => console.error('Error fetching data:', error));
    }

function prepareAndSendTableData(tableData,headerData) {
    // Structure de base du JSON
    const output = {
        compete: globalserie, // Remplacer par la bonne valeur
        categ: headerData.division, // Remplacer par la bonne valeur
        round: headerData.tour, // Remplacer par la bonne valeur
        heat: headerData.heat, // Remplacer par la bonne valeur
        chrono: headerData.targettime, // Remplacer par la bonne valeur
        competitors: []
    };

    // Pour chaque compétiteur dans l'objet "competitors"
    Object.keys(tableData).forEach(ligne => {
        const competitor = tableData[ligne];
        const competitorData = {
            name: competitor.nom,
            score: competitor.total, // Score total calculé
            needs: competitor.needs, // Exemple de valeur, à ajuster selon les besoins
            position: competitor.rank, // Position calculée
            Competitor_Id: ligne, // Ligne correspondante à l'ID du compétiteur
            club: competitor.club,
            interf: competitor.interferenceCount, // Nombre d'interférences
            ligne: competitor.ligne,
            lycra: competitor.coul, // Correspond à la couleur
            scores: [], // Tableau des scores
            moyennes: [] // Ajouter un tableau pour les moyennes
            
        };

        // Ajouter les scores pour chaque vague
        competitor.averages.forEach((scoresArray, vagueIndex) => {
            scoresArray.forEach(score => {
                competitorData.scores.push({
                    id: vagueIndex + 1, // Id correspondant à la vague
                    value: score,
                    color: "" // Vous pouvez adapter cette valeur
                });
            });
        });
       
        
        // Ajouter les moyennes calculées avec leur statut et couleur
        competitor.moyennes.forEach((moyenne, vagueIndex) => {
            if (competitor.valideFlags[vagueIndex]===1) {
            competitorData.moyennes.push({
                value: moyenne.value,     // Valeur de la moyenne
                isBestScore: moyenne.isBestScore,
                id: vagueIndex + 1,
                color: moyenne.color      // Couleur associée à la moyenne
            });
        }
        });

        // Ajouter chaque compétiteur au tableau final
        output.competitors.push(competitorData);
    });

    // Place the output inside an array to ensure the correct format
    const jsonToSend = [output];

    // Afficher le JSON dans la console pour vérification
    //console.log("JSON préparé :", JSON.stringify(jsonToSend, null, 2));
let validevalue = isAutoValide ? 1 : 0;
    // Optionnel : vous pouvez commenter cette partie pour le moment si vous voulez juste tester l'affichage
    console.log(`../savedata.php?mode=${mode}&autovalide=${validevalue}`);
    
    fetch(`../savedata.php?mode=${mode}&autovalide=${validevalue}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(jsonToSend), // Convertit l'objet JS en JSON
    })
    .then(response => response.text())
    .then(data => {
        //console.log('Success:', data);
        mode="";
    })
    .catch((error) => {
        console.error('Error:', error);
    });
    
}




function renderCompetitorInfo(competitors) {
    const competitorInfoSection = document.querySelector('#competitor-info');
    competitorInfoSection.style.width = "60%"; // Limit the width to 60%

    let competitorInfoHtml = '<table style="width:100%;"><thead><tr><th>Rank</th><th>Name</th><th>Club</th><th>Total</th><th>To 1st</th><th>To 2nd</th></tr></thead><tbody>';
    let competitorList = [];
    let sortedByTotal = [];

    // Add all competitors to the list
    Object.keys(competitors).forEach(ligne => {
        competitorList.push(competitors[ligne]);
    });

    // Sort by total first, and then by comparing moyennes in case of a tie
    sortedByTotal = [...competitorList].sort((a, b) => {
        // Compare by total first
        if (b.total !== a.total) {
            return b.total - a.total;
        }

        // Sort moyennes by 'value' in descending order for both competitors
        const sortedMoyennesA = [...a.moyennes].sort((x, y) => y.value - x.value); // Tri décroissant sur 'value'
        const sortedMoyennesB = [...b.moyennes].sort((x, y) => y.value - x.value); // Tri décroissant sur 'value'

        // If totals are equal, compare moyennes (using 'value') one by one
        for (let i = 0; i < Math.min(sortedMoyennesA.length, sortedMoyennesB.length); i++) {
            if (sortedMoyennesB[i].value !== sortedMoyennesA[i].value) {
                return sortedMoyennesB[i].value - sortedMoyennesA[i].value; // Compare the next moyenne
            }
        }

        // If all moyennes are equal, return 0 (keep them equal)
        return 0;
    });

    // Prepare variables for first and second place totals
    const firstPlaceTotal = sortedByTotal.length > 0 ? sortedByTotal[0].total : 0;
    const secondPlaceTotal = sortedByTotal.length > 1 ? sortedByTotal[1].total : 0;

    // Render each competitor in order of rank
    sortedByTotal.forEach(competitor => {
        let rank = sortedByTotal.indexOf(competitor) + 1;
        let pointsToBeatFirst = '', pointsToBeatSecond = '';

        // Handle priority and interference logic for the header
        let displaySecondBest = competitor.bestTwo[1].toFixed(2); // Default to the actual second best
        if (competitor.hasPriority) {
            displaySecondBest = 0; // If priority, second best is displayed as 0
        } else if (competitor.interferenceCount > 0) {
            if (competitor.interferenceCount === 1) {
                displaySecondBest = (competitor.bestTwo[1] / 2).toFixed(2); // Reduce second best
            } else if (competitor.interferenceCount === 2) {
                displaySecondBest = 0; // No second best if 2 interferences
            }
        }

        // Determine points needed to beat first or second place
        if (rank === 1) {
            pointsToBeatFirst = 'Win';
            pointsToBeatSecond = 'Win';
        } else if (rank === 2) {
            pointsToBeatFirst = calculatePointsNeededWithInterference(
                competitor, firstPlaceTotal
            );
        } else {
            pointsToBeatFirst = calculatePointsNeededWithInterference(
                competitor, firstPlaceTotal
            );
            pointsToBeatSecond = calculatePointsNeededWithInterference(
                competitor, secondPlaceTotal
            );
        }

        if (competitor.total > 0) {
            updateScores(globalserie, competitor.ligne, rank, competitor.total);
        }

        // Apply the competitor's color to the row
        const colorClass = competitor.coul;

        // Add competitor info to the table
        competitorInfoHtml += `
            <tr class="${colorClass}">
                <td>#${rank}</td>
                <td>${competitor.nom}</td>
                <td>${competitor.club}</td>
               <!-- <td>${competitor.bestTwo[0].toFixed(2)}</td>
                <td>${displaySecondBest}</td> -->
                <td><div style="display: flex; flex-direction: column; align-items: center;">
    <div style="text-align: right; font-weight: bold;">${competitor.total}</div> <!-- Le total -->
    <div>${competitor.bestTwo[0].toFixed(2)} - ${displaySecondBest}</div> <!-- Les deux scores en dessous du total -->
</div></td>
                <td style="vertical-align: bottom; text-align: right;">${pointsToBeatFirst}</td>
                <td style="vertical-align: bottom; text-align: right;">${pointsToBeatSecond}</td>
            </tr>`;
    });

    competitorInfoHtml += '</tbody></table>';

    // Insert the competitor info HTML into the page
    competitorInfoSection.innerHTML = competitorInfoHtml;

    // --- Code pour la gestion des priorités ---
    let priorityCompetitors = [];
    Object.keys(competitors).forEach(ligne => {
        let competitor = competitors[ligne];
        if (competitor.prio && competitor.prio != 0) {
            priorityCompetitors.push({
                ligne: competitor.ligne,
                prio: competitor.prio,
                coul: competitor.coul
            });
        }
    });

    // Trier par priorité
    priorityCompetitors.sort((a, b) => a.prio - b.prio);

    // Construire le HTML pour la table de priorités
    let priorityTableHtml = '<table style="width: 100%;"><tbody><tr>';

    priorityCompetitors.forEach(competitor => {
        priorityTableHtml += `<td style="font-weight:bold; text-align: center;" class="${competitor.coul}">P${competitor.prio}</td>`;
        
    });

    priorityTableHtml += '</tr></tbody></table>';

    const priorityDiv = document.querySelector('#prioritytable');
    priorityDiv.innerHTML = priorityTableHtml;
}







function calculatePointsNeeded(competitor, targetTotal) {
    const bestScore = competitor.bestTwo[0];
    let secondBest = competitor.bestTwo[1]; // Default second best score

    // Adjust second best based on interference count
    if (competitor.hasPriority) {
        secondBest = 0;  // Ignore second best if priority exists
    } else if (competitor.interferenceCount === 1) {
        secondBest = secondBest / 2; // Halve the second best score
    } else if (competitor.interferenceCount === 2) {
        secondBest = 0; // Set second best to 0 if two interferences exist
    }

    // Case 1: Try replacing the second-best score
    let scoreToBeat = (parseFloat(targetTotal) + 0.01 - bestScore).toFixed(2);
    if (scoreToBeat <= 10 && scoreToBeat > secondBest) {
        return parseFloat(scoreToBeat);
    }

    // Case 2: Try replacing the best score, consider the second-best in total
    scoreToBeat = (parseFloat(targetTotal) + 0.01 - secondBest).toFixed(2);
    if (scoreToBeat <= 10) {
        return parseFloat(scoreToBeat);
    }

    // Case 3: Cannot beat the target with a maximum of 10 points
    return parseFloat(targetTotal + 0.01);
}

function calculatePointsNeededWithInterference(competitor, targetTotal) {
    targetTotal = parseFloat(targetTotal) || 0;
 //console.log('Competitor data:', competitor);
//    console.log('Target total:', targetTotal);
    let bestScore = parseFloat(competitor.bestTwo[0]) || 0;
    let secondBestScore = parseFloat(competitor.bestTwo[1]) || 0;
    let maxScore = 10; // Maximum possible score for a wave

    // Case: Priority or Double Interference (second best is treated as 0)
    if (competitor.hasPriority || competitor.interferenceCount === 2) {
        secondBestScore = 0; // Second best is set to 0

        // Calculate if they can beat the target with just the best score
        let currentTotal = bestScore; // Only the best score is considered

        if (targetTotal <= maxScore) {
            // If the difference between targetTotal and currentTotal is less than or equal to maxScore
            return parseFloat((targetTotal + 0.01));
        } else {
            // If not, it's impossible to beat the target
            return "impossible";
        }
    }

    // Case: Single Interference (second best is halved)
  if (competitor.interferenceCount === 1) {
    secondBestScore = secondBestScore / 2;

    let X = (targetTotal - bestScore) * 2;
  

    if (X > 10) {
        if (X > targetTotal) {
            if (X > 20) {
                return "impossible"; 
            } else if ((targetTotal - (bestScore / 2)) < 10) {
        
        return (targetTotal - (bestScore / 2)).toFixed(2);
    } else {
        return "impossible"; 
    }
        } else {
            return (X + 0.01).toFixed(2);  // Ensure X is converted to a fixed decimal string
        }
    } else if ((targetTotal - (bestScore / 2)) < 10) {
        
        return (targetTotal - (bestScore / 2)).toFixed(2);
    } else {
        return (targetTotal + 0.01).toFixed(2);
    }
}


    // Case 1: Replacing second best (if it's enough to beat the target)
    if (bestScore + maxScore >= targetTotal) {
        let required = parseFloat((targetTotal - bestScore + 0.01).toFixed(2));
        return Math.min(required, maxScore); // Cap the need by the max possible score (10)
    }

    // Case 2: Replacing the best score to beat the target
    if (maxScore + secondBestScore >= targetTotal) {
        let required = parseFloat((targetTotal - secondBestScore + 0.01).toFixed(2));
        return Math.min(required, maxScore); // Cap the need by the max possible score (10)
    }

    // Case 3: No possible combination to beat the target
    return parseFloat((targetTotal + 0.01).toFixed(2));
}


function renderScoreTable(competitors, maxVague = 15) {
    const tableBody = document.querySelector('#scores-table tbody');
    const tableHead = document.querySelector('#scores-table thead');
    let tableHtml = '';
    const maxVagues = 15;
    
    // Generate the wave headers (W1, W2, W3...) with exactly 15 columns
    let waveHeaderHtml = '<tr><th></th>'; // First empty cell for judge column
    for (let i = 1; i <= maxVagues; i++) {
        waveHeaderHtml += `<th>W${i}</th>`;
    }
    waveHeaderHtml += '</tr>';

    // Insert the wave header row into the table header
    tableHead.innerHTML = waveHeaderHtml;
//console.log(competitors);
    // Render each competitor's scores
    Object.keys(competitors).forEach(ligne => {
        let competitor = competitors[ligne];
        
        
        // Render each judge's scores with color applied to empty cells
        Object.keys(competitor.judges).forEach(judge => {
            let rowHtml = `<tr><td>J${judge}</td>`; // First column for the judge
            competitor.judges[judge].forEach((wave, index) => {
                const colorClass = wave.coul || `coul-${competitor.ligne}`; // Get the color class or use default color

                // Ensure serie and concu are included
                const serie = competitor.serie;
                const concu = competitor.concu;

                if (wave.note) {
                    // Make the cell editable and include serie and concu
                    rowHtml += `<td class="${colorClass}" contenteditable="true" data-serie="${serie}" data-concu="${concu}" data-judge="${judge}" data-wave="${index + 1}">${wave.note}</td>`;
                } else {
                    
                    rowHtml += `<td class="${colorClass}" contenteditable="true" data-serie="${serie}" data-concu="${concu}" data-judge="${judge}" data-wave="${index + 1}">-</td>`; // Editable empty cells as well
                }
            });
            
            // Fill remaining empty wave columns up to 15 if needed
            if (competitor.judges[judge].length>0) {
            for (let i = competitor.judges[judge].length; i < maxVagues; i++) {
                const colorClass = `coul-${competitor.ligne}`;
                const serie = competitor.serie;
                const concu = competitor.concu;

                rowHtml += `<td class="${colorClass}" contenteditable="true" data-serie="${serie}" data-concu="${concu}" data-judge="${judge}" data-wave="${i + 1}">-</td>`;
            }
            }

            rowHtml += '</tr>';
            tableHtml += rowHtml;
        });

        // Render averages row with best scores highlighted in red and bold
        // Now pass interferenceCount and hasPriority to renderAverageRow
        console.log(competitor.valideFlags);
        tableHtml += renderAverageRow(
            competitor.averages,
            competitor.bestTwo,
            maxVagues,
            competitor.serie,
            competitor.concu,
            competitor.interferenceFlags,
            competitor.hasPriority,
            competitor.interferenceCount,
            competitor.valideFlags
        );
    });

    // Insert the table HTML into the page
    tableBody.innerHTML = tableHtml;

    // Add event listener for editing notes (if needed)
    addEditableListeners();
}







let isAutoEdit = false;  // Variable pour gérer l'état de l'auto-edit

// Toggle pour activer ou désactiver le mode AutoEdit
document.getElementById('auto-edit-toggle').addEventListener('change', function () {
    isAutoEdit = this.checked;
    
});

document.getElementById('auto-valide-toggle').checked = false;

let isAutoValide = false;  // Variable pour gérer l'état de l'auto-edit

// Toggle pour activer ou désactiver le mode AutoValidate
document.getElementById('auto-valide-toggle').addEventListener('change', function () {
    isAutoValide = this.checked;
    
});


function addEditableListeners() {
    document.querySelectorAll('td[contenteditable="true"]').forEach(cell => {
        let refresh = null; 
        let oldValue = null;

        // Event to handle when the cell gains focus
        cell.addEventListener('focus', function () {
            refresh = autoRefreshInterval;
            clearInterval(autoRefreshInterval);
            autoRefreshInterval = null;
            oldValue = cell.textContent.trim(); // Store the original value
        });

        // Event to handle "Enter" key press
        cell.addEventListener('keydown', function (event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                let newValue = cell.textContent.trim();  // Get the new value from the cell
            if (oldValue !== newValue) {
                const serie = cell.getAttribute('data-serie');
                const concu = cell.getAttribute('data-concu');
                const judge = cell.getAttribute('data-judge');
                const wave = cell.getAttribute('data-wave');

                // Debug pour vérifier les valeurs
                //console.log(`Serie: ${serie}, Concu: ${concu}, Judge: ${judge}, Wave: ${wave}, Note: ${newValue}`);
                
                // Si la note est valide, effectuer une requête INSERT ou UPDATE
                if (!isNaN(newValue) && newValue !== "") {
                    // Appliquer toFixed(2) après l'édition pour s'assurer de ne pas dépasser 2 décimales
                    newValue = parseFloat(newValue).toFixed(2);
                    updateNoteInDatabase(serie, concu, judge, wave, newValue);
                    cell.textContent = newValue;  // Mettre à jour la cellule avec le format décimal
                } else {
                    alert("Veuillez entrer une note valide.");
                    cell.textContent = "-";
                }

                // Focus on the next cell if AutoEdit is ON
                if (isAutoEdit) {
                    const nextCell = this.nextElementSibling;
                    if (nextCell && nextCell.getAttribute('contenteditable') === 'true') {
                        nextCell.focus(); // Focus on the next editable cell
                        // Select all the content in the next cell
                        document.execCommand('selectAll', false, null);
                    }
                } else {
                    if (refresh !== null) {
                        autoRefreshInterval = setInterval(() => fetchAndUpdateContent(globalserie), 2000);
                        console.log('Rafraîchissement rétabli');
                    }
                    fetchAndUpdateContent(globalserie); 
                }
            }

               
            }
        });

        // Event to handle input during editing
        cell.addEventListener('input', function () {
    let newValue = cell.textContent.trim();  // Récupère la valeur actuelle pendant la saisie

    // Vérifie que la valeur est un nombre valide
    if (!isNaN(newValue) && newValue !== "") {
        let parsedValue = parseFloat(newValue);

        // Si la valeur est un entier supérieur à 10, diviser par 10
        if (parsedValue > 10 && Number.isInteger(parsedValue)) {
            newValue = (parsedValue / 10).toString();
        }
        
        // Si la valeur est <= 10, limiter à deux décimales
        else if (parsedValue <= 10) {
            if (newValue.includes('.')) {
                const [integerPart, decimalPart] = newValue.split('.');
                newValue = decimalPart.length > 2
                    ? `${integerPart}.${decimalPart.slice(0, 2)}`
                    : newValue;
            }
        }

        // Met à jour le contenu de la cellule avec la valeur ajustée
        cell.textContent = newValue;

        // Déplace le curseur à la fin de la saisie
        const range = document.createRange();
        const sel = window.getSelection();
        range.setStart(cell.childNodes[0], newValue.length);
        range.collapse(true);
        sel.removeAllRanges();
        sel.addRange(range);
    }
});


        // Event to handle when the user leaves the cell (blur)
        cell.addEventListener('blur', function () {
            
        });
    });
}





function insertNoteInDatabase(serie, concu, judge, wave, note) {
    // Créer les données à envoyer
    const data = {
        serie: serie,
        concu: concu,
        judge: judge,
        wave: wave,
        note: note
    };
    //console.log("Données envoyées pour l'insertion:", data);

    // Envoyer la requête au serveur pour insérer la nouvelle note dans la base de données
    fetch('insert_note.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data)
    })
    .then(response => {
        if (!response.ok) {
            return response.text().then(text => { throw new Error(text); });
        }
        return response.json();
    })
    .then(result => {
        if (result.status === 'success') {
            console.log('Note insérée avec succès.');
        } else {
            console.error('Erreur lors de l\'insertion de la note:', result.message);
            alert("Erreur lors de l'insertion de la note.");
        }
    })
    .catch(error => {
        console.error('Erreur:', error.message);
        alert("Erreur lors de l'insertion : " + error.message);
    });
}



// Function to update the note in the database via fetch (AJAX)
function updateNoteInDatabase(serie, concu, judge, wave, note) {
    // Créer les données à envoyer
    
    const data = {
        serie: serie,
        concu: concu,
        judge: judge,
        wave: wave,
        note: note
    };
 //console.log("Données envoyées:", data);
    // Envoyer la requête au serveur pour mettre à jour la note dans la base de données
    fetch('update_note.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data)
    })
    .then(response => {
        // Lire la réponse et vérifier si elle est en JSON
        if (!response.ok) {
            return response.text().then(text => { throw new Error(text); });
        }
        return response.json();
        
    })
    
    .then(result => {
        console.log(result);
        if (result.success === true) {
            console.log('Note mise à jour avec succès.');
        } else {
            console.error('Erreur lors de la mise à jour de la note:', result.message);
            //alert("Erreur lors de la mise à jour de la note.");
        }
    })
    .catch(error => {
        console.error('Erreur:', error.message);
        //alert("Erreur lors de la mise à jour : " + error.message);
    });
}


// Function to update the note in the database via fetch (AJAX)
function updatebloque(serie) {
    // Créer les données à envoyer
    const data = {
        serie: serie
    };
    console.log(serie);
 //console.log("Données envoyées:", data);
    // Envoyer la requête au serveur pour mettre à jour la note dans la base de données
    fetch('update_bloque.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data)
    })
    
    .catch(error => {
        console.error('Erreur:', error.message);
        //alert("Erreur lors de la mise à jour : " + error.message);
    });
}

function updateScores(serie,ligne,rank, total) {
    // Créer les données à envoyer
    const data = {
        serie: serie,
        ligne: ligne,
        rank: rank,
        total: total
    };
 
 //console.log("Données envoyées:", data);
    // Envoyer la requête au serveur pour mettre à jour la note dans la base de données
    fetch('update_score_total.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data)
    })
    
   
    .catch(error => {
        console.error('Erreur:', error.message);
        //alert("Erreur lors de la mise à jour : " + error.message);
    });
}

function bindContextMenu() {
        const averageCells = document.querySelectorAll('.average-cell');
        averageCells.forEach(cell => {
            cell.addEventListener('click', (event) => {
                event.preventDefault();
                showContextMenu(event, cell);
            });
        });
    }

function showContextMenu(event, cell) {
    const contextMenu = document.getElementById('context-menu');
    const x = event.pageX;
    const y = event.pageY;

    contextMenu.style.left = `${x}px`;
    contextMenu.style.top = `${y}px`;
    contextMenu.style.display = 'block';

    const serie = cell.getAttribute('data-serie');
    const concu = cell.getAttribute('data-concu');
    const wave = cell.getAttribute('data-wave');

    // Remove any existing event listeners to prevent duplicate execution
    removeExistingListeners();

    // Add new event listeners
    document.getElementById('cancel').addEventListener('click', hideContextMenu);
    document.getElementById('remove-interference').addEventListener('click', () => updateDatabase('REMOVE INTERFERENCE', serie, concu, wave));
    document.getElementById('interference-in').addEventListener('click', () => updateDatabase('INTERFERENCE IN', serie, concu, wave));
    document.getElementById('priority-in').addEventListener('click', () => updateDatabase('PRIORITY IN', serie, concu, wave));
}

function hideContextMenu() {
    const contextMenu = document.getElementById('context-menu');
    contextMenu.style.display = 'none';
}

// Function to remove existing event listeners to prevent duplicate actions
function removeExistingListeners() {
    const cancelBtn = document.getElementById('cancel');
    const removeInterferenceBtn = document.getElementById('remove-interference');
    const interferenceInBtn = document.getElementById('interference-in');
    const priorityInBtn = document.getElementById('priority-in');

    cancelBtn.replaceWith(cancelBtn.cloneNode(true));
    removeInterferenceBtn.replaceWith(removeInterferenceBtn.cloneNode(true));
    interferenceInBtn.replaceWith(interferenceInBtn.cloneNode(true));
    priorityInBtn.replaceWith(priorityInBtn.cloneNode(true));
}

function updateDatabase(action, serie, concu, wave) {
    const data = { action, serie, concu, wave };

    fetch('update_action.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data),
    })
    .then(response => {
        if (!response.ok) throw new Error(response.statusText);
        return response.json();
    })
    .then(result => {
        if (result.status === 'success') {
            console.log(`${action} updated successfully ${serie}.`);
        } else {
            console.error('Error:', result.message);
        }
    })
    .catch(error => console.error('Error:', error));
    fetchAndUpdateContent(serie);
    hideContextMenu(); // Hide the menu after an action is taken
    
}

