
document.addEventListener('DOMContentLoaded', function() {
  const scoreboard = document.getElementById('scoreboard');
  // Define an array of background colors
  const bgColors = ['danger', 'warning', 'primary', 'light', 'dark', 'info', 'light', 'dark'];
  var timer;
// Récupération de la valeur passée via l'URL
const urlParams = new URLSearchParams(window.location.search);
const heatNumber = urlParams.get('heatNumber');
console.log(heatNumber);
const compid = new URL(document.getElementById('main-js').src).searchParams.get('compid');
    
    // Function to create the scores display
function createScoresDisplay(scores) {
  let score1 = "-" , score2 = "-";
  let redScoresFound = 0;
  let waveScoresHtml = '<div class="wave-scores-container align-items-left">';

  scores.forEach((scoreObj, index) => {
      // Vérifie si la valeur est null et passe à l'itération suivante si c'est le cas
  if (scoreObj.value === null) return;

    waveScoresHtml += `
      <div class="wave-score-pair align-items-left mr-2"  style="padding-right:10px;">
        
        <div class="scores" align="center" style="color: ${scoreObj.color};"><span>&#124 </span>${scoreObj.value == 11 ? '<span class="blinking">▲</span>' : scoreObj.value == 0 ? 'X' : scoreObj.value == 21 ? '<span class="waiting-for-score">⏳</span>' : scoreObj.value}</div>
      </div>`;
    if (scoreObj.color === 'red' && redScoresFound < 2) {
      redScoresFound++;
      if (redScoresFound === 1) score1 = scoreObj.value;
      else if (redScoresFound === 2) score2 = scoreObj.value;
    }
  });

  waveScoresHtml += '</div>';

  // Return the HTML string and the first two red scores found
  return { waveScoresHtml, score1, score2 };
}
scoreboard.innerHTML = '';
   
    const col = document.createElement('div');
    // Use Bootstrap's 'col' class for a full-width column, ensuring vertical layout
    col.className = 'col';
    
      
     // Create a unique ID for the details div and button 

    col.innerHTML = `

     <div class="heatcompetitor">
    <div class="align-items-center logobgcolor">
        <div class="align-items-center"><img class="responsive-logo"  src="medias/logoFRMS.png"></div>
    </div>  
    <div class="align-items-center">
        <div class="title" style="white-space: normal; text-align:center;" id="categ"></div>    
    </div>
    <div class="headers align-items-center">
        <div class=" text-center" style="text-align:center;">Round</div>
        <div class="name text-center" style="text-align:center;" id="round"></div>
    </div>
    <div class="headers align-items-center" >
        <div class="text-center" style="text-align:center;">Heat</div>
        <div class="name text-center" style="text-align:center;" id="heat"></div>
    </div>
    
</div>

 

<div id="competitors">
<div id="row-1" class="competitor-row">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
            
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
            <div class="scores-need" style="white-space: normal; "></div>
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>
  <!-- Ligne 2 -->
  <div id="row-2" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
        
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
            <div class="scores-need" style="white-space: normal; "></div>
         </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>

 <div id="row-3" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
         
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
            <div class="scores-need" style="white-space: normal; "></div>
          
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>

 <div id="row-4" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
          
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
          <div class="scores-need" style="white-space: normal; "></div>
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>

 <div id="row-5" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
           
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
          <div class="scores-need" style="white-space: normal; "></div>
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>


</div>




`;
    scoreboard.appendChild(col);//entete
     
     
    
 
 function refreshData() { 
   
     clearInterval(timer);
     console.log(`getEventDate.php?compid=${encodeURIComponent(compid)}`);
     // récupération du timer.
   fetch(`getEventDate.php?compid=${encodeURIComponent(compid)}`) // Remplacez 'script.php' par l'URL de votre script PHP
  .then(response => response.json()) // Transforme la réponse en JSON
  .then(data => {

    
    //var countDownDate = new Date("Jan 5, 2030 15:37:25").getTime();
    var countDownDate = new Date(data.chrono).getTime();
    console.log(data.chrono);
    console.log("countDownDate :", countDownDate);
  
  
    
    
    
    
    
    // Set the date we're counting down to
//var countDownDate = new Date("Jan 5, 2030 15:37:25").getTime();

// Update the count down every 1 second
timer = setInterval(function() {

  // Get today's date and time
  var now = new Date().getTime();

  // Find the distance between now and the count down date
  var distance = countDownDate - now;
//console.log(distance);
  // Time calculations for days, hours, minutes and seconds
  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
  var seconds = Math.floor((distance % (1000 * 60)) / 1000);

  // Display the result in the element with id="chrono"
  //document.getElementById("chrono").innerHTML =  String(minutes).padStart(2, '0') + ":" + String(seconds).padStart(2, '0');


  // If the count down is finished, write some text
  //if (distance < 0) {
//    clearInterval(timer);
//    document.getElementById("chrono").innerHTML = "00:00";
//  }
}, 1000);
  

   
})    
  .catch(error => console.error("Erreur lors de la récupération des données:", error));  
     
   
     
     
    function updateCompetitors(competitors) {
  // Parcourir tous les compétiteurs reçus
  competitors.forEach((competitor, index) => {
    const rowId = `row-${index + 1}`; // Construire l'identifiant de la ligne
    const row = document.getElementById(rowId); // Obtenir la ligne par son identifiant
      document.getElementById("categ").innerHTML = competitor.categ; 
      document.getElementById("round").innerHTML = competitor.round; 
      document.getElementById("heat").innerHTML = competitor.heat; 
      
    // Si la ligne existe, mettre à jour son contenu
    if (row) {
      // Mettre à jour les informations du compétiteur dans 'row'
        
      row.querySelector('.name').textContent = competitor.name;
      row.querySelector('.club').textContent = competitor.club;
      row.querySelector('.score').textContent = competitor.score;
      row.querySelector('.scores-need').textContent = competitor.needs;
        row.querySelector('.scores-need').classList.add(`color-${competitor.competitor_id}`);
        row.style.display = 'block';
        const scores = createScoresDisplay(competitor.scores).waveScoresHtml;
      row.querySelector('.ws-container').innerHTML = createScoresDisplay(competitor.scores).waveScoresHtml;
        row.querySelector('.ws-container1').innerHTML = row.querySelector('.ws-container').innerHTML;
      const imgElement = row.querySelector('.competitor-img');
      imgElement.src = `photos/${competitor.photo}`; // Utilisez la bonne extension de fichier
      imgElement.alt = `Photo de ${competitor.name}`;
        imgElement.className=`competitor-img color-${competitor.competitor_id}`;
        
        
        
        // Utiliser 'onerror' pour définir une image par défaut en cas d'erreur de chargement de l'image
  //imgElement.onerror = function() {
//    this.onerror = null; // Éviter les boucles infinies en cas d'erreur sur l'image par défaut
//    this.src = 'photos/anonyme.png'; // Assurez-vous que le chemin de l'image par défaut est correct
//  };
        const flagElement = row.querySelector('.competitor-flag');
      flagElement.src = `${competitor.flag.toLowerCase()}`; // Utilisez la bonne extension de fichier
      flagElement.alt = `flag ${competitor.club}`;
        
        // Utiliser 'onerror' pour définir une image par défaut en cas d'erreur de chargement de l'image
    //flagElement.onerror = function() {
    //this.onerror = null; // Éviter les boucles infinies en cas d'erreur sur l'image par défaut
    //this.src = 'flags/noflag.png'; // Assurez-vous que le chemin de l'image par défaut est correct
  //};
        
      // Continuez avec les autres champs nécessaires
    }
  });

  // Cacher les lignes excédentaires si le nombre de compétiteurs est inférieur à 5
  for (let i = competitors.length + 1; i <= 5; i++) {
    const row = document.getElementById(`row-${i}`);
    if (row) {
      row.style.display = 'none';
    }
  }
}
 
     
    
 
 
    // Fetch data from the PHP script
  fetch(`getDataHisto.php?compid=${encodeURIComponent(compid)}&heatNumber=`+ heatNumber)
    .then(response => response.json())
    .then(competitors => {   
    
  updateCompetitors(competitors);
      
      competitors.forEach((comp, index) => {
    const col = document.createElement('div');
    // Use Bootstrap's 'col' class for a full-width column, ensuring vertical layout
    col.className = 'col';
    //const bgColor = bgColors[index % bgColors.length];
    const scores1 = createScoresDisplay(comp.scores); 
      
     // Create a unique ID for the details div and button
   
    //col.innerHTML = `<div class="wave-scores-container hidden-mobile align-items-left" style="width:100%;">${scores1.waveScoresHtml}</div>`;

          
          
   //<div class="scores">${scores1.waveScoresHtml}</div>   
    //scoreboard.appendChild(col);
      
});
})
 

    .catch(error => console.error('Error fetching data:', error));
}
    
    
    
// Exécutez immédiatement la fonction au chargement du script
refreshData();
    
// Planifie refreshData pour s'exécuter toutes les 30 secondes
//setInterval(refreshData, 10000);
    
});