<?php
// DEBUG DURCI (temporaire)
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require 'config_livescores2024.php';


// --- Entrées ---
$mode         = isset($_GET['mode']) ? $_GET['mode'] : 'live';
$isautovalide = isset($_GET['autovalide']) ? (int)$_GET['autovalide'] : 0;

// JSON body
$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);

// Sécurité : on valide le JSON
if (!is_array($data) || empty($data)) {
    echo json_encode(['success' => false, 'message' => 'No valid JSON payload']);
    exit;
}

try {
    $conn->begin_transaction();

    // (Optionnel) Nettoyage si mode live
    if ($mode === 'live') {
        // Exemple : si tu veux vraiment tronquer :
        // $conn->query("TRUNCATE live_options");
        // $conn->query("TRUNCATE waves");
        // $conn->query("TRUNCATE competitors");
    }

    // Prépare tes statements UNE SEULE FOIS (bien plus rapide et évite 500 aléatoires)
    // 1) live_options: soit UPDATE la ligne "globale" (sans WHERE volontaire), ou mieux ajoute un WHERE si tu as une PK.
    $psLiveOptionsUpd = $conn->prepare(
        "UPDATE live_options 
         SET compete = ?, categ = ?, `round` = ?, heat = ?"
        // -> si tu as une PK, ajoute: " WHERE id = ?"
    );

    // 2) heathisto upsert
    $psHeatHistoUpsert = $conn->prepare(
        "INSERT INTO heathisto (compete, categ, `round`, heat, chrono)
         VALUES (?, ?, ?, ?, ?)
         ON DUPLICATE KEY UPDATE
           categ = VALUES(categ),
           `round` = VALUES(`round`),
           heat = VALUES(heat),
           chrono = VALUES(chrono)"
    );

    // 3) competitors upsert
    $psCompetitorsUpsert = $conn->prepare(
        "INSERT INTO competitors
           (serie, Competitor_Id, name, score, needs, position, club, lycra, ligne)
         VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ? )
         ON DUPLICATE KEY UPDATE
           name = VALUES(name),
           score = VALUES(score),
           needs = VALUES(needs),
           position = VALUES(position),
           club = VALUES(club),
           lycra = VALUES(lycra),
           Competitor_Id = VALUES(Competitor_Id)"
    );

    // 4) live_waves delete + upsert
    $psWavesDelete = $conn->prepare(
        "DELETE FROM live_waves WHERE serie = ? AND competitor_id = ?"
    );
    $psWavesUpsert = $conn->prepare(
        "INSERT INTO live_waves (serie, `id`, competitor_id, value, color)
         VALUES (?, ?, ?, ?, ?)
         ON DUPLICATE KEY UPDATE
           `id` = VALUES(`id`),
           competitor_id = VALUES(competitor_id),
           value = VALUES(value),
           color = VALUES(color)"
    );

    $lastSerie = null;

    foreach ($data as $compet) {
        if (empty($compet)) { continue; }

        $serie        = (string)$compet['compete'];
        $categ        = (string)$compet['categ'];
        $round        = (string)$compet['round'];  // backtick côté SQL
        $heat         = (string)$compet['heat'];
        $chrono       = isset($compet['chrono']) ? (string)$compet['chrono'] : null;
        $chrono_state = isset($compet['chrono_state']) ? (string)$compet['chrono_state'] : null;
        $chrono_rem   = isset($compet['chrono_remaining']) ? (string)$compet['chrono_remaining'] : null;

        $lastSerie = $serie;

        if ($mode === 'live') {
            // UPDATE live_options (ajoute un WHERE si tu as une seule ligne cible / PK)
            $psLiveOptionsUpd->bind_param('ssss', $serie, $categ, $round, $heat);
            $psLiveOptionsUpd->execute();
        }

        // heathisto upsert
        $psHeatHistoUpsert->bind_param('sssss', $serie, $categ, $round, $heat, $chrono);
        $psHeatHistoUpsert->execute();

        // Reset des waves pour ce competitor (on supprime tout pour recharger)
        if (!empty($compet['competitors']) && is_array($compet['competitors'])) {
            foreach ($compet['competitors'] as $compRow) {
                $competitorId = (int)$compRow['Competitor_Id'];
                $name   = (string)$compRow['name'];
                $score  = isset($compRow['score']) ? (float)str_replace(',', '.', $compRow['score']) : 0.0;
                $needs  = isset($compRow['needs']) ? (string)$compRow['needs'] : null;
                $pos    = isset($compRow['position']) ? (string)$compRow['position'] : null;
                $club   = isset($compRow['club']) ? (string)$compRow['club'] : null;
                $lycra  = isset($compRow['lycra']) ? (string)$compRow['lycra'] : null;
                $ligne  = isset($compRow['ligne']) ? (string)$compRow['ligne'] : null;

                // competitors upsert
                $psCompetitorsUpsert->bind_param('i ss d s s s s s',
                    // espaces pour lisibilité; types réels ci-dessous
                );

                // ⚠ bind_param types doivent être sans espaces :
                // serie(s), Competitor_Id(i), name(s), score(d), needs(s), position(s), club(s), lycra(s), ligne(s)
                $psCompetitorsUpsert->bind_param('sisssisss',
                    $serie, $competitorId, $name, $score, $needs, $pos, $club, $lycra, $ligne
                );
                $psCompetitorsUpsert->execute();

                // delete waves existants
                $psWavesDelete->bind_param('si', $serie, $competitorId);
                $psWavesDelete->execute();

                // upsert moyennes
                if (!empty($compRow['moyennes']) && is_array($compRow['moyennes'])) {
                    foreach ($compRow['moyennes'] as $sc) {
                        $waveId    = (int)$sc['id'];
                        $waveVal   = (float)str_replace(',', '.', $sc['value']);
                        $waveColor = (string)$sc['color'];
                        $psWavesUpsert->bind_param('siids', $serie, $waveId, $competitorId, $waveVal, $waveColor);
                        $psWavesUpsert->execute();
                    }
                }
            }
        }
    }

    // Auto-valide ?
    if ($isautovalide === 1 && $lastSerie !== null) {
        $psAuto = $conn->prepare(
            "INSERT INTO moyennes_valides (serie, concu, vague, valide)
             SELECT DISTINCT serie, concu, vague, ?
             FROM resu
             WHERE resu.serie = ?
             ON DUPLICATE KEY UPDATE valide = VALUES(valide)"
        );
        $psAuto->bind_param('is', $isautovalide, $lastSerie);
        $psAuto->execute();
        $psAuto->close();
    }

    // Commit
    $conn->commit();

    echo json_encode(['success' => true, 'message' => 'Data saved successfully', 'serie' => $lastSerie]);

} catch (Throwable $e) {
    // Rollback + renvoi JSON clair
    if ($conn->errno === 0) {
        // si pas d’erreur mysqli active, on tente quand même
        $conn->rollback();
    }
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} finally {
    // Fermetures sûres
    if (isset($psLiveOptionsUpd))     { $psLiveOptionsUpd->close(); }
    if (isset($psHeatHistoUpsert))    { $psHeatHistoUpsert->close(); }
    if (isset($psCompetitorsUpsert))  { $psCompetitorsUpsert->close(); }
    if (isset($psWavesDelete))        { $psWavesDelete->close(); }
    if (isset($psWavesUpsert))        { $psWavesUpsert->close(); }
    $conn->close();
}

?>