<?php


// Connexion à la base de données
require '../config_livescores2024.php';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erreur de connexion à la base de données : " . $e->getMessage());
}

if (isset($_FILES['image']) && isset($_POST['name'])) {
    $targetDir = "../photos/";  // Le dossier cible pour les uploads
    $competitor = $_POST['name'];  // Le nom sélectionné dans la liste déroulante
    $photoName = basename($_FILES["image"]["name"]);
    $targetFile = $targetDir . $photoName;

    // Déplacer le fichier uploadé dans le dossier cible
    if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile)) {
        // Image uploadée avec succès, maintenant insérons les données dans la base de données
        
        // Requête SQL pour insérer ou mettre à jour la photo
        $sql = "INSERT INTO live_photos (competitor, photo) VALUES (:competitor, :photo)
                ON DUPLICATE KEY UPDATE photo = :photo";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':competitor', $competitor);
        $stmt->bindParam(':photo', $targetFile);

        if ($stmt->execute()) {
            echo "Le fichier " . htmlspecialchars($photoName) . " a été uploadé et les informations ont été insérées dans la base de données.";
        } else {
            echo "Erreur lors de l'insertion dans la base de données.";
        }
    } else {
        echo "Erreur lors de l'upload.";
    }
} else {
    echo "Données manquantes pour l'upload.";
}
?>

