<?php
//include_once 'auth.php';

// Connexion à la base de données MySQL
require 'config_livescores2024.php';


// Fonction pour générer un score aléatoire (note)
function genererNote() {
    return mt_rand(10, 100) / 10; // Générer un score entre 1.0 et 10.0
}

// Entrée : numéro de série
$serie = 1; // Remplacez par la série en question

// Récupérer les concurrents de la table 'bloque' pour la série donnée
$queryConcurrents = "SELECT * FROM bloque";
$stmtConcurrents = $conn->prepare($queryConcurrents);
//$stmtConcurrents->bind_param('i', $serie);
$stmtConcurrents->execute();
$resultConcurrents = $stmtConcurrents->get_result();


$concurrents = [];
while ($row = $resultConcurrents->fetch_assoc()) {
    $concurrents[] = $row['concu']; // Stocker les concurrents dans un tableau
    $serie = $row['serie'];
}

$queryConcurrents = "DELETE FROM resu where serie in (select serie from bloque)";
$stmtConcurrents = $conn->prepare($queryConcurrents);
//$stmtConcurrents->bind_param('i', $serie);
$stmtConcurrents->execute();


// Juges de 1 à 4
$juges = [1, 2, 3, 4];

// Vagues de 1 à 10
//$vagues = range(1, 10);

// Insérer les données fictives dans la table 'resu'
$queryInsert = "INSERT INTO resu (serie, concu, vague, juge, note) VALUES (?, ?, ?, ?, ?)";
$stmtInsert = $conn->prepare($queryInsert);

foreach ($concurrents as $concu) {
    $vagues = range(1, rand(1, 10));
    foreach ($vagues as $vague) {
        foreach ($juges as $juge) {
            $note = genererNote(); // Générer une note aléatoire
            $stmtInsert->bind_param('iiiii', $serie, $concu, $vague, $juge, $note);
            $stmtInsert->execute();
        }
        //sleep(1);
    }
}

// Fermer les requêtes et la connexion
$stmtConcurrents->close();
$stmtInsert->close();
$conn->close();

echo "Données fictives insérées avec succès dans la table 'resu'.";
?>
