<?php
header('Access-Control-Allow-Origin: *'); // Allow all domains. Adjust if you want to be more restrictive
//header('Content-Type: application/json'); // Set appropriate content type for JSON data
$compid = $_GET['compid'];
require 'config_livescores2024.php';

// Récupération des données
$category = $_GET['category'];
$round = $_GET['round'];

$sql = "
SELECT w.*,IFNULL(p.photo,'../photos/anonyme.png') AS photo,if(ISNULL(cn.code2l),'flags/noflag.png', cn.code2l) AS flag from
(SELECT h1.valide, h1.categ AS category, h1.serie, h1.round, h1.heat, h1.ligne, h1.lycra, h1.srcrank, h1.srcheat, 
               IF(ISNULL(h2.concu), h1.concu, h2.concu) AS concu, 
               IF(ISNULL(h2.concu), h1.concname, h2.concname) AS nom, 
               IF(ISNULL(h2.concu), h1.conclub, h2.conclub) AS club,
               h1.rank, h1.total
        FROM (SELECT heats.*,concu.nom AS concname, concu.club AS conclub FROM heats LEFT JOIN concu ON heats.concu=concu.numpart ) h1
        LEFT JOIN (SELECT heats.*,concu.nom AS concname, concu.club AS conclub FROM heats LEFT JOIN concu ON heats.concu=concu.numpart ) h2 ON h2.heat = h1.srcheat AND h2.rank = h1.srcrank AND h1.categ = h2.categ AND h2.valide=1
    
        WHERE h1.categ= ? AND h1.ROUND= ? 
        ) w
        LEFT JOIN live_photos p ON p.competitor=w.nom 
        LEFT JOIN compet co ON 1=1
        LEFT JOIN (SELECT noc as code3l,replace(flag,'../','') AS code2l  FROM flags
        
		union
		SELECT code3l,CONCAT('flags/',code2l,'.svg') AS code2l FROM country ) cn ON w.club=cn.code3l
        WHERE co.liveon=1 
        ORDER BY serie, ROUND,heat,`rank` is null, `rank`, ligne";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $category, $round);
$stmt->execute();
$result = $stmt->get_result();

// Transformation des données
$heatsData = [];
while ($row = $result->fetch_assoc()) {
    $serie = $row['serie'];
    $heat = $row['heat'];

    if (!isset($heatsData[$serie])) {
        $heatsData[$serie] = [];
    }

    if (!isset($heatsData[$serie][$heat])) {
        $heatsData[$serie][$heat] = [];
    }

    $heatsData[$serie][$heat][] = [
        'lycra' => $row['lycra'],
        'ligne' => $row['ligne'],
        'nom' => $row['nom'],
        'club' => $row['club'],
        'srcrank' => $row['srcrank'],
        'srcheat' => $row['srcheat'],
        'rank' => $row['rank'],
        'photo' => $row['photo'],
        'flag' => $row['flag'],
        'total' => $row['total']
        
    ];
}

$stmt->close();
$conn->close();

// Envoyer les données en JSON
echo json_encode($heatsData, JSON_PRETTY_PRINT);
?>