<?php
// Vérification que le formulaire a été soumis en méthode POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Récupération et conversion en entier des valeurs sélectionnées
    $left = intval($_POST['left']);
    $right = intval($_POST['right']);
    
    // Vérification que les deux valeurs sont différentes
    if ($left == $right) {
        die("Les valeurs sélectionnées doivent être différentes.");
    }
    
    // Configuration de la base de données
// Database configuration
require 'config_livescores2024.php';


    // Démarrage d'une transaction pour assurer l'intégrité de l'échange
    $conn->autocommit(FALSE);

    try {
        // 1. Mettre à jour la ligne de gauche en utilisant une valeur temporaire (6)
        $stmt1 = $conn->prepare("UPDATE heats SET ligne = 6 WHERE serie = 1000213 AND ligne = ?");
        $stmt1->bind_param("i", $left);
        if (!$stmt1->execute()) {
            throw new Exception("Erreur lors de la mise à jour de la valeur gauche : " . $stmt1->error);
        }

        // 2. Mettre à jour la ligne de droite pour prendre la valeur de gauche
        $stmt2 = $conn->prepare("UPDATE heats SET ligne = ? WHERE serie = 1000213 AND ligne = ?");
        $stmt2->bind_param("ii", $left, $right);
        if (!$stmt2->execute()) {
            throw new Exception("Erreur lors de la mise à jour de la valeur droite : " . $stmt2->error);
        }

        // 3. Mettre à jour la ligne temporaire (6) pour prendre la valeur de droite
        $stmt3 = $conn->prepare("UPDATE heats SET ligne = ? WHERE serie = 1000213 AND ligne = 6");
        $stmt3->bind_param("i", $right);
        if (!$stmt3->execute()) {
            throw new Exception("Erreur lors de la finalisation de l'échange : " . $stmt3->error);
        }

        // Validation de la transaction
        $conn->commit();
        echo "L'échange des valeurs a été effectué avec succès !";
    } catch (Exception $e) {
        // En cas d'erreur, annulation de la transaction
        $conn->rollback();
        echo "Échec de l'échange : " . $e->getMessage();
    }

    // Fermeture de la connexion
    $conn->close();
}
?>
