<?php
     header('Access-Control-Allow-Origin: *'); // Allow all domains. Adjust if you want to be more restrictive
    ?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <link rel="stylesheet" href="styles_controler.css"> 
    
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: aliceblue;
            padding: 20px;
        }

        .table-wrapper {
            width: 100%;
            overflow-x: auto;
            margin-bottom: 30px;
        }

        .concu-table {
            border-collapse: collapse;
            min-width: 1000px;
        }

        th, td {
            padding: 10px;
            text-align: center;
            border: 1px solid #ddd;
            min-width: 150px;
        }

        .back1 {
            background-color: gainsboro;
            color: darkgray;
        }

        tr:hover {}

        .hidden-table {
            display: none;
            margin-top: 10px;
            width: 100%;
            border-collapse: collapse;
        }

        .hidden-table th, .hidden-table td {
            padding: 8px;
            border: 1px solid #ddd;
        }

        .average {
            cursor: pointer;
            font-weight: bold;
            font-size: 100px;
            padding: 50px;
        }

        .average:hover {
            color: #c9302c;
        }

        .toggle-validated {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<h2>Scores Validator</h2>

<label class="switch">
    <input type="checkbox" class="toggle-validated" onchange="toggleValidScoresVisibility()">
    <span class="slider slider-bloque"></span>
</label>
<div id="concuTables"></div>

<script>
    let showValidScores = true; 
    let refreshInterval; 

    function loadConcuData() {
        const xhr = new XMLHttpRequest();
        xhr.open('GET', 'votre_fichier_php.php', true);
        xhr.onload = function () {
            if (xhr.status === 200) {
                const jsonData = JSON.parse(xhr.responseText);
                generateTables(jsonData);
                
            } else {
                console.error('Erreur de chargement des données.');
            }
        };
        xhr.onerror = function () {
            console.error('Erreur de connexion.');
        };
        xhr.send();
    }

    function groupByConcuAndVague(data) {
        const grouped = {};
        data.forEach(item => {
            if (!grouped[item.concu]) {
                grouped[item.concu] = {};
            }
            if (!grouped[item.concu][item.vague]) {
                grouped[item.concu][item.vague] = { moyenne: item.moyenne, valide: item.valide, notes: {}, name: item.name };
            }
            grouped[item.concu][item.vague].notes[item.juge] = item.note;
        });
        return grouped;
    }

    function buildReplayUrl(fileName) {
  // Construit le chemin complet de la vidéo
  const videoPath = fileName;
  const vlcHost = "localhost";
  const vlcPort = 8080;
  const baseUrl = `../../replay/play_video.php`;
  const command = "in_play";
  let url = `${baseUrl}?command=${command}&input=${encodeURIComponent(videoPath)}`;
  // S'assurer que l'URL ne contient pas d'entités HTML indésirables
  url = url.replace(/&amp;/g, "&");
        console.log(url)
  return url;
        
}

function playVideoClient(fileName) {
  // Construit le chemin complet de la vidéo
  const videoPath = fileName;
  const command = "in_play";

  // Au lieu d'appeler directement VLC, on appelle notre proxy (situé par exemple à la racine de votre serveur web)
  const proxyUrl = `../../replay/play_video.php?command=${encodeURIComponent(command)}&input=${encodeURIComponent(videoPath)}`;

  console.log("Lancement de la vidéo via proxy, URL :", fileName);

  fetch(proxyUrl, { mode: 'cors' })
    .then(response => {
      if (!response.ok) {
        throw new Error("Erreur HTTP " + response.status);
      }
      return response.text();
    })
    .then(data => console.log("Commande envoyée à VLC via proxy :", data))
    .catch(error => console.error("Erreur lors de l'envoi de la commande via proxy :", error));
}





    
    
    function generateTables(data) {
    const groupedData = groupByConcuAndVague(data);
    const tableContainer = document.getElementById('concuTables');
    tableContainer.innerHTML = ''; 

    for (let concu in groupedData) {
        const waves = Object.keys(groupedData[concu]);

        const concuTableWrapper = document.createElement('div');
        concuTableWrapper.classList.add('table-wrapper');

        const concuTable = document.createElement('table');
        concuTable.classList.add('concu-table');

        let tableHeader = `<tr class='coul-${concu}'><th>Concu #${concu}</th>`;
        let tableBody = `<tr><td>Moyenne</td>`;

        let hiddenTables = '';

        waves.forEach(vague => {
            const moyenne = groupedData[concu][vague].moyenne;
            const notes = groupedData[concu][vague].notes;
            const valide = groupedData[concu][vague].valide;
            // On suppose que la propriété "name" contient le nom du fichier vidéo
            const fileName = groupedData[concu][vague].name;
console.log(fileName);
            // Si la validation est activée et qu'on ne doit pas afficher ces scores, on passe
            if (valide === '1' && !showValidScores) {
                return;
            }

            tableHeader += `<th>Vague ${vague}</th>`;
            tableBody += `<td class="back${valide}"><span class="average" onclick="toggleNotes(${concu}, ${vague})">${moyenne}</span></td>`;

            let judgeHeaders = '';
            let judgeScores = '';

            Object.keys(notes).forEach(judge => {
                judgeHeaders += `<th>Juge ${judge}</th>`;
                judgeScores += `<td class="average">${notes[judge] || '-'}</td>`;
            });

            // Si fileName est défini (non nul), on ajoute un en-tête et un bouton REPLAY
            let replayHeader = '';
            let replayButtonCell = '';
            if (fileName) {
                replayHeader = '<th>Replay</th>';
                // On construit l'URL de replay en appelant buildReplayUrl()
                replayButtonCell = `<td><button class="replay-btn" onclick="playVideoClient('${fileName}')"><i class="fas fa-play"></i></button></td>`;

            }

            let hiddenTable = `
                <table class="hidden-table" id="hiddenTable-${concu}-${vague}">
                    <tr class='coul-${concu}'>${judgeHeaders}<th>Validate</th>${replayHeader}</tr>
                    <tr>${judgeScores}
                        <td>
                            <label class="switch">
                                <input type="checkbox" class="toggle_validated" onchange="avg_togglevalide(${concu}, ${vague}, this)" ${valide==='1' ? 'checked' : ''}>
                                <span class="slider slider-bloque"></span>
                            </label>
                        </td>
                        ${replayButtonCell}
                    </tr>
                </table>
            `;
            hiddenTables += hiddenTable;
        });

        tableHeader += '</tr>';
        tableBody += '</tr>';

        concuTable.innerHTML = tableHeader + tableBody;
        concuTableWrapper.appendChild(concuTable);
        tableContainer.appendChild(concuTableWrapper);
        tableContainer.innerHTML += hiddenTables;
    }
}


    function toggleNotes(concu, vague) {
        const hiddenTable = document.getElementById(`hiddenTable-${concu}-${vague}`);
        const isHidden = hiddenTable.style.display === 'none' || hiddenTable.style.display === '';

        const allTables = document.querySelectorAll('.hidden-table');
        allTables.forEach(table => {
            table.style.display = 'none';
        });

        if (isHidden) {
            hiddenTable.style.display = 'table';
            clearInterval(refreshInterval);
        } else {
            hiddenTable.style.display = 'none';
            startAutoRefresh();
        }
    }

    function avg_togglevalide(concu, vague, element) {
        const isChecked = element.checked;

        const data = {
            concu: concu,
            vague: vague,
            action: isChecked ? 1 : 0
        };

        fetch('update_valide.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(result => {
            if (result.success) {
                console.log(`validation réussie`);
                loadConcuData();
                startAutoRefresh();
            } else {
                console.error('Erreur lors de la mise à jour :', result.message);
            }
        })
        .catch(error => console.error('Erreur :', error));
    }

    function toggleValidScoresVisibility() {
        showValidScores = !showValidScores;
        loadConcuData();
    }

    function startAutoRefresh() {
        refreshInterval = setInterval(loadConcuData, 5000);
    }

    function stopAutoRefresh() {
        clearInterval(refreshInterval);
    }

    window.onload = function() {
        loadConcuData();
        startAutoRefresh();
    };
</script>

</body>
</html>
