<?php
include_once 'auth.php';

// Connexion à la base de données MySQL
require 'config_livescores2024.php';


if (isset($_POST['compet_category']) && isset($_POST['heatmodel'])) {
    
   
    list($disciplineid, $discipline) = explode('|', $_POST['compet_category']);
    $heatmodels = $_POST['heatmodel'];


    // Ici, vous pouvez ajouter le traitement pour générer les heats


// Variables
$serieCounter = intval("1000" . $disciplineid . "01");

//$discipline="BODYBOARD";
//$heatmodels="Huitieme";
$initialCounter = $serieCounter;
// Récupérer les compétiteurs dans l'ordre
$queryCompetitors = "SELECT * FROM concu WHERE categ = '" . $discipline . "' ORDER BY numpart ASC";
$resultCompetitors = $conn->query($queryCompetitors);

$competitors = [];
if ($resultCompetitors->num_rows > 0) {
    while ($row = $resultCompetitors->fetch_assoc()) {
        $competitors[] = $row;
    }
}

// Récupérer les modèles de séries pour le heatmodel spécifique
$queryHeatsModel = "SELECT h.*,t.tableau FROM heatmodel h LEFT JOIN tableau t ON h.heats=t.nbre
WHERE heatmodel='" . $heatmodels . "' ORDER BY seq";
$resultHeatsModel = $conn->query($queryHeatsModel);

$heatsModel = [];
if ($resultHeatsModel->num_rows > 0) {
    while ($row = $resultHeatsModel->fetch_assoc()) {
        $heatsModel[] = $row;
    }
}

// Supprimer les anciennes entrées dans la table 'heats' pour cette catégorie
$stmt = $conn->prepare("DELETE FROM heats WHERE categ = ?");
$stmt->bind_param('s', $discipline);
$stmt->execute();
$stmt->close();
$stmt = $conn->prepare("DELETE FROM programme WHERE categ = ?");
$stmt->bind_param('s', $discipline);
$stmt->execute();
$stmt->close();
$heatcounter=1;
// Vérification que le tableau contient bien des données
if (count($heatsModel) > 0) {
    foreach ($heatsModel as $heatModel) {
        // Ne traiter que les tours avec `start` et `end` définis
        if ($heatModel['start'] > 0 && $heatModel['end'] > 0) {
            // Extraire la répartition du champ 'tableau'
            $repartition = explode(',', $heatModel['tableau']);

            // Calcul du nombre de compétiteurs à affecter pour ce tour (de start à end)
            $start = $heatModel['start'] - 1;  // start est 1-based, donc on ajuste pour un array 0-based
            $end = $heatModel['end'];
            $competitorsSlice = array_slice($competitors, $start, $end - $start);

            // Si le nombre de compétiteurs dépasse la taille de la répartition, étendre la répartition
            $requiredCompetitorsCount = count($competitorsSlice);
            $repartitionCount = count($repartition);

            if ($requiredCompetitorsCount > $repartitionCount) {
                // Ajouter l'inverse de la répartition après la répartition initiale
                $repartition = array_merge($repartition, array_reverse($repartition));

                // Si nécessaire, continuer à étendre la répartition jusqu'à avoir assez de place pour tous les compétiteurs
                while (count($repartition) < $requiredCompetitorsCount) {
                    $repartition = array_merge($repartition, array_reverse($repartition));
                }

                // Trimmer la répartition pour qu'elle corresponde exactement au nombre de compétiteurs requis
                $repartition = array_slice($repartition, 0, $requiredCompetitorsCount);
            }

            // Affecter les compétiteurs aux séries selon la répartition
            $assignedHeats = [];
            foreach ($repartition as $index => $heat) {
                if (!isset($assignedHeats[$heat])) {
                    $assignedHeats[$heat] = [];
                }
                // Assigner le compétiteur selon l'ordre du modèle de répartition
                if (isset($competitorsSlice[$index])) {
                    $assignedHeats[$heat][] = $competitorsSlice[$index];
                }
            }

            // Trier le tableau par ordre de série (clé du tableau)
            ksort($assignedHeats);

            // Préparer l'insertion dans la table 'heats'
            $insertStmt = $conn->prepare("INSERT INTO heats (categ, serie, round, heat, ligne, concu, nom, club, srcheat, srcrank) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

            
            // Boucle pour insérer les compétiteurs dans la table 'heats'
            foreach ($assignedHeats as $heat => $competitorsInHeat) {
                $round = $heatModel['tour']; // Utilisation du champ 'tour' comme round
                foreach ($competitorsInHeat as $line => $competitor) {
                    $categ = $competitor['categ'];
                    $serie = $serieCounter;
                    $roundName = $round;
                    $ligne = $line + 1;
                    $concu = $competitor['numpart'];
                    $nom = $competitor['nom'];
                    $club = $competitor['club'];
                    $nullValue = null; // Pour srcheat et srcrank non définis

                    // Lier les variables à la requête
                    $insertStmt->bind_param('sisiiissii', $categ, $serie, $roundName, $heatcounter, $ligne, $concu, $nom, $club, $nullValue, $nullValue);
                    $insertStmt->execute();
                }
                $serieCounter++;
                $heatcounter++;
            }
            $insertStmt->close();
        }
    }
}
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Définir le paramètre que vous souhaitez passer
$heatmodel = $heatmodels;
//echo $heatmodels;
    
// Capturer la sortie de heatmodels.php
ob_start();
include 'heatmodels.php';
$json_data = ob_get_clean();

// Décoder le JSON
$progressionHeats = json_decode($json_data, true);
if ($progressionHeats === null) {
    die("Erreur lors du décodage des données JSON");
}

// Préparation de la requête d'insertion
$insertStmt = $conn->prepare("
    INSERT INTO heats 
    (categ, serie, round, heat, ligne, concu, nom, club, srcheat, srcrank) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

if ($insertStmt === false) {
    die("Erreur de préparation de la requête : " . $conn->error);
}
$serieCounter--;
$serietemp=null;
// Boucle pour insérer les informations dans la table heats
foreach ($progressionHeats as $heatData) {
    // Les informations sont mappées entre le JSON et les colonnes de la table
    $dest = $heatData['Dest'];            // heat dans la table heats
    $destlig = $heatData['Destlig'];      // ligne dans la table heats
    $srcheat = $heatData['Heat'];         // srcheat dans la table heats
    $srcrank = $heatData['Ligne'];        // srcrank dans la table heats
    $tour = $heatData['tour'];
    // Variables pour l'insertion
    $nullValue = null;   // Valeurs nulles pour concu, nom, club (si nécessaire)
    $categ = $discipline;       // Exemple de catégorie, à remplacer par la vôtre
    //$tour = 'Huitieme';  // Nom du tour (ou autre, selon votre logique)
    if ($serietemp !== $dest) {
        // Incrémenter le compteur de série pour chaque insertion
        $serieCounter++;
        $serietemp=$dest;
    }
    $serie=$initialCounter-1+$heatData['Dest'];
    // Lier les paramètres à la requête préparée
    $insertStmt->bind_param('sisiiissii', 
        $categ,           // La catégorie
        $serie,    // La série courante (incrémentée)
        $tour,            // Le nom du tour
        $dest,            // Le numéro de heat
        $destlig,         // Le numéro de ligne
        $nullValue,       // concu (null ici, ajuster selon vos besoins)
        $nullValue,       // nom (null ici)
        $nullValue,       // club (null ici)
        $srcheat,         // Source heat
        $srcrank          // Rank source
    );

    // Exécution de la requête d'insertion
    $insertStmt->execute();

    
}

// Fermer la déclaration préparée et la connexion à la base de données

       // Préparer l'instruction SQL avec des placeholders (les ?)
// Étape 1 : Initialiser les variables utilisateur
$query1 = "SET @row_number1 := 0, @row_number2 := 0;";
$conn->query($query1); // Utiliser query() pour exécuter directement une commande SQL

// Étape 2 : Préparer l'instruction SQL UPDATE
$query2 = "
UPDATE heats t1
JOIN (
    SELECT t1.categ,t1.heat, t1.ligne, t2.srcrank, t2.srcheat, t1.row_num
    FROM (
        SELECT *, (@row_number1 := @row_number1 + 1) AS row_num
        FROM heats
        WHERE categ = ? AND NOT isNULL(srcrank)
        ORDER BY heat, ligne
    ) t1
    JOIN (
        SELECT *, (@row_number2 := @row_number2 + 1) AS row_num
        FROM heats
        WHERE categ = ? AND NOT isNULL(srcrank)
        ORDER BY heat, srcrank, srcheat
    ) t2
    ON t1.row_num = t2.row_num
) AS t2
ON t1.categ=t2.categ AND t1.heat = t2.heat AND t1.ligne = t2.ligne
SET t1.srcrank = t2.srcrank, t1.srcheat = t2.srcheat
";

// Étape 3 : Préparer le statement
$stmt = $conn->prepare($query2);

// Vérifier si la préparation a échoué
if ($stmt === false) {
    die("Erreur de préparation de la requête: " . $conn->error);
}

// Étape 4 : Lier les paramètres et exécuter

$stmt->bind_param('ss', $categ, $categ); // Lier les paramètres
$stmt->execute();

// Vérifier si l'exécution a échoué
if ($stmt === false) {
    die("Erreur d'exécution de la requête: " . $stmt->error);
}

// Étape 5 : Fermer le statement
$stmt->close();

    
    
    
    
    
$insertStmt->close();

echo "Lignes provisionnées avec succès à partir des données JSON !";
    
    // Préparer l'instruction SQL avec des placeholders (les ?)
$query = "INSERT INTO programme (categ, `round`, nbreheat, duree) 
          SELECT ?, tour, heats, ? FROM heatmodel WHERE heatmodel = ? order by id";

// Préparer le statement
$stmt = $conn->prepare($query);

// Vérifier si la préparation a échoué
if ($stmt === false) {
    die("Erreur de préparation de la requête: " . $stmt->error);
}

// Définir les valeurs des paramètres
//$categ = 'BODYBOARD';
$duree = 20;
//$heatmodel = 'huitieme';

// Lier les paramètres au statement préparé
$stmt->bind_param("sis", $categ, $duree, $heatmodels);

// Exécuter le statement
if ($stmt->execute()) {
    echo "Données insérées avec succès.";
} else {
    echo "Erreur lors de l'insertion des données: " . $stmt->error;
}

// Fermer le statement et la connexion
$stmt->close();
$conn->close();

    
    
} else {
    echo "Veuillez sélectionner une catégorie et un modèle de heat.";
}



?>
