<?php
include_once 'auth.php';

// Connexion à la base de données MySQL
require 'config_livescores2024.php';



$serie = isset($_GET['serie']) ? $_GET['serie'] : null;
//$serie=1000201;

if (isset($serie)) {
    // Si la variable est définie, utilise cette valeur dans la requête
    $query = "SELECT mv.valide as validated, ch.*, b.prio,lo.chrono AS targettime, lo.chrono_state,lo.chrono_remaining,  resu.vague, resu.juge, resu.note, 
         CONCAT('coul-', ch.ligne) AS coul 
FROM heats ch
LEFT JOIN concu c ON c.numpart=ch.concu
LEFT JOIN bloque b ON b.ligne=ch.ligne 
       	LEFT JOIN resu ON  resu.serie=ch.serie AND ch.concu=resu.concu
       	LEFT JOIN moyennes_valides mv ON mv.serie=resu.serie AND mv.concu=resu.concu AND mv.vague=resu.vague
        INNER JOIN live_options lo
        WHERE ((juge > 0 and note>0 and note <11) OR ISNULL(resu.serie)) AND ch.serie =?
UNION

SELECT mv.valide as validated,ch.*,b.prio,lo.chrono AS targettime, lo.chrono_state,lo.chrono_remaining,  resu.vague, resu.juge, resu.note, 
         CONCAT('coul-', ch.ligne) AS coul 
        from heats ch
        LEFT JOIN concu c ON c.numpart=ch.concu 
        LEFT JOIN bloque b ON b.ligne=ch.ligne 
       	LEFT JOIN resu ON resu.serie=ch.serie AND ch.concu=resu.concu
       	LEFT JOIN moyennes_valides mv ON mv.serie=resu.serie AND mv.concu=resu.concu AND mv.vague=resu.vague
        INNER JOIN live_options lo
        WHERE ((juge = 0 AND (note=11 or note =14))) AND ch.serie =?
        ORDER BY ligne,vague,juge
        
";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('ss', $serie, $serie); // Lie la variable à la requête SQL
} else {
    // Si la variable n'est pas définie, utilise la sous-requête
    $query = "SELECT ifnull(prios,'') AS prio,lo.chrono AS targettime, lo.chrono_state,lo.chrono_remaining, lo.categ, lo.`round`, heats.heat, b.nom,b.club, heats.ligne, heats.serie, b.concu, resu.vague, resu.juge, resu.note, 
         CONCAT('coul-', heats.ligne) AS coul 
        FROM heats 
        LEFT JOIN (SELECT prio AS prios, serie,ligne,concu,nom,club  FROM bloque LEFT JOIN concu ON concu.numpart=bloque.concu) b ON b.serie=heats.serie AND b.ligne=heats.ligne
       	LEFT JOIN resu ON  resu.serie=heats.serie AND heats.concu=resu.concu
        INNER JOIN live_options lo
        WHERE ((juge > 0 and note>0 and note <11) OR ISNULL(resu.serie)) AND heats.serie in (select serie from bloque) 
UNION

SELECT ifnull(prios,'') AS prio ,lo.chrono AS targettime, lo.chrono_state,lo.chrono_remaining, lo.categ, lo.`round`, heats.heat, b.nom,b.club, heats.ligne, resu.serie, b.concu, resu.vague, resu.juge, resu.note, 
         CONCAT('coul-', heats.ligne) AS coul 
        FROM heats 
        LEFT JOIN (SELECT prio AS prios, serie,ligne,concu,nom,club  FROM bloque LEFT JOIN concu ON concu.numpart=bloque.concu) b ON b.serie=heats.serie AND b.ligne=heats.ligne
       	LEFT JOIN resu ON resu.serie=heats.serie AND heats.concu=resu.concu
        INNER JOIN live_options lo
        WHERE ((juge = 0 AND (note=11 or note =14))) AND heats.serie in (select serie from bloque) 
        ORDER BY ligne,juge,vague
        
";
    $stmt = $conn->prepare($query);
}


// Execute the query and fetch the data
$stmt->execute();
$result = $stmt->get_result();

$data = [];
$headerData = [];

// Prepare the data and header data
while ($row = $result->fetch_assoc()) {
   
    $data[] = [
        'targettime' => $row['targettime'],
        'chrono_state' => $row['chrono_state'],
        'chrono_remaining' => $row['chrono_remaining'],
        'division' => $row['categ'],
        'tour' => $row['round'],
        'heat' => $row['heat'],
        'nom' => $row['nom'],
        'club' => $row['club'],
        'ligne' => $row['ligne'],
        'serie' => $row['serie'],
        'concu' => $row['concu'],
        'vague' => $row['vague'],
        'juge' => $row['juge'],
        'note' => $row['note'],
        'prio' => $row['prio'],
        'valide' => $row['validated'],
        'coul' => $row['coul']
    ];

    // Only take one instance for the header information
    if (empty($headerData)) {
        $headerData = [
            'targettime' => $row['targettime'],
            'chrono_state' => $row['chrono_state'],
            'chrono_remaining' => $row['chrono_remaining'],
            'division' => $row['categ'],
            'tour' => $row['round'],
            'nbrjug' => $row['nbrjug'],
            'heat' => $row['heat']
        ];
    }
}

// Return the response as JSON
echo json_encode([
    'header' => $headerData,
    'data' => $data
]);
