<?php
include_once 'auth.php';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Importer CSV</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }

        .form-container {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            max-width: 400px;
            margin: auto;
            padding: 20px;
        }

        h2 {
            text-align: center;
            color: #333;
        }

        label {
            font-size: 16px;
            margin-bottom: 10px;
            display: block;
            color: #333;
        }

        input[type="file"], select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        input[type="submit"] {
            width: 100%;
            padding: 10px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #45a049;
        }

        .select-container {
            margin-bottom: 15px;
        }

    </style>
</head>
<body>

<div class="form-container">
    <h2>Importer un fichier CSV</h2>
    <form action="import_concu.php" method="post" enctype="multipart/form-data">
        <label for="compet_category">Sélectionner une catégorie :</label>
        <div class="select-container">
            <select name="compet_category" id="compet_category" required>
                <option value="" disabled selected>Choisir une catégorie</option>
                <?php
                // Connexion à la base de données
                require 'config_livescores2024.php';
                
                // Récupérer les catégories de la table 'compet_categories'
                $query = "SELECT id, category_name FROM compet_categories ORDER BY category_name ASC";
                $result = $conn->query($query);

                if ($result->num_rows > 0) {
                    // Afficher les options de la liste déroulante
                    while ($row = $result->fetch_assoc()) {
                        echo "<option value=\"" . $row['category_name'] . "\">" . $row['category_name'] . "</option>";
                    }
                } else {
                    echo "<option value=\"\">Aucune catégorie disponible</option>";
                }

                $conn->close();
                ?>
            </select>
        </div>

        <label for="file">Choisir un fichier CSV :</label>
        <input type="file" name="file" id="file" accept=".csv" required>

        <input type="submit" name="submit" value="Importer CSV">
    </form>
</div>

</body>
</html>
