<?php
include_once 'auth.php';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     
    <title>Généreration des Heats</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }

        .form-container {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            max-width: 400px;
            margin: auto;
            padding: 20px;
        }

        h2 {
            text-align: center;
            color: #333;
        }

        label {
            font-size: 16px;
            margin-bottom: 10px;
            display: block;
            color: #333;
        }

        select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        input[type="submit"] {
            width: 100%;
            padding: 10px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #45a049;
        }

    </style>
</head>
<body>
<?php
// Définir la page active
$page = 'genheat';

// Inclure l'en-tête
require_once 'header_menu.php';
?>
<div class="form-container">
    <h2>Générer les Heats</h2>
   <form action="generate_heats.php" method="post">
    <!-- Liste déroulante pour les catégories -->
    <label for="compet_category">Sélectionner une catégorie :</label>
    <select name="compet_category" id="compet_category" required>
        <option value="" disabled selected>Choisir une catégorie</option>
        <?php
        // Connexion à la base de données
        require 'config_livescores2024.php';

        // Récupérer les catégories de la table 'compet_categories'
        $queryCategories = "SELECT id, category_name FROM compet_categories ORDER BY category_name ASC";
        $resultCategories = $conn->query($queryCategories);

        if ($resultCategories->num_rows > 0) {
            // Afficher les options de la liste déroulante avec l'ID et le nom dans le value
            while ($row = $resultCategories->fetch_assoc()) {
                echo "<option value=\"" . $row['id'] . "|" . $row['category_name'] . "\">" . $row['category_name'] . "</option>";
            }
        } else {
            echo "<option value=\"\">Aucune catégorie disponible</option>";
        }
        ?>
    </select>

    <!-- Liste déroulante pour les modèles de heats -->
    <label for="heatmodel">Sélectionner un modèle de heat :</label>
    <select name="heatmodel" id="heatmodel" required>
        <option value="" disabled selected>Choisir un modèle de heat</option>
        <?php
        // Récupérer les modèles de heats de la table 'heatmodels'
        $queryHeatsModels = "SELECT distinct heatmodel FROM heatmodel ORDER BY heatmodel ASC";
        $resultHeatsModels = $conn->query($queryHeatsModels);

        if ($resultHeatsModels->num_rows > 0) {
            // Afficher les options de la liste déroulante
            while ($row = $resultHeatsModels->fetch_assoc()) {
                echo "<option value=\"" . $row['heatmodel'] . "\">" . $row['heatmodel'] . "</option>";
            }
        } else {
            echo "<option value=\"\">Aucun modèle de heat disponible</option>";
        }

        $conn->close();
        ?>
    </select>

    <!-- Bouton Submit -->
    <input type="submit" value="Générer les Heats">
</form>

</div>

</body>
</html>
