<?php
include_once 'auth.php';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Tableau de Bord</title>
    <!-- Lien vers Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Lien vers Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
    <!-- Votre fichier CSS personnalisé -->
    <link rel="stylesheet" href="../style.css">
</head>
<body>


<?php
// Définir la page active
$page = 'dashboard';

// Inclure les fichiers nécessaires
require_once 'config_livescores2024.php'; // Connexion à la base de données
require_once 'header_menu.php';

// Exécuter la requête SQL
$sql = "SELECT categ, COUNT(nom) AS count_nom FROM concu GROUP BY categ";
$result = $conn->query($sql);

// Préparer les données pour le graphique
$categories = [];
$count_noms = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row['categ'];
        $count_noms[] = $row['count_nom'];
    }
} else {
    echo "Aucune donnée trouvée.";
}
$totalHeats ='';
$consumedHeats ='';
$totalCompetitors='';
    $averageScore='';
$conn->close();

?>
<!-- Contenu principal -->
<div class="container my-5">
    
  
    <!-- Row pour les rubriques -->
    <div class="row">
        <!-- Rubrique 1: COMPETITORS -->
        <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="card h-100 text-white bg-primary shadow">
                <div class="card-body d-flex flex-column">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">COMPETITORS</h5>
                        <i class="fas fa-users fa-4x icon-transparent"></i>
                    </div>
                    <p class="card-text">Gestion des compétiteurs</p>
                    <a href="<?php echo BASE_URL; ?>ControlCenter/page_competitors.php" class="btn btn-light rounded-pill mt-auto">Accéder</a>
                </div>
            </div>
        </div>
        <!-- Rubrique 2: SCORES -->
        <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="card h-100 text-white bg-success shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">SCORES</h5>
                        <i class="fas fa-chart-line fa-4x icon-transparent"></i>
                    </div>
                    <p class="card-text">Gestion des notes</p>
                    <a href="<?php echo BASE_URL; ?>ControlCenter/controler.php" class="btn btn-light rounded-pill">Accéder</a>
                </div>
            </div>
        </div>
        <!-- Rubrique 3: HEATS -->
        <div class="col-12 col-md-6 col-lg-4 mb-4">
            <div class="card h-100 text-white bg-warning shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">HEATS</h5>
                        <i class="fas fa-table fa-4x icon-transparent"></i>
                    </div>
                    <p class="card-text">Gestion des séries</p>
                    <a href="<?php echo BASE_URL; ?>ControlCenter/config_heats_manager.php" class="btn btn-light rounded-pill">Accéder</a>
                </div>
            </div>
        </div>
        
        <!-- Rubrique 5: HEATS GEN -->
        <div class="col-12 col-md-6 col-lg-3 mb-4">
            <div class="card h-100 text-white bg-secondary shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">HEATS GEN</h5>
                        <i class="fas fa-random fa-4x icon-transparent"></i>
                    </div>
                    <p class="card-text">Génération des Séries</p>
                    <a href="<?php echo BASE_URL; ?>ControlCenter/config_generate_heats.php" target="_blank" class="btn btn-light rounded-pill">Accéder</a>
                </div>
            </div>
        </div>
        <!-- Rubrique 6: COMPETITORS IMPORT -->
        <div class="col-12 col-md-6 col-lg-3 mb-4">
            <div class="card h-100 text-white bg-info shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">COMPETITORS IMPORT</h5>
                        <i class="fas fa-file-import fa-4x icon-transparent"></i>
                    </div>
                    <p class="card-text">Importer les compétiteurs</p>
                    <a href="<?php echo BASE_URL; ?>ControlCenter/config_import_concu.php" class="btn btn-light rounded-pill">Accéder</a>
                </div>
            </div>
        </div>
        <!-- Rubrique 4: OPTIONS -->
        <div class="col-12 col-md-6 col-lg-3 mb-4">
            <div class="card h-100 text-white bg-danger shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">OPTIONS</h5>
                        <i class="fas fa-cogs fa-4x icon-transparent"></i>
                    </div>
                    <p class="card-text">Paramètres</p>
                    <a href="<?php echo BASE_URL; ?>ControlCenter/page_adminbo.php" class="btn btn-light rounded-pill">Accéder</a>
                </div>
            </div>
        </div>
        <!-- Rubrique 6: COMPETITORS IMPORT -->
        <div class="col-12 col-md-6 col-lg-3 mb-4">
            <div class="card h-100 text-white bg-info shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">JUDGES STATISTICS</h5>
                        <i class="fas fa-chart-pie fa-4x icon-transparent"></i>
                    </div>
                    <p class="card-text">Statistiques des juges</p>
                    <a href="<?php echo BASE_URL; ?>ControlCenter/stats.php" class="btn btn-light rounded-pill">Accéder</a>
                </div>
            </div>
        </div>
    </div>

</div>
    
    
<!-- Contenu statistiques -->
<div class="container my-5">
   
    <div class="row">
                        
        
    </div>
    
    
    
    
    <!-- Row pour les statistiques et graphiques -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Statistiques et Graphiques</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        
                        <div class="col-lg-4 col-md-12 mb-4">
                            <div class="card text-center">
                                    <div class="card-body">
                                        <i class="fas fa-clock fa-3x text-warning mb-3"></i>
                                        <h6 class="card-title">Heure Actuelle</h6>
                                        <h4 class="card-text" id="currentTime"></h4>
                                    </div>
                                </div>
                        </div>
        
        <!-- Sous-zone 6 : Progression du Temps -->
                        <div class="col-lg-4 col-md-12 mb-4">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title text-center">Progression du Temps</h6>
                                    <div class="chart-container">
                                        <canvas id="donutChart"></canvas>
                                        <div class="chart-text">
                                            
                                             
                                        </div>
                                        
                                       
                                    </div> 
                                    </div>
                                    
                                </div>
                            </div>
        <!-- Sous-zone 6 : Progression des Heats -->
                        <div class="col-lg-4 col-md-12 mb-4">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title text-center">Progression des Heats</h6>
                                    <div class="heat-progress">
                                        <!-- Les carrés seront générés ici -->
                                        
                                        <?php
                                        
                                        // Générer les carrés initiaux en PHP
                                        for ($i = 1; $i <= $totalHeats; $i++) {
                                            $class = 'heat-square';
                                            if ($i <= $consumedHeats) {
                                                $class .= ' consumed';
                                            }
                                            echo '<div class="' . $class . '" title="Heat ' . $i . ($i <= $consumedHeats ? ' (consommé)' : ' (restant)') . '"></div>';
                                            
                                        }
                                        
                                        ?>
                                      
                                    </div>
                                      <h4 class="card-text" id="consumedheats">sdsds</h4>
                                        
                                </div>
                            </div>
                        </div>
                        
                        
                        
                        
                        
                        
                    </div>
                    

                        
                        <!-- Ajoutez d'autres sous-zones si nécessaire -->
                    </div>
                </div>
            </div>
        </div>
    </div>


<!-- Vos scripts -->
<!-- Lien vers jQuery -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<!-- Lien vers Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- Lien vers Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<!-- Script pour afficher l'heure actuelle -->
<script>
function updateTime() {
    var now = new Date();
    var timeString = now.toLocaleTimeString('fr-FR', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
    document.getElementById('currentTime').textContent = timeString;
}
setInterval(updateTime, 1000);
updateTime(); // Appel initial
</script>

<!-- Script pour rafraîchir les données -->
<script>
function refreshdata() {
    console.log("Rafraîchissement des données...");
    fetch('get_dashboard_data.php')
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                console.error('Erreur:', data.error);
                return;
            }
            // Mettre à jour les variables
            var totalCompetitors = data.nbre_concu;
            var totalHeats = data.nbre_series;
            var consumedHeats = data.nbre_series_valide;
            var averageScore = data.best_score;
            var bestWave = data.best_wave;
            var temps_total = data.total_time; // Temps total en minutes
            var temps_consomme = data.Consumed_time; // Temps consommé en minutes

            // Calcul du pourcentage de temps consommé
            var pourcentage;
            if (temps_total > 0) {
                pourcentage = (temps_consomme / temps_total) * 100;
            } else {
                pourcentage = 0;
            }
            // S'assurer que le pourcentage est entre 0 et 100
            pourcentage = Math.min(100, Math.max(0, pourcentage));
            // Arrondir à 2 décimales
            var pourcentage_affiche = Math.round(pourcentage * 100) / 100;

            // Calcul du temps restant
            var temps_restant = temps_total - temps_consomme;
            // S'assurer que le temps restant n'est pas négatif
            temps_restant = Math.max(0, temps_restant);

            // Calculer l'heure de fin
            var heure_fin_formatee;
            if (temps_restant > 0) {
                var heure_actuelle = new Date();
                var heure_fin = new Date(heure_actuelle.getTime());
                // Ajouter le temps restant (en minutes) à l'heure actuelle
                heure_fin.setMinutes(heure_fin.getMinutes() + temps_restant);
                // Formater l'heure de fin en 'HH:MM'
                var heures = heure_fin.getHours().toString().padStart(2, '0');
                var minutes = heure_fin.getMinutes().toString().padStart(2, '0');
                heure_fin_formatee = heures + ':' + minutes;
            } else {
                heure_fin_formatee = 'N/A';
            }

            // Mettre à jour les éléments du DOM avec les nouvelles données
            
        //document.getElementById('totalheats').textContent = totalHeats;
        document.getElementById('consumedheats').textContent = consumedHeats + ' heats / ' + totalHeats;
            // Mettre à jour d'autres éléments si nécessaire

            // Mettre à jour les carrés de progression des heats
            var heatProgressContainer = document.querySelector('.heat-progress');
            heatProgressContainer.innerHTML = '';
            for (var i = 1; i <= totalHeats; i++) {
                var square = document.createElement('div');
                square.classList.add('heat-square');
                if (i <= consumedHeats) {
                    square.classList.add('consumed');
                }
                square.title = 'Heat ' + i + (i <= consumedHeats ? ' (consommé)' : ' (restant)');
                heatProgressContainer.appendChild(square);
            }

            // Mettre à jour le graphique
            createChart(temps_consomme, temps_restant, temps_total, heure_fin_formatee);
        
        })
        .catch(error => {
            console.error('Erreur lors du rafraîchissement des données :', error);
        });
}

// Rafraîchir les données toutes les 60 secondes (60000 millisecondes)
setInterval(refreshdata, 5000);

// Appel initial
refreshdata();

    
    
    var donutChart; // Déclarer la variable globale

function createChart(tempsConsomme, tempsRestant, tempsTotal, heure_fin_formatee) {
   
    // Vérifier si le graphique existe déjà
    if (donutChart) {
        // Mettre à jour les données du graphique existant
        donutChart.data.datasets[0].data = [tempsConsomme, tempsRestant];
        donutChart.update();
    } else {
        // Configuration du graphique
        var ctx = document.getElementById('donutChart').getContext('2d');
        donutChart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: ['Temps consommé', 'Temps restant'],
                datasets: [{
                    data: [tempsConsomme, tempsRestant],
                    backgroundColor: ['#76c7c0', '#e0e0e0'],
                    borderWidth: 0
                }]
            },
            options: {
                cutout: '70%',
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom'
                    },
                    tooltip: {
                        enabled: true
                    }
                }
            }
        });
    }

    // Mettre à jour le pourcentage affiché
    var pourcentage = (tempsConsomme / tempsTotal) * 100;
    pourcentage = Math.min(100, Math.max(0, pourcentage));
    var pourcentage_affiche = pourcentage.toFixed(2);
    document.querySelector('.chart-text').textContent = `Contest End ${heure_fin_formatee}`;

    // Mettre à jour l'heure de fin estimée
    //document.getElementById('heureFin').textContent = heure_fin_formatee;
}

    
   
</script>

<!-- Styles pour les carrés -->
<style>
.heat-progress {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    margin-top: 20px;
}

.heat-square {
    width: 30px;
    height: 30px;
    margin: 5px;
    border: 1px solid #ccc;
}

.heat-square.consumed {
    background-color: #28a745; /* Vert pour les heats consommés */
    border-color: #28a745;
}
</style>

</body>
</html>