<?php
// Connexion à la base de données
$host = 'localhost';  // Remplacez par votre hôte
$dbname = 'intranet_2019';  // Remplacez par le nom de votre base
$username = 'root';  // Remplacez par votre nom d'utilisateur
$password = 'rootroot';  // Remplacez par votre mot de passe

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Sélection des images BLOB depuis la base de données
    $sql = "SELECT id_owner as id,logo as image_blob, sigle as image_name FROM associations"; // Remplacez avec votre table et colonnes
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Définir le dossier de destination pour les images exportées
    $exportDir = 'logos/';  // Dossier où les images seront exportées

    // Vérifier si le dossier existe, sinon le créer
    if (!is_dir($exportDir)) {
        mkdir($exportDir, 0755, true);  // Créer le dossier avec les permissions adéquates
    }

    // Récupérer chaque image et l'enregistrer dans le dossier
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $imageBlob = $row['image_blob'];  // Le BLOB de l'image
        $imageName = $row['image_name'];  // Nom de l'image (optionnel, si stocké dans la base)
        $imageId = $row['id'];  // L'ID pour créer un nom unique si nécessaire

        // Si le nom de l'image est vide, on génère un nom par défaut
        if (empty($imageName)) {
            $imageName = 'image_' . $imageId . '.jpg';  // Par exemple, utiliser l'ID pour nommer l'image
        }

        // Déterminer le chemin complet du fichier image
        $filePath = $exportDir . $imageName;

        // Écrire le contenu BLOB dans un fichier image
        file_put_contents($filePath, $imageBlob);
    }

    echo "Images exportées avec succès dans le dossier '$exportDir'.";
} catch (PDOException $e) {
    echo "Erreur : " . $e->getMessage();
}
?>
