
document.addEventListener('DOMContentLoaded', function() {
  const scoreboard = document.getElementById('scoreboard');
  // Define an array of background colors
  const bgColors = ['danger', 'warning', 'primary', 'light', 'dark', 'info', 'light', 'dark'];
  var timer;
    let countDownDate; // Variable globale pour stocker la date cible
  let chronoInterval; // Variable pour stocker l'intervalle du chronomètre

    
    // Function to create the scores display
function createScoresDisplay(scores) {
  let score1 = "-" , score2 = "-";
  let redScoresFound = 0;
  let waveScoresHtml = '<div class="wave-scores-container align-items-left">';

  scores.forEach((scoreObj, index) => {
      // Vérifie si la valeur est null et passe à l'itération suivante si c'est le cas
  if (scoreObj.value === null) return;

    waveScoresHtml += `
      <div class="wave-score-pair align-items-left mr-2"  style="padding-right:10px;">
        
        <div class="scores" align="center" style="color: ${scoreObj.color};"><span>&#124 </span>${scoreObj.value == 11 ? '<span class="blinking">▲</span>' : scoreObj.value == 0 ? 'X' : scoreObj.value == 21 ? '<span class="waiting-for-score">⏳</span>' : scoreObj.value}</div>
      </div>`;
    if (scoreObj.color === 'red' && redScoresFound < 2) {
      redScoresFound++;
      if (redScoresFound === 1) score1 = scoreObj.value;
      else if (redScoresFound === 2) score2 = scoreObj.value;
    }
  });

  waveScoresHtml += '</div>';

  // Return the HTML string and the first two red scores found
  return { waveScoresHtml, score1, score2 };
}
scoreboard.innerHTML = '';
   
    const col = document.createElement('div');
    // Use Bootstrap's 'col' class for a full-width column, ensuring vertical layout
    col.className = 'col';
    
      
     // Create a unique ID for the details div and button 

    col.innerHTML = `

    <div class="heatcompetitor">
    <div class="align-items-center logobgcolor">
        <div class="align-items-center"><img class="responsive-logo"  src="medias/logo1.png"></div>
    </div>  
    <div class="align-items-center">
        <div class="title" style="white-space: normal; text-align:center;" id="categ"></div>    
    </div>
    <div class="headers align-items-center">
        <div class="text-center" style="text-align:center;">Round</div>
        <div class="name text-center" style="text-align:center;" id="round"></div>
    </div>
    <div class="headers align-items-center" >
        <div class="text-center" style="text-align:center;">Heat</div>
        <div class="name text-center" style="text-align:center;" id="heat"></div>
    </div>
    <div class="chronoback"> 
        
        <div class="chrono"  id="chrono"></div>

    </div>
</div>

 

<div id="competitors">
<div id="row-1" class="competitor-row">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
            
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
            <div class="scores-need" style="white-space: normal; "></div>
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>
  <!-- Ligne 2 -->
  <div id="row-2" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
        
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
            <div class="scores-need" style="white-space: normal; "></div>
         </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>

 <div id="row-3" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
         
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
            <div class="scores-need" style="white-space: normal; "></div>
          
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>

 <div id="row-4" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
          
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
          <div class="scores-need" style="white-space: normal; "></div>
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>
  </div>

 <div id="row-5" class="competitor-row" style="padding:0; margin:0;">
    <div class="globalcompetitor">
      <div class="competitor">
        <div style="padding: 0;"><img class="competitor-img"  src=''"></div>
        <div class="align-item-left">
          <div class="name"></div>
          <div style="float:left"><img class="responsive-flag competitor-flag" src="" width="30" height="auto"></div> 
          <div class="club"></div>
           
        </div>
        <div class="align-items-right" style="padding-right: 5%;">
          <div class="headers" style="color:black;">Total</div>
          <div class="score text-right"></div>
          <div class="scores-need" style="white-space: normal; "></div>
        </div>
        <div class="align-items-right hidden-desktop" style="padding-right: 5%;">
          
        </div>          
        <div class="wave-scores-container ws-container hidden-mobile align-items-left" style="width:100%;"></div>
      </div>
      <div class="wave-scores-container ws-container1 hidden-desktop align-items-center" style="width:100%;"></div>
    </div>

  </div>


</div>

  

`;
    scoreboard.appendChild(col);//entete
     
function refreshtimer() {
    
    console.log(countDownDate);
  // Obtenir la date et l'heure actuelles
  var now = new Date().getTime();

  // Calculer la distance entre maintenant et la date de compte à rebours
  var distance = countDownDate - now;

  // Calculer les jours, heures, minutes et secondes restants
  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
  var seconds = Math.floor((distance % (1000 * 60)) / 1000);

// Vérifier que minutes et seconds sont des nombres valides
minutes = isNaN(minutes) ? 0 : minutes;
seconds = isNaN(seconds) ? 0 : seconds;    
    
  // Afficher le timer au format MM:SS avec des zéros à gauche si nécessaire
  document.getElementById("chrono").innerHTML = String(minutes).padStart(2, '0') + ":" + String(seconds).padStart(2, '0');

  // Si le temps restant est inférieur à 5 minutes, changer la couleur en orange
  if (distance < 300000 && distance > 0) {  // 5 minutes en millisecondes et vérifier que c'est encore positif
    document.getElementById("chrono").style.color = "orange";
  }
  // Sinon, si supérieur à 5 minutes, remettre la couleur en blanc
  else if (distance >= 300000) {
    document.getElementById("chrono").style.color = "white";
  }

  // Si le compte à rebours est terminé, afficher "00:00" et arrêter le timer
  if (distance < 0) {
    clearInterval(timer);
    document.getElementById("chrono").innerHTML = "00:00";
    document.getElementById("chrono").style.color = "red"; // Optionnel : afficher en rouge lorsque terminé
  }
}     
    
 
 function refreshData() { 
   
     clearInterval(timer);
     
     // récupération du timer.
   fetch('getEventDate.php') // Remplacez 'script.php' par l'URL de votre script PHP
  .then(response => response.json()) // Transforme la réponse en JSON
  .then(data => {

    
    //var countDownDate = new Date("Jan 5, 2030 15:37:25").getTime();
    countDownDate = new Date(data.chrono).getTime();
    //console.log(data.chrono);
    //console.log("countDownDate :", countDownDate);
  
  //refreshtimer(countDownDate)
    
    
    
    
    
    // Set the date we're counting down to
//var countDownDate = new Date("Jan 5, 2030 15:37:25").getTime();

// Update the count down every 1 second


  

   
})    
  .catch(error => console.error("Erreur lors de la récupération des données:", error));  
     
   
     
     
    function updateCompetitors(competitors) {
  // Parcourir tous les compétiteurs reçus
  competitors.forEach((competitor, index) => {
    const rowId = `row-${index + 1}`; // Construire l'identifiant de la ligne
    const row = document.getElementById(rowId); // Obtenir la ligne par son identifiant
      document.getElementById("contest-title").innerHTML = competitor.intitule;
      document.getElementById("contest-subtitle").innerHTML = competitor.lieu;
      document.getElementById("categ").innerHTML = competitor.categ; 
      document.getElementById("round").innerHTML = competitor.round; 
      document.getElementById("heat").innerHTML = competitor.heat; 
      
    // Si la ligne existe, mettre à jour son contenu
    if (row) {
      // Mettre à jour les informations du compétiteur dans 'row'
        
      row.querySelector('.name').textContent = competitor.name.toLowerCase();
      row.querySelector('.club').textContent = competitor.club;
      row.querySelector('.score').textContent = competitor.score;
      row.querySelector('.scores-need').textContent = competitor.needs;
        row.querySelector('.scores-need').classList.add(`color-${competitor.ligne}`);
        row.style.display = 'block';
        const scores = createScoresDisplay(competitor.scores).waveScoresHtml;
      row.querySelector('.ws-container').innerHTML = createScoresDisplay(competitor.scores).waveScoresHtml;
        row.querySelector('.ws-container1').innerHTML = row.querySelector('.ws-container').innerHTML;
      const imgElement = row.querySelector('.competitor-img');
      imgElement.src = `photos/${competitor.photo}`; // Utilisez la bonne extension de fichier
      imgElement.alt = `Photo de ${competitor.name}`;
        imgElement.className=`competitor-img color-${competitor.ligne}`;
        
        
        
        // Utiliser 'onerror' pour définir une image par défaut en cas d'erreur de chargement de l'image
  //imgElement.onerror = function() {
//    this.onerror = null; // Éviter les boucles infinies en cas d'erreur sur l'image par défaut
//    this.src = 'photos/anonyme.png'; // Assurez-vous que le chemin de l'image par défaut est correct
//  };
        const flagElement = row.querySelector('.competitor-flag');
      flagElement.src = `${competitor.flag.toLowerCase()}`; // Utilisez la bonne extension de fichier
      flagElement.alt = `flag ${competitor.club}`;
        
        // Utiliser 'onerror' pour définir une image par défaut en cas d'erreur de chargement de l'image
    //flagElement.onerror = function() {
    //this.onerror = null; // Éviter les boucles infinies en cas d'erreur sur l'image par défaut
    //this.src = 'flags/noflag.png'; // Assurez-vous que le chemin de l'image par défaut est correct
  //};
        
      // Continuez avec les autres champs nécessaires
    }
  });

  // Cacher les lignes excédentaires si le nombre de compétiteurs est inférieur à 5
  for (let i = competitors.length + 1; i <= 5; i++) {
    const row = document.getElementById(`row-${i}`);
    if (row) {
      row.style.display = 'none';
    }
  }
}
 
     
    
 
  clearInterval(timer);
    // Fetch data from the PHP script
  fetch('getdata.php')
    .then(response => response.json())
    .then(competitors => {   
   
      
  updateCompetitors(competitors);
      
      competitors.forEach((comp, index) => {
    const col = document.createElement('div');
    // Use Bootstrap's 'col' class for a full-width column, ensuring vertical layout
    col.className = 'col';
    //const bgColor = bgColors[index % bgColors.length];
    const scores1 = createScoresDisplay(comp.scores); 
      
     // Create a unique ID for the details div and button
   
    //col.innerHTML = `<div class="wave-scores-container hidden-mobile align-items-left" style="width:100%;">${scores1.waveScoresHtml}</div>`;

          
          
   //<div class="scores">${scores1.waveScoresHtml}</div>   
    //scoreboard.appendChild(col);
      
});
})
 

    .catch(error => console.error('Error fetching data:', error));
}
    
    
    
 // Lancer une seule fois l'intervalle du chronomètre
  if (!chronoInterval) {
    chronoInterval = setInterval(refreshtimer, 1000); // Met à jour le chrono chaque seconde
  }

  // Exécuter immédiatement refreshData et planifier le rafraîchissement toutes les 10 secondes
  refreshData();
  setInterval(refreshData, 10000);
    
});