/* app.js */

document.addEventListener('DOMContentLoaded', function() {
  // Configure les cellules comme zones droppables et cliquables
  const gridCells = document.querySelectorAll('.grid-cell');
  gridCells.forEach(cell => {
    cell.addEventListener('dragover', dragOver);
    cell.addEventListener('drop', dropFile);
    cell.addEventListener('click', cellClick);
  });
});

function dragOver(e) {
  e.preventDefault();
}

function dropFile(e) {
  e.preventDefault();
  const cell = e.currentTarget;
  
  if (e.dataTransfer.files && e.dataTransfer.files.length > 0) {
    const file = e.dataTransfer.files[0];
    // Seul le nom du fichier est récupéré
    const fileName = file.name;
    // Affiche le nom dans la cellule
    cell.innerHTML = `<div class="video-in-cell" data-name="${fileName}" data-filename="${fileName}">${fileName}</div>`;
    
    const row = cell.getAttribute('data-row');
    const col = cell.getAttribute('data-col');
    
    // Prépare les données à envoyer (ici uniquement le nom)
    const data = {
      name: fileName,
      filename: fileName,
      row: row,
      col: col
    };
    
    fetch('save_info.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(data)
    })
    .then(response => response.text())
    .then(result => {
      console.log('Informations sauvegardées :', result);
    })
    .catch(error => {
      console.error('Erreur :', error);
    });
    
    // Nettoyage des données déposées
    e.dataTransfer.clearData();
  }
}

// Exemple de fonction pour lancer la lecture via VLC
function playVideo(filePath) {
  // filePath doit être complet, par exemple "file:///Users/votreNom/Videos/monvideo.mp4"
  const baseUrl = "http://localhost:8080/requests/status.xml";
  const command = "in_play";
  
  // On encode filePath pour s'assurer que les caractères spéciaux sont gérés correctement
  let url = `${baseUrl}?command=${command}&input=${encodeURIComponent(filePath)}`;
  
  // Correction : remplacer &amp; par & dans l'URL si cela a été généré par le navigateur ou une injection dans le HTML
  url = url.replace(/&amp;/g, '&');
  
  console.log("URL finale envoyée à VLC :", url);
  
  fetch(url)
    .then(response => response.text())
    .then(data => console.log("Commande envoyée à VLC :", data))
    .catch(error => console.error("Erreur :", error));
}



function cellClick(e) {
  // Si la cellule contient une vidéo, déclenche la lecture
  const cell = e.currentTarget;
  const videoElement = cell.querySelector('.video-in-cell');
  if (videoElement) {
    const fileName =  videoElement.getAttribute('data-filename');
    if (!fileName) {
      console.warn("Nom de fichier non disponible.");
      return;
    }
    // Construit un chemin d'accès préconfiguré basé sur le nom de fichier.
    // Par exemple, on suppose que les vidéos se trouvent dans le dossier "/videos/" sur le serveur.
    const videoPath =  encodeURIComponent(fileName);
    fetch(`play_video.php?path=${videoPath}`)
      .then(response => response.text())
      .then(result => {
        console.log('Commande envoyée à VLC :', result);
      })
      .catch(error => {
        console.error('Erreur :', error);
      });
  }
}
