<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Image avec Traitement</title>
    <style>
        #preview {
            max-width: 100%;
            max-height: 100%;
            margin: 10px 0;
        }
    </style>
</head>
    
    
<body>
    <h1>Upload et Traitement d'Image</h1>

    <?php
    // Connexion à la base de données
    require '../config_livescores2024.php';
    
    try {
        

        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Requête SQL pour récupérer les noms
        $sql = "SELECT nom FROM heats";  // Modifiez 'heats' en fonction de votre table
        $stmt = $pdo->prepare($sql);
        $stmt->execute();

        // Générer la liste déroulante (select) avec les noms
        echo "<form id='image-form' enctype='multipart/form-data'>";
        echo "<label for='name-select'>Choisir un nom :</label>";
        echo "<select id='name-select' name='competitor'>";
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "<option value='{$row['nom']}'>{$row['nom']}</option>";
        }
        echo "</select>";
        echo "<br><br>";
        echo "<input type='file' id='image-input' accept='image/*' required>";
        echo "<br><br>";
        echo "<button type='submit'>Uploader l'image</button>";
        echo "</form>";
    } catch (PDOException $e) {
        echo "Erreur : " . $e->getMessage();
    }
    ?>
    
    <canvas id="image-canvas" style="display:none;"></canvas>
    <img id="preview" alt="Prévisualisation de l'image"/>

    <script src="photo_script.js"></script>
</body>

</html>
