<?php
// Connexion à la base de données MySQL
require 'config_livescores2024.php';

// Première requête : initialisation des variables
$sql1 = "SET @rn := 0, @grp := '', @row_number = 0";
if (!mysqli_query($conn, $sql1)) {
    die("Erreur lors de l'initialisation des variables : " . mysqli_error($conn));
}

// Deuxième requête : le SELECT avec pivot
$sql2 = "
SELECT  c.categ, h.round,c.nom, c.club,
  sub.serie, h.heat,
  sub.concu,
  vague,
  if(w.value<10,format(w.value,2),w.value) AS value,
  MAX(IF(rn = 1, if(note<10,format(note,2),note), NULL)) AS note1,
  MAX(IF(rn = 2, if(note<10,format(note,2),note), NULL)) AS note2,
  MAX(IF(rn = 3, if(note<10,format(note,2),note), NULL)) AS note3,
  MAX(IF(rn = 4, if(note<10,format(note,2),note), NULL)) AS note4,
  MAX(IF(rn = 5, if(note<10,format(note,2),note), NULL)) AS note5,
  max(IF(rn = 1, natjuge, NULL)) AS flag1,
  max(IF(rn = 2, natjuge, NULL)) AS flag2,
  max(IF(rn = 3, natjuge, NULL)) AS flag3,
  max(IF(rn = 4, natjuge, NULL)) AS flag4,
  max(IF(rn = 5, natjuge, NULL)) AS flag5
 
FROM (
    SELECT 
       t.*,juges.natjuge,
       -- Si le groupe (défini par la concaténation de serie, concu et vague) est identique au précédent, incrémente rn, sinon le réinitialise à 1.
       @rn := IF(@grp = CONCAT(serie, '-', concu, '-', vague), @rn + 1, 1) AS rn,
       @grp := CONCAT(serie, '-', concu, '-', vague) AS grp
    FROM (SELECT   r.* FROM moyennes_notes mn  LEFT JOIN 
     resu r ON mn.serie=r.serie AND mn.concu=r.concu AND mn.vague=r.vague)  t
    LEFT JOIN 
    juges ON juges.idjuge=t.juge
    WHERE juge>0
    
    ORDER BY serie, concu, vague, juge
) AS sub
LEFT JOIN
concu c ON sub.concu=c.numpart
LEFT JOIN 
heats h ON h.serie=sub.serie AND h.concu=sub.concu
LEFT JOIN 
(SELECT * from live_waves WHERE VALUE<11) w ON w.serie=h.serie AND w.id=sub.vague AND h.ligne=w.competitor_id



";

$result = mysqli_query($conn, $sql2);
if (!$result) {
    die("Erreur lors de l'exécution de la requête SELECT : " . mysqli_error($conn));
}

// Vérifier s'il y a des résultats et les stocker dans un tableau
$data = array();
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = $row;
    }
    // Retourner les données au format JSON
    header('Content-Type: application/json');
    echo json_encode($data);
} else {
    echo "Aucun résultat trouvé";
}

// Fermer la connexion
mysqli_close($conn);
?>
