<?php
// Connexion à la base de données MySQL (ajustez les détails de connexion)
require 'config_livescores2024.php';

// Sélectionnez les données de votre table
$sql = "SELECT categ,nom,club,total,concat(value1,'-',VALUE2) AS maxwave,heat FROM heats h inner JOIN 
(SELECT 
    main.serie, 
    main.competitor_id, 
    MAX(main.value) AS value1, 
    MAX(sub.value) AS value2
FROM live_waves main
LEFT JOIN live_waves sub 
    ON main.competitor_id = sub.competitor_id 
   AND main.serie = sub.serie 
   AND ( sub.value < main.value 
         OR (sub.value = main.value AND sub.id <> main.id)
       )
WHERE main.value < 11 
GROUP BY main.serie, main.competitor_id
ORDER BY main.competitor_id) w ON h.serie=w.serie AND h.ligne=w.competitor_id
WHERE RANK=1 ORDER BY  categ,heat desc
 ";

$result = $conn->query($sql);

// Vérifier s'il y a des résultats
if ($result->num_rows > 0) {
    // Créer un tableau associatif pour stocker les résultats
    $data = array();

    // Parcourir chaque ligne de résultat
    while ($row = $result->fetch_assoc()) {
        // Ajouter chaque ligne au tableau
        $data[] = $row;
    }

    // Encoder le tableau en JSON
    $jsonData = json_encode($data);

    // Afficher le JSON
    echo $jsonData;
} else {
    echo "Aucun résultat trouvé";
}

// Fermer la connexion
$conn->close();
?>
