<?php
// Connexion à la base de données MySQL (ajustez les détails de connexion)
$servername = "localhost";
$username = "root";
$password = "rootroot";
$dbname = "surfware_template";

$conn = new mysqli($servername, $username, $password, $dbname);

// Vérifier la connexion
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Sélectionnez les données de votre table
$sql = "SELECT 
            T3.juge,
            nomjuge,
            COUNT(note) AS nbrenote,
            SUM(ecart) AS somecart,
            round(100 * SUM(ecart) / COUNT(note),2) AS ecartpondere
        FROM (
            SELECT 
                T2.serie,
                T2.concu,
                T2.juge,
                nomjuge,
                T2.vague,
                T2.note,
                T2.moyen,
                ROUND(ABS(T2.note - T2.moyen), 2) AS ecart
            FROM (
                SELECT 
                    resu.serie,
                    resu.concu,
                    resu.juge,
                    resu.vague,
                    T1.minot,
                    resu.note,
                    T1.maxnote,
                    T1.moyen
                FROM resu
                RIGHT JOIN (
                    SELECT 
                        resu.serie,
                        concu,
                        juge,
                        vague, 
                        MIN(note) AS minot, 
                        MAX(note) AS maxnote, 
                        CASE 
                            WHEN COUNT(note) > 2 THEN ROUND((SUM(note) - MAX(note) - MIN(note)) / (COUNT(note) - 2), 2) 
                            ELSE 0 
                        END AS moyen
                    FROM resu
                    GROUP BY serie, concu, vague
                ) AS T1 
                ON resu.serie = T1.serie AND resu.vague = T1.vague AND resu.concu = T1.concu
                ORDER BY concu, vague, juge
            ) AS T2
            LEFT JOIN juges ON T2.juge = juges.idjuge
        ) AS T3
        WHERE juge > 0
        GROUP BY juge
        ORDER BY ecartpondere
;
 ";

$result = $conn->query($sql);

// Vérifier s'il y a des résultats
if ($result->num_rows > 0) {
    // Créer un tableau associatif pour stocker les résultats
    $data = array();

    // Parcourir chaque ligne de résultat
    while ($row = $result->fetch_assoc()) {
        // Ajouter chaque ligne au tableau
        $data[] = $row;
    }

    // Encoder le tableau en JSON
    $jsonData = json_encode($data);

    // Afficher le JSON
    echo $jsonData;
} else {
    echo "Aucun résultat trouvé";
}

// Fermer la connexion
$conn->close();
?>
