<?php
// Connexion à la base de données MySQL (ajustez les détails de connexion)
$servername = "localhost";
$username = "root";
$password = "rootroot";
$dbname = "surfware_template";

$conn = new mysqli($servername, $username, $password, $dbname);

// Vérifier la connexion
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Sélectionnez les données de votre table
$sql = "SELECT r.*, format(w.moyenne,2) as moyenne FROM 

(SELECT 
    CONCAT('Wave Score #',vague) AS title,vague,
    MAX(CASE WHEN juge = 1 THEN note END) AS 'score1',
    MAX(CASE WHEN juge = 2 THEN note END) AS 'score2',
    MAX(CASE WHEN juge = 3 THEN note END) AS 'score3',
    MAX(CASE WHEN juge = 4 THEN note END) AS 'score4',
    MAX(CASE WHEN juge = 5 THEN note END) AS 'score5'
    
FROM resu 
WHERE serie IN (SELECT DISTINCT serie FROM bloque) 
  AND concu IN (SELECT concu FROM bloque WHERE ligne=1)
GROUP BY vague) r

LEFT JOIN 
(SELECT vague, (SUM(note)-MAX(note)-MIN(note))/(COUNT(note)-2) AS moyenne FROM resu 
WHERE serie IN (SELECT DISTINCT serie FROM bloque) 
  AND concu IN (SELECT concu FROM bloque WHERE ligne=1)
  GROUP BY vague) w ON r.vague=w.vague
  

ORDER BY r.vague desc limit 1;
;
 ";

$result = $conn->query($sql);

// Vérifier s'il y a des résultats
if ($result->num_rows > 0) {
    // Créer un tableau associatif pour stocker les résultats
    $data = array();

    // Parcourir chaque ligne de résultat
    while ($row = $result->fetch_assoc()) {
        // Ajouter chaque ligne au tableau
        $data[] = $row;
    }

    // Encoder le tableau en JSON
    $jsonData = json_encode($data);

    // Afficher le JSON
    echo $jsonData;
} else {
    echo "Aucun résultat trouvé";
}

// Fermer la connexion
$conn->close();
?>
