<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <style>
        /* Style global */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color:gainsboro;
            overflow-x: hidden;
        }
        .separator {
            border-top: 2px solid #000;
            margin: 20px 0;
        }
        .editable {
            background-color: #e3e6e4;
            cursor: pointer;
        }
        .editable:focus {
            outline: none;
            background-color: #e8f0fe;
        }
        .container {
            width: 75%;
            margin: 0 auto;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            text-align: center;
            border: 1px solid #ddd;
        }
        th {
            background-color:#0f2563;
            color: white;
        }
        .average-row {
            background-color:darkslategrey;
            color: white;
        }
        .coul-1 { background-color: orangered; }
        .coul-2 { background-color: yellow; }
        .coul-3 { background-color: lightskyblue; }
        .coul-4 { background-color: whitesmoke; }
        .coul-5 { background-color: darkslategray; }
    </style>    
    <title>Surfware Control Center</title>
</head>
<body>

<div class="table-container">

<?php
$servername = "localhost";
$username = "surfware";
$password = "rootroot";
$dbname = "surfware_template";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Requête SQL pour récupérer les scores et moyennes
$sql = "SELECT if(prio>0, CONCAT('P',prio),'') AS prio, concu.nom, concu.club, division, tour, heat, CONCAT('coul-', ligne) AS coul, 
        note1, note2, moyenne, livescores.`status`, interf, scores.`lines` AS targettime
        FROM bloque
        LEFT JOIN livescores ON bloque.concu = livescores.id
        LEFT JOIN concu ON bloque.concu = concu.numpart
        LEFT JOIN moyennes ON bloque.concu = moyennes.concu
        INNER JOIN scores
        WHERE (moyennes.serie IN (
        SELECT serie FROM bloque) OR (moyennes.serie IS NULL)) AND scores.id = 0
        ORDER BY moyenne DESC";

$result = $conn->query($sql);

// Préparer les données pour les tableaux
$headerData = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Calcul des moyennes formatées à ce stade
        $row['formated_moyenne'] = number_format(($row['note1'] + $row['note2']) / 2, 2);
        $headerData[] = $row;
    }
}

// Deuxième requête pour récupérer les notes des juges
$sql2 = "SELECT resu.serie, resu.concu, resu.vague, resu.juge, resu.note, moyennes_notes.moyenne, CONCAT('coul-', bloque.ligne) AS coul 
         FROM resu 
         LEFT JOIN moyennes_notes ON resu.serie = moyennes_notes.serie 
         AND resu.concu = moyennes_notes.concu 
         AND resu.vague = moyennes_notes.vague 
         LEFT JOIN bloque ON resu.concu = bloque.concu
         WHERE juge > 0 AND resu.serie IN (SELECT serie FROM bloque)
         ORDER BY concu, vague, juge";

$data = $conn->query($sql2);

// Regrouper les données par concurrent et vague
$groupedData = [];
$uniqueJudges = [];
$maxVague = 0;

if ($data->num_rows > 0) {
    while ($row = $data->fetch_assoc()) {
        $concu = $row['concu'];
        $vague = $row['vague'];
        $juge = $row['juge'];

        $groupedData[$concu][$vague][$juge] = $row;
        $groupedData[$concu]['color'] = $row['coul'];

        if (!in_array($juge, $uniqueJudges)) {
            $uniqueJudges[] = $juge;
        }
        if ($vague > $maxVague) {
            $maxVague = $vague;
        }
    }
}

// Afficher les deux tableaux après calcul
if (!empty($headerData)) {
    // Tableau 1 : Scores et moyennes
    echo "<table class='container'>";
    echo "<tr><th>Bio</th><th>Prio</th><th>Name</th><th>Club</th><th>Note 1</th><th>Note 2</th><th>Moyenne</th><th>Status</th></tr>";

    foreach ($headerData as $row) {
        echo "<tr class='{$row['coul']}'>";
        echo "<td><a href='http://livescores2024/athletedetails.php?concuId=" . urlencode($row['nom']) . "'><img src='bio.png' alt='Bio' /></a></td>";
        echo "<td>{$row['prio']}</td>";
        echo "<td>{$row['nom']}</td>";
        echo "<td>{$row['club']}</td>";
        echo "<td>{$row['note1']}</td>";
        echo "<td>{$row['note2']}</td>";
        echo "<td>{$row['formated_moyenne']}</td>";
        echo "<td>{$row['status']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    // Tableau 2 : Notes des juges par vague
    echo "<div class='separator'></div>";
    echo "<table class='container'>";
    echo "<tr><th>Judge</th>";
    for ($i = 1; $i <= $maxVague; $i++) {
        echo "<th>Wave $i</th>";
    }
    echo "<th>Note 1</th><th>Note 2</th><th>Moyenne</th></tr>";

    foreach ($groupedData as $concu => $vagues) {
        $color = $vagues['color'];

        foreach ($uniqueJudges as $juge) {
            echo "<tr class='{$color}'>";
            echo "<td>Judge $juge</td>";
            for ($i = 1; $i <= $maxVague; $i++) {
                echo "<td>" . (isset($vagues[$i][$juge]['note']) ? $vagues[$i][$juge]['note'] : '-') . "</td>";
            }
            echo "<td>-</td><td>-</td><td>-</td>";
            echo "</tr>";
        }
    }
    echo "</table>";
} else {
    echo "No Scores available yet";
}

$conn->close();
?>

</div>
</body>
</html>
