<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        /* Style global */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
            overflow-x: hidden;
        }
	.logo-container {
            position: absolute;
            top: 100px;  /* Position the logo 10px from the top */
            left: 50px; /* Position the logo 10px from the left */
        }
        .logo-container img {
            max-width: 300px;  /* Set the maximum width of the logo */
            height: auto;      /* Maintain the aspect ratio */
        }
        .container {
            width: 50%;  /* Limit to 50% of the screen width */
            margin: 0 auto;  /* Center the container */
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .header-left {
            font-size: 2.5em;
            text-align: left;
            flex: 1;
        }
        .header-center {
            text-align: center;
            flex: 1;
        }
        .header-center h2 {
            margin: 0;
            font-size: 1.5em;
        }
        .header-center h3 {
            margin: 0;
            font-size: 1.2em;
            font-weight: normal;
        }
        .header-right {
            text-align: right;
            flex: 1;
            font-size: 2.5em;
        }
        table {
            width: 100%;  /* Ensure table takes up the full width of the container */
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            text-align: center;
            border: 1px solid #ddd;
        }
        th {
            background-color:darkslategrey;
            color: white;
        }
        .average-row {
            background-color:darkslategrey; /* Couleur de la ligne des moyennes */
            color: white;
        }
        /* Couleurs modernes pour les concurrents */
        .coul-1 {
            background-color: orangered; /* Rose clair */
        }
        .coul-2 {
            background-color: yellow; /* Bleu clair */
        }
        .coul-3 {
            background-color: lightskyblue; /* Vert clair */
        }
        .coul-4 {
            background-color: whitesmoke; /* Jaune clair */
        }
        .coul-5 {
            background-color: darkslategray; /* Jaune clair */
        }
        /* Style responsive */
        @media (max-width: 768px) {
            th, td {
                padding: 5px;
                font-size: 2.5vh;  /* Ajuste la taille de la police pour les petits écrans */
            }
        }


    </style>    
    <title>Tableau Notes</title>
	<!-- JavaScript for auto-refresh -->
    	<script type="text/javascript">
        setInterval(function() {
            window.location.reload(); // Reload the page every 1000 milliseconds (1 second)
        }, 5000);
	</script>

</head>
<body>
<!-- Logo in the top left corner -->
<div class="logo-container">
    <img src="walkontechlogo.png" alt="Logo">
</div>

<div class="table-container">

      
        
        
   
<?php
$servername = "localhost";
$username = "root";
$password = "rootroot";
$dbname = "surfware_template";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT prio,concu.nom, concu.club,division,tour,heat,CONCAT('coul-',ligne) AS coul,note1,note2,moyenne,scores.`lines` FROM bloque 
LEFT JOIN livescores ON bloque.concu=livescores.id
LEFT JOIN concu ON bloque.concu=concu.numpart
LEFT JOIN moyennes ON bloque.concu=moyennes.concu
INNER JOIN scores
where moyennes.serie IN (SELECT serie FROM bloque) AND scores.id=0
ORDER BY moyenne desc";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Fetch all rows into an associative array
    $headerData = [];
    while ($row = $result->fetch_assoc()) {
        $headerData[] = $row;
    }

    // Check if headerData is not empty
    if (!empty($headerData)) {
        // Use the first row for the big header information
        $bigHeader = $headerData[0];

         // Display the custom header layout
        echo "<div class='header container'>";
        echo "<div class='header-left'>{$bigHeader['division']}</div>";
        echo "<div class='header-center'>";
        echo "<h3>Round</h3>";
        echo "<h2>{$bigHeader['tour']}</h2>";
        echo "</div>";
	echo "<div class='header-center'>";
        echo "<h3>Heat</h3>";
        echo "<h2>{$bigHeader['heat']}</h2>";
        echo "</div>";

        echo "<div class='header-center'><h2>Timer</h2></div>";
        echo "</div>";

        // Display Table
        echo "<table class='container'>";
        echo "<tr><th>Prio</th><th>Name</th><th>Club</th><th>Note 1</th><th>Note 2</th><th>Moyenne</th></tr>";

        foreach ($headerData as $row) {
            echo "<tr class='{$row['coul']}'>";
            echo "<td>{$row['prio']}</td>";
            echo "<td>{$row['nom']}</td>";
            echo "<td>{$row['club']}</td>";
            echo "<td>{$row['note1']}</td>";
            echo "<td>{$row['note2']}</td>";
            echo "<td>{$row['moyenne']}</td>";
            echo "</tr>";
        }

        echo "</table>";
    } else {
        echo "No data found.";
    }
} else {
    echo "No data found.";
}




$sql = "SELECT resu.serie, resu.concu,nom,resu.vague, resu.juge,resu.note,moyennes_notes.moyenne, CONCAT('coul-',bloque.ligne) AS coul FROM resu left join moyennes_notes 
on resu.serie=moyennes_notes.serie 
AND resu.concu=moyennes_notes.concu
AND resu.vague=moyennes_notes.vague
LEFT JOIN bloque ON resu.concu=bloque.concu
LEFT JOIN concu ON bloque.concu=concu.numpart
 WHERE juge>0 and resu.serie IN (SELECT serie FROM bloque)
 ORDER BY concu, vague,juge";

$data = $conn->query($sql);

// Vérifier s'il y a des résultats
if ($data->num_rows > 0) {


// Initialisation des classes CSS pour chaque 'concu'
$colors = [
    1 => 'coul-1',
    2 => 'coul-2',
    3 => 'coul-3',
    4 => 'coul-4',
    5 => 'coul-5',
];

// Regrouper les données par 'concu' et 'vague'
$groupedData = [];
$uniqueJudges = []; // Pour stocker les juges uniques
$maxVague = 0;

foreach ($data as $row) {
    $concu = $row['concu'];
    $vague = $row['vague'];
    $nom = $row['nom'];
    $juge = $row['juge'];
    $color = $row['coul'];
    
    $groupedData[$concu][$vague][$juge] = $row;
    $groupedData[$concu]['color'] = $color;  // Stocker la couleur par 'concu'
    $groupedData[$concu]['nom'] = $nom;  // Stocker le couleur par 'concu'
    
    // Ajouter les juges uniques
    if (!in_array($juge, $uniqueJudges)) {
        $uniqueJudges[] = $juge;
    }

    // Calculer le nombre maximum de vagues
    if ($vague > $maxVague) {
        $maxVague = $vague;
    }
}

// Trier les juges pour l'affichage ordonné
sort($uniqueJudges);

// Affichage du tableau
echo "<table border='1' cellpadding='5' cellspacing='0' style='width: 100%;'>"; // Added borders for the table and set full width

$firstConcu = true;  // Flag pour afficher les en-têtes uniquement la première fois

foreach ($groupedData as $concu => $vagues) {
    $color = $vagues['color'];  // Récupérer la couleur pour ce 'concu'
    
    if ($firstConcu) {
        // Affichage des en-têtes pour les vagues (seulement pour le premier concu)
        echo "<tr>";
        // echo "<th>Juge</th>";
        
        // Affichage des en-têtes pour les vagues (en fonction du max vague)
        for ($i = 1; $i <= $maxVague; $i++) {
            echo "<th>Vague $i</th>";
        }

        echo "</tr>";
        $firstConcu = false;
    }

    // Affichage des notes et moyenne dans une seule ligne
    echo "<tr>";
    // echo "<td>$nom</td>"; // Column title
 
    for ($i = 1; $i <= $maxVague; $i++) {
        echo "<td class='$color' style='padding: 0;'>"; // Remove padding for equal distribution
        
        $notes = [];
        $judgesHeaders = [];
        foreach ($uniqueJudges as $juge) {
            if (isset($vagues[$i][$juge]['note'])) {
                $notes[] = $vagues[$i][$juge]['note'];
                $judgesHeaders[] = "J" . $juge;  // Store the judge header with "J" prefix
            }
        }

        // Display moyenne on top
        echo "<div style='font-weight: bold; padding: 5px;'>" . (isset($vagues[$i][1]['moyenne']) ? $vagues[$i][1]['moyenne'] : '-') . "</div>";
        
        // Flex container for notes
        echo "<div style='display: flex; width: 100%;'>";  
        
        // Display each note with the corresponding judge header
        foreach ($notes as $index => $note) {
            echo "<div style='flex-grow: 1; border: 1px solid #000; padding: 5px; box-sizing: border-box; text-align: center;'>";
            echo "<div style='margin-bottom: 5px;'>$judgesHeaders[$index]</div>";  // Judge header without bold
            echo "<div style='font-weight: bold;'>$note</div>";  // Note value in bold
            echo "</div>";
        }

        // If less than 4 notes, add placeholders with judge headers
        for ($j = count($notes); $j < 4; $j++) {
            echo "<div style='flex-grow: 1; border: 1px solid #000; padding: 5px; box-sizing: border-box; text-align: center;'>";
            echo "<div style='margin-bottom: 5px;'>J-</div>";  // Placeholder judge header without bold
            echo "<div style='font-weight: bold;'>-</div>";  // Placeholder note value in bold
            echo "</div>";
        }
        
        echo "</div>";  // Close flexbox container
        
        echo "</td>";
    }
    
    echo "</tr>";
}

echo "</table>";





} else {
    echo "Aucun résultat trouvé";
}

// Fermer la connexion
$conn->close();
?>
</div>
</body>
</html>