<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <style>
        /* Style global */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color:gainsboro;
            overflow-x: hidden;
        }
.separator {
  border-top: 2px solid #000; /* Adjust thickness and color */
  margin: 20px 0; /* Adjust spacing between the tables */
}

            .editable {
            background-color: #e3e6e4;
            cursor: pointer;
        }
        .editable:focus {
            outline: none;
            background-color: #e8f0fe;
        }
    
	.logo-container {
            
            top: 50px;  /* Position the logo 10px from the top */
            left: 50px; /* Position the logo 10px from the left */
        }
        .logo-container img {
		width: 100%;
            max-width: 200px;  /* Set the maximum width of the logo */
            height: auto;      /* Maintain the aspect ratio */
        }
        .container {
            width: 75%;  /* Limit to 50% of the screen width */
            margin: 0 auto;  /* Center the container */
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .header-left {
            font-size: 1.5em;
            text-align: left;
            flex: 1;
        }
        .header-center {
            text-align: center;
            flex: 1;
        }
        .header-center h2 {
            margin: 0;
            font-size: 1.5em;
        }
        .header-center h3 {
            margin: 0;
            font-size: 1.2em;
            font-weight: normal;
        }
        .header-right {
            text-align: right;
            flex: 1;
            font-size: 2.5em;
        }
	.chrono {
            margin: 0;
            font-size: 1.5em;
        }

        table {
            width: 100%;  /* Ensure table takes up the full width of the container */
            border-collapse: collapse;
            margin-bottom: 20px;
        }
	tr {
            line-height: 13px;
	    font-size: 1.2em;
        }
        th, td {
            padding: 10px;
            text-align: center;
            border: 1px solid #ddd;
        }
        th {
            background-color:#0f2563;
            color: white;
	    
        }
        statheader {
            background-color:#103c94;
            color: white;
	    
        }

        .average-row {
            background-color:darkslategrey; /* Couleur de la ligne des moyennes */
            color: white;
	    
        }
        /* Couleurs modernes pour les concurrents */
        .coul-1 {
            background-color: orangered; /* Rose clair */
        }
        .coul-2 {
            background-color: yellow; /* Bleu clair */
        }
        .coul-3 {
            background-color: lightskyblue; /* Vert clair */
        }
        .coul-4 {
            background-color: whitesmoke; /* Jaune clair */
        }
        .coul-5 {
            background-color: darkslategray; /* Jaune clair */
        }
.narrow-table {
  width: auto; /* Automatically adjusts to content width */
  border-collapse: collapse; /* Removes spacing between cells */
}

.narrow-table th,
.narrow-table td {
  padding: 5px; /* Reduce padding for narrow cells */
  border: 1px solid #ccc; /* Optional: Add borders for clarity */
  text-align: left; /* Align text to the left */
  white-space: nowrap; /* Prevent text from wrapping */
}

.narrow-table th {
  /* background-color: #f4f4f4;  Optional: Add background color for headers */
}

        /* Style responsive */
        @media (max-width: 768px) {
            th, td {
                padding: 5px;
                font-size: 2.5vh;  /* Ajuste la taille de la police pour les petits écrans */
            }
        }

      
    
        
        
        

    </style>    
    <title>Surfware Controle center</title>
	
    	

<!-- JavaScript for real-time remaining time update -->
    <script type="text/javascript">
        function updateRemainingTime(targetTimeSRC) {
            setInterval(function() {

const targetTime = new Date(targetTimeSRC); // Date en UTC

	const now = new Date(); // L'heure actuelle
const nowUTC = new Date(now.toISOString()); // Convertir en UTC

const diff = targetTime - nowUTC; // Calculer le temps restant en millisecondes

                // Get the current time
                //var currentTime = new Date();

                // Parse target time
                //var targetParts = targetTime.split(':');
                //var targetDate = new Date();
                //targetDate.setHours(targetParts[0], targetParts[1], targetParts[2]);

                // Calculate the difference
                //var diff = targetDate - currentTime;

                // If time has passed, set remaining time to "00:00"
                if (diff <= 0) {
                    document.getElementById('remaining-time').innerText = "00:00";
                    return;
                }

                // Convert the difference to hours, minutes, and seconds
                var hours = Math.floor(diff / (1000 * 60 * 60));
                var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((diff % (1000 * 60)) / 1000);

                // Format the time as HH:MM:SS
                var formattedTime = 
		    (hours < 10 ? "0" : "") + hours + ":" +
                    (minutes < 10 ? "0" : "") + minutes + ":" +
                    (seconds < 10 ? "0" : "") + seconds;

                // Update the remaining time on the page
                document.getElementById('remaining-time').innerText = formattedTime;
            }, 1000);
        }
        
    </script>

</head>
<body>



<div class="table-container">
   
<?php
$servername = "localhost";
$username = "surfware";
$password = "rootroot";
$dbname = "surfware_template";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT if(prio>0, CONCAT('P',prio),'') AS prio,concu.nom, concu.club,division,tour,heat, CONCAT('coul-',ligne) AS coul,format(note1,2) as note1,format(note2,2) as note2 ,format(moyenne,2) as formated_moyenne,livescores.`status`,interf, scores.`lines` AS targettime
FROM bloque
LEFT JOIN livescores ON bloque.concu=livescores.id
LEFT JOIN concu ON bloque.concu=concu.numpart
LEFT JOIN moyennes ON bloque.concu=moyennes.concu
INNER JOIN scores
WHERE (moyennes.serie IN (
SELECT serie
FROM bloque) OR (moyennes.serie IS NULL)) AND scores.id=0
ORDER BY moyenne DESC";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Fetch all rows into an associative array
    $headerData = [];
    while ($row = $result->fetch_assoc()) {
        $headerData[] = $row;
    }

    // Check if headerData is not empty
    if (!empty($headerData)) {
        // Use the first row for the big header information
        $bigHeader = $headerData[0];


       // JavaScript to update remaining time every second
        echo "<script type='text/javascript'>
                document.addEventListener('DOMContentLoaded', function() {
                    updateRemainingTime('{$bigHeader['targettime']}');
                });
              </script>";


         // Display the custom header layout
        echo "<div class='header container'>";
        echo "<div class='logo-container'>";
        echo "<img src='walkontechlogo.png'' alt='Logo'>";
        echo "</div>";
        echo "<div class='header-center'><h2>{$bigHeader['division']}</h2></div>";
        echo "<div class='header-center'>";
        echo "<h3>Round</h3>";
        echo "<h2>{$bigHeader['tour']}</h2>";
        echo "</div>";
	echo "<div class='header-center'>";
        echo "<h3>Heat</h3>";
        echo "<h2>{$bigHeader['heat']}</h2>";
        echo "</div>";
	echo "<div class='header-center chrono'>";
        
        echo "<h2><span id='remaining-time'></span></h2>";
        echo "</div>";
        echo "</div>";

        // Display Table
        echo "<table class='container'>";
        echo "<tr><th>Bio</th><th></th><th>Name</th><th>Club</th><th>Note 1</th><th>Note 2</th><th>Moyenne</th><th>Needs</th></tr>";

        foreach ($headerData as $row) {
            echo "<tr class='{$row['coul']}'>";
            echo "<td><a href='http://livescores2024/athletedetails.php?concuId=" . str_replace(' ', '', $row['nom']) . "'><img src='bio.png' alt='Bio' /></a></td>";

            echo "<td>{$row['prio']}</td>";
            echo "<td>{$row['nom']}</td>";
            echo "<td>{$row['club']}</td>";

            // Adding IDs to the Note cells for future updates
            echo "<td id='note1-{$row['nom']}'>{$row['note1']}</td>"; // Best average
            echo "<td id='note2-{$row['nom']}'>{$row['note2']}</td>"; // Second best average
            echo "<td id='moyenne-{$row['nom']}'>{$row['formated_moyenne']}</td>"; // Total of averages
            echo "<td>{$row['status']}</td>";

            echo "</tr>";
        }

        echo "</table>";

    } else {
        echo "No Scores available yet 3";
    }
} else {
    echo "No Scores available yet 4";
}

echo "</div>";
echo "<div>";


$sql = "SELECT resu.serie, resu.concu,resu.vague, resu.juge,resu.note,moyennes_notes.moyenne, CONCAT('coul-',bloque.ligne) AS coul FROM resu left join moyennes_notes 
on resu.serie=moyennes_notes.serie 
AND resu.concu=moyennes_notes.concu
AND resu.vague=moyennes_notes.vague
LEFT JOIN bloque ON resu.concu=bloque.concu
 WHERE juge>0 and resu.serie IN (SELECT serie FROM bloque)
 ORDER BY concu, vague,juge";

$data = $conn->query($sql);

// Vérifier s'il y a des résultats
if ($data->num_rows > 0) {


// Initialisation des classes CSS pour chaque 'concu'
$colors = [
    1 => 'coul-1',
    2 => 'coul-2',
    3 => 'coul-3',
    4 => 'coul-4',
    5 => 'coul-5',
];

// Regrouper les données par 'concu' et 'vague'
$groupedData = [];
$uniqueJudges = []; // Pour stocker les juges uniques
$maxVague = 0;

foreach ($data as $row) {
    $concu = $row['concu'];
    $vague = $row['vague'];
    $juge = $row['juge'];
    $color = $row['coul'];
    
    $groupedData[$concu][$vague][$juge] = $row;
    $groupedData[$concu]['color'] = $color;  // Stocker la couleur par 'concu'
    
    // Ajouter les juges uniques
    if (!in_array($juge, $uniqueJudges)) {
        $uniqueJudges[] = $juge;
    }
	// Calculer le nombre maximum de vagues
        if ($vague > $maxVague) {
            $maxVague = $vague;
        }

}

// Trier les juges pour l'affichage ordonné
sort($uniqueJudges);

echo "<div class='separator'></div>";


echo "<div style='width:90%; float:left;'>";
// Affichage du tableau
echo "<table style='background-color: #e3e6e4;'>";

$firstConcu = true;  // Flag pour afficher les en-têtes uniquement la première fois

foreach ($groupedData as $concu => $vagues) {
    $color = $vagues['color'];  // Récupérer la couleur pour ce 'concu'
    
    if ($firstConcu) {
        // Affichage des en-têtes pour les vagues (seulement pour le premier concu)
        echo "<tr>";
        echo "<th style='width:100px'>Juge</th>";
        
        // Affichage des en-têtes pour les vagues (en fonction du max vague)
        for ($i = 1; $i <= 15; $i++) {
            echo "<th>W$i</th>";
        }
        // En-têtes pour les nouvelles colonnes à la 17ème, 18ème et 19ème position
        echo "<th>Note 1</th><th>Note 2</th><th>Moyenne</th>"; 
        echo "</tr>";
        $firstConcu = false;
    }

    // Affichage des notes par juge pour chaque vague
    foreach ($uniqueJudges as $juge) {  // Utiliser les juges uniques extraits des données
        echo "<tr>";
        echo "<td>J$juge</td>";
        $i = 0;
        foreach ($vagues as $key => $juges) {
            if ($key !== 'color') {  // Ignorer la clé 'color'
                echo "<td class='$color editable' contenteditable='true' data-concu='$concu' data-vague='$key' data-juge='$juge'>";
                echo isset($juges[$juge]['note']) ? $juges[$juge]['note'] : '-';
                echo "</td>";
                $i++;
            }
        }
        // Remplir les cellules restantes jusqu'à 15 vagues
        for ($j = $i + 1; $j <= 15; $j++) {
            echo "<td class='$color'></td>";
        }
        echo "</tr>";
    }

    // Calcul de la moyenne pour chaque vague
    $moyennes = []; // Tableau pour stocker les moyennes

    echo "<tr class='average-row'>";
    echo "<td>Moyenne</td>";
    foreach ($vagues as $key => $juges) {
        if ($key !== 'color') {  // Ignorer la clé 'color'
            // Récupérer toutes les notes pour cette vague
            $notes = [];
            foreach ($uniqueJudges as $juge) {
                if (isset($juges[$juge]['note']) && $juges[$juge]['note'] !== '-') {
                    $notes[] = $juges[$juge]['note'];
                }
            }

            // Vérifier si le nombre de notes est égal au nombre total de juges
            if (count($notes) === count($uniqueJudges)) {
                // Calculer la moyenne en fonction du nombre de notes
                if (count($notes) == 3) {
                    $moyenne = array_sum($notes) / 3;
                } elseif (count($notes) > 3) {
                    // Enlever la plus petite et la plus grande note
                    sort($notes);
                    array_shift($notes); // Retirer la plus petite
                    array_pop($notes);   // Retirer la plus grande
                    $moyenne = array_sum($notes) / count($notes);
                }
            } else {
                $moyenne = '-'; // Indiquer qu'il manque des notes
            }

            // Stocker la moyenne dans le tableau des moyennes
            if ($moyenne !== '-') {
                $moyennes[] = $moyenne; // Ajouter la moyenne si elle est valide
            }

            // Afficher la moyenne dans la cellule correspondante
            echo "<td>";
            echo $moyenne !== '-' ? number_format($moyenne, 2) : '-';
            echo "</td>";
        }
    }

    // Calculer le total des deux meilleures moyennes
    if (count($moyennes) > 0) {
        // Trier les moyennes par ordre décroissant
        rsort($moyennes);
        // Prendre les deux meilleures moyennes
        $topTwoMoyennes = array_slice($moyennes, 0, 2);
        // Calculer le total
        $totalMoyennes = array_sum($topTwoMoyennes);
    } else {
        $totalMoyennes = '-'; // Indiquer qu'il n'y a pas de moyennes valides
    }

    // Affichage des deux meilleures moyennes et du total dans les colonnes 17, 18 et 19
    echo "<td id='note1-{$concu}'>" . ($topTwoMoyennes[0] ?? '-') . "</td>"; // Note1
    echo "<td id='note2-{$concu}'>" . ($topTwoMoyennes[1] ?? '-') . "</td>"; // Note2
    echo "<td id='moyenne-{$concu}'>" . ($totalMoyennes !== '-' ? number_format($totalMoyennes, 2) : '-') . "</td>"; // Total

    echo "</tr>";
}

echo "</table>";
echo "</div>";


}
?>
</div>
    
<script type="text/javascript">
    let refreshInterval;

    function startAutoRefresh() {
        // Démarre le rafraîchissement toutes les 5 secondes
        refreshInterval = setInterval(function() {
            window.location.reload(); // Recharge la page
        }, 5000);
    }

    function stopAutoRefresh() {
        // Arrête le rafraîchissement automatique
        clearInterval(refreshInterval);
    }

    // Démarre le rafraîchissement automatique au chargement de la page
    window.onload = function() {
        startAutoRefresh();

        // Ajoute un événement sur toutes les cellules éditables
        document.querySelectorAll('.editable').forEach(cell => {
            // Désactiver le rafraîchissement lors de l'édition
            cell.addEventListener('focus', function() {
                stopAutoRefresh(); // Arrête le rafraîchissement pendant l'édition
            });

            // Intercepter la touche "Entrée" pour éviter le retour chariot
            cell.addEventListener('keydown', function(event) {
                if (event.key === "Enter") {
                    event.preventDefault(); // Empêche le retour chariot
                    this.blur(); // Simule la perte de focus pour valider l'édition
                }
            });

            // Réactiver le rafraîchissement lorsque l'édition est terminée (perte de focus)
            cell.addEventListener('blur', function() {
                // Effectuer ici la mise à jour via AJAX si nécessaire
                let newValue = this.innerText.trim();
                let concu = this.getAttribute('data-concu');
                let vague = this.getAttribute('data-vague');
                let juge = this.getAttribute('data-juge');

                updateCell(concu, vague, juge, newValue);

                // Redémarre le rafraîchissement après 2 secondes pour laisser le temps à l'édition
                setTimeout(startAutoRefresh, 2000);
            });
        });
    };

    // Fonction pour envoyer la mise à jour via AJAX
    function updateCell(concu, vague, juge, newValue) {
        fetch('updateCell.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ concu, vague, juge, note: newValue })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                console.log('Cellule mise à jour avec succès');
                
                
            } else {
                console.error('Erreur de mise à jour de la cellule');
            }
        })
        .catch(error => {
            console.error('Erreur lors de la requête AJAX :', error);
        });
    }
</script>


</body>
</html>