document.addEventListener('DOMContentLoaded', () => {
    const categoriesContainer = document.getElementById('files-nav');
    const roundsContainer = document.getElementById('rounds-nav');
    const heatsContainer = document.getElementById('matches-container');

    // Function to fetch categories and display them
    function fetchCategories() {
        fetch('getheats.php')
            .then(response => response.json())
            .then(data => {
                categoriesContainer.innerHTML = '';
                data.forEach(category => {
                    const categoryDiv = document.createElement('div');
                    categoryDiv.classList.add('file-entry');
                    categoryDiv.textContent = category.categ;
                    
                    categoryDiv.onclick = () => {
                    // Enlever la classe 'selected' de tous les enfants de 'files-nav'
                    document.querySelectorAll('#files-nav .file-entry').forEach(entry => {
                        entry.classList.remove('selected');
                        fetchRounds(category.categ);
                    });
                    // Ajouter la classe 'selected' à l'élément cliqué
                categoryDiv.classList.add('selected');

                };
                    categoriesContainer.appendChild(categoryDiv);
                    
                });
            })
            .catch(error => console.error('Error fetching categories:', error));
    }

    // Function to fetch and display rounds for a selected category
    function fetchRounds(category) {
        fetch(`getrounds.php?category=${encodeURIComponent(category)}`)
            .then(response => response.json())
            .then(data => {
                roundsContainer.innerHTML = '';
                data.forEach(round => {
                    const roundDiv = document.createElement('div');
                    roundDiv.classList.add('round-entry');
                    roundDiv.textContent = round.round.trim();
                    
                     roundDiv.onclick = () => {
                    // Enlever la classe 'selected' de tous les enfants de 'files-nav'
                    document.querySelectorAll('#rounds-nav .round-entry').forEach(entry => {
                        entry.classList.remove('selected');
                        fetchHeats(category, round.round.trim());
                    });
                    // Ajouter la classe 'selected' à l'élément cliqué
                roundDiv.classList.add('selected');
                
                };
                    roundsContainer.appendChild(roundDiv);
                });
            })
            .catch(error => console.error('Error fetching rounds:', error));
    }

    
function transformHeatsData(data) {
    const result = {};

    data.forEach(item => {
        const { serie, heat, lycra, nom, club, rank, total } = item;

        if (!result[serie]) {
            result[serie] = {};
        }

        if (!result[serie][heat]) {
            result[serie][heat] = [];
        }

        result[serie][heat].push({
            lycra,
            nom,
            club,
            rank,
            total
        });
    });

    return result;
}

    
    // Function to fetch and display heats data for a selected round
    function fetchHeats(category, round) {
        fetch(`getdataheats.php?category=${encodeURIComponent(category)}&round=${encodeURIComponent(round)}`)
            .then(response => response.json())
            .then(data => {
                // Afficher les données transformées
            
        displayData(data);
            })
            .catch(error => console.error('Error fetching heats data:', error));
    }

    
    function displayData(data) {
    const container = document.getElementById('matches-container'); // Le conteneur HTML pour afficher les données
        container.innerHTML='';
  let heatOrder = 1; // Initialiser un compteur pour le numéro d'ordre des heats      
    for (const [serie, heats] of Object.entries(data)) {
        // Créer un conteneur pour chaque série
        //const serieDiv = document.createElement('div');
        //serieDiv.classList.add('match');
        //serieDiv.innerHTML = ``;

        

for (const [heat, competitors] of Object.entries(heats)) {
    // Créer un conteneur pour chaque heat
    const heatDiv = document.createElement('div');
    heatDiv.classList.add('match');

    // Ajouter le titre du heat avec le numéro d'ordre
    heatDiv.innerHTML += `
        <div class='heat-title'>HEAT ${heatOrder}</div>  <!-- Utiliser le numéro d'ordre -->
        <div class='heat-details-title'><a href="livescoreshisto.php?heatNumber=${serie}" target="_blank">Details</a></div>`;

    // Ajouter les compétiteurs
    competitors.forEach(competitor => {
        let srcrankAndHeat = '';
        let nom = '';
        let club = '';
        let rank = '';
        let total = '';
        
        if (competitor.srcrank !== null && competitor.srcheat !== null) {
                    srcrankAndHeat = `<div>${competitor.srcrank}.${competitor.srcheat}</div>`;
                }
        
        if (competitor.concu !== null && competitor.nom !== null) {
            nom = `<div>${competitor.nom}</div>`;
            club = `<div>${competitor.club}</div>`;
        } else {
            nom = srcrankAndHeat;
        }
        if (competitor.rank !== null && competitor.total !== null) {
            rank = `<div>${competitor.rank}</div>`;
            total = `<div>${competitor.total}</div>`;
        }
        
        heatDiv.innerHTML += `
            <div class='heat-competitor'>
                <div class='competitor-photo-container'>
                    <img class='competitor-img color-${competitor.ligne}' src='photos/${competitor.photo}'>
                </div>
                <div>
                    <div class='competitor-detail detail-name'>
                        ${nom}
                    </div>
                    <div class="nationality">
                        <img class='competitor-flag' src='${competitor.flag.toLowerCase()}'>
                        <div class='competitor-detail detail-country'>${club}</div>
                    </div>
                </div>
                <div class='competitor-detail score'>${total}</div>
            </div>
        `;
    });

    container.appendChild(heatDiv);

    // Incrémenter le compteur pour le prochain heat
    heatOrder++;
}


        //container.appendChild(serieDiv);
    }
}
    
    // Initialize fetching categories
    fetchCategories();
});
