<?php
header('Access-Control-Allow-Origin: *'); // Allow all domains. Adjust if you want to be more restrictive
//header('Content-Type: application/json'); // Set appropriate content type for JSON data
require 'config_livescores2024.php';

$heatNumber= $_GET["heatNumber"];


// Fetch competitors and their scores
$sql = "SELECT hi.*, c.*,s.serie,s.id, s.value, s.color, IFNULL(p.photo,'../photos/anonyme.png') AS photo,if(ISNULL(cn.code2l),'flags/noflag.png', cn.code2l) AS flag
FROM `heathisto` hi
LEFT JOIN competitors c ON hi.compete = c.serie
LEFT JOIN live_waves s ON hi.compete = s.serie AND c.competitor_id= s.competitor_id
LEFT JOIN live_photos p ON c.name=p.competitor
LEFT JOIN (
SELECT noc as code3l,replace(flag,'../','') AS code2l  FROM flags
UNION
SELECT code3l, CONCAT('flags/',code2l,'.svg') AS code2l
FROM country) cn ON c.club=cn.code3l WHERE hi.compete=".$heatNumber." ORDER BY c.position, s.id";
$result = $conn->query($sql);

$competitors = [];
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $competitorId = $row['competitor_id'];
        if (!isset($competitors[$competitorId])) {
            $competitors[$competitorId] = $row;
            $competitors[$competitorId]['scores'] = [];
        }
        $competitors[$competitorId]['scores'][] = ['value' => $row['value'], 'color' => $row['color']];
    }
}

echo json_encode(array_values($competitors));

$conn->close();
?>
